package org.osgeo.mapguide;


/**
 * Defines the type of a geodetic transformation method
 *
 */
public class MgCoordinateSystemGeodeticTransformationMethod
{
   
/**
 * None
 *
 */

   public static final int None = 0 ; 
   
/**
 * Use the Molodensky transformation to convert to WGS84
 *
 */

   public static final int Molodensky = 1 ; 
   
/**
 * Use the Multiple Regression Transformation formulas.
 * If such a definition is not available, default to the
 * Bursa/Wolfe Seven Parameter Transformation.
 *
 */

   public static final int MReg = 2 ; 
   
/**
 * Use the Bursa/Wolfe to convert to WGS84, default to
 * Molodensky if the necessary parameters are not present.
 *
 */

   public static final int Bursa = 3 ; 
   
/**
 * Use the NADCON or Canadian National Transformation
 * emulation as appropriate to convert to NAD83, and
 * consider the result to be WGS84 coordinates.
 *
 */

   public static final int NAD27 = 4 ; 
   
/**
 * Consider the coordinates to be WGS84 coordinates already, no shift is to be performed.
 *
 */

   public static final int NAD83 = 5 ; 
   
/**
 * The coordinates are WGS84 coordinates already, no datum shift is required
 *
 */

   public static final int WGS84 = 6 ; 
   
/**
 * Use an internal formula to convert to WGS84
 *
 */

   public static final int WGS72 = 7 ; 
   
/**
 * Use the NADCOM algorithm, but use the HPGN data
 * files, to shift the coordinates to NAD83, then
 * consider the result to be WGS84 coordinates
 * without any further datum shift
 *
 */

   public static final int HPGN = 8 ; 
   
/**
 * Seven Parameter Transformation
 *
 */

   public static final int SevenParameter = 9 ; 
   
/**
 * AGD66<->GDA94 via Grid Files
 *
 */

   public static final int AGD66 = 10 ; 
   
/**
 * Three Parameter Transformation - Obsolete technique that is kept around for backward compatibility
 *
 */

   public static final int ThreeParameter = 11 ; 
   
/**
 * Six Parameter Transformation
 *
 */

   public static final int SixParameter = 12 ; 
   
/**
 * Four Parameter Transformation
 *
 */

   public static final int FourParameter = 13 ; 
   
/**
 * AGD84<->GDA94 via Grid Files
 *
 */

   public static final int AGD84 = 14 ; 
   
/**
 * NZGD49<->NZGD2K via Grid File
 *
 */

   public static final int NZGD49 = 15 ; 
   
/**
 * ATS77<->NAD83 via Grid Files
 *
 */

   public static final int ATS77 = 16 ; 
   
/**
 * Is GDA94, no shift required.
 *
 */

   public static final int GDA94 = 17 ; 
   
/**
 * Is NZGD2000, no shift required.
 *
 */

   public static final int NZGD2K = 18 ; 
   
/**
 * NAD83<->CSRS Via Grid Files.
 *
 */

   public static final int CSRS = 19 ; 
   
/**
 * TOKYO<->JGD2k via Grid Files
 *
 */

   public static final int TOKYO = 20 ; 
   
/**
 * NTF<->RGF93 via Grid File
 *
 */

   public static final int RGF93 = 21 ; 
   
/**
 * ED50 <--> ETRF89 via Grid Files
 *
 */

   public static final int ED50 = 22 ; 
   
/**
 * DHDN<->ETRF89 via Grid Files
 *
 */

   public static final int DHDN = 23 ; 
   
/**
 * Is ETRF89, no shift required
 *
 */

   public static final int ETRF89 = 24 ; 
   
/**
 * Local Geodetic Reference System
 *
 */

   public static final int Lclgrf = 99 ; 
   
/**
 * Geocentric Translation
 *
 */

   public static final int Geocentric = 25 ; 
   
/**
 * Swiss Ch1903 to CH1903+
 *
 */

   public static final int CHENYX = 26 ; 
   
}

