package org.osgeo.mapguide;


/**
 * An enumeration of the various types of specialized grids/graticules
 * currently supported.  A specialized grid is one for which specific
 * standards exist to which the results of this feature are compliant with.
 * A generic grid is a simple non-standardized grid of a coordinate system
 * drawn in a viewport based on another coordinate system. <p>
 * The values assigned are intended to support grouping standardized grids
 * with similar features and is currently entirely arbitrary.  Using a
 * numeric literal instead of thes names of the defined constants is a sure
 * way to write code that will get broken in the future.
 *
 */
public class MgCoordinateSystemGridSpecializationType
{
   
/**
 * Not specified yet, initialize to this value.
 *
 */

   public static final int None = 0 ; 
   
/**
 * Generic grid of a specified coordinate system; may be
 * geographic or projected.
 *
 */

   public static final int Generic = 1 ; 
   
/**
 * Specialized grid: MGRS (Military Grid Reference System)
 *
 */

   public static final int MGRS = 17 ; 
   
/**
 * Specialized grid: USNG (United States National Grid)
 *
 */

   public static final int USNG = 18 ; 
   
/**
 * Indicates the failure of an algorithm or other problem.
 *
 */

   public static final int Unknown = 65366 ; 
   
}

