/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCoordinateSystemGridSpecification} is an object that is used to
 * convey all the parameters necessary for the generation of a grid/graticule
 * lumped into a single object for convenience.  Thus, adding a parameter
 * determined to be necessary at a later time does not alter a lot of calling
 * sequences.
 * Note that this interface is an abstract interface.  There is code
 * associated with the implementation of this interface which is used to
 * handle the conversion of parameters between the various unit systems.
 * Thus, one obtains a {@link MgCoordinateSystemGridSpecification} from the
 * {@link MgCoordinateSystemFactory} object.
 * Note that all values are provided in the units specified within the object.
 * The units used in this object do <b>not</b> need to be the same as any
 * coordinate system involved in the generation of a grid, although the
 * <b>type</b> of unit must be consistent with the type of grid being drawn.
 * That is, specifying a Angular unit type when drawing a UTM grid will cause
 * an exception at the time the request for (say) grid lines is issued.
 *
 * @since  2.2 */
 public class MgCoordinateSystemGridTick extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGridTick(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemGridTickToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGridTick() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemGridTick(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGridTick obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets whether this grid tick is on a grid line
 *
 * @return  true if this grid tick is on a grid line. false otherwise
 */
 public boolean GetIsOnGridLine() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGridTick_GetIsOnGridLine(swigCPtr);
  }

  
/**
 * Gets the tick orientation (see {@link MgCoordinateSystemGridOrientation} for valid values)
 *
 * @return  The tick orientation
 */
 public int GetTickOrientation() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGridTick_GetTickOrientation(swigCPtr);
  }

  
/**
 * Gets the tick value
 *
 * @return  The tick value
 */
 public double GetValue() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemGridTick_GetValue(swigCPtr);
  }

  
/**
 * Gets the tick position
 *
 * @return  The tick position
 */
 public MgCoordinate GetPosition() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGridTick_GetPosition(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the tick's direction vector
 *
 * @return  The tick's direction vector
 */
 public MgCoordinate GetDirectionVector() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemGridTick_GetDirectionVector(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
