/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This object carries most, if not all, intelligence specific to the MGRS
 * (Military Grid Reference System) grid standard.  It can be used at two
 * distinct levels, depending upon how it is manufactured.
 * When manufactured with an ellipsoid/datum specification, this object is
 * suitable only for conversion of geographic coordinates to MGRS strings and
 * vice-versa.
 * WHen manufactured with a frame coordinate system with a grid boundary
 * subsequently supplied, the resulting object is capable of NGRS string
 * conversions AND the generation of MGRS grids.
 * When manufactured using a frame coordinate system and subsequent
 * provision of a frame boundary (see base class {@link MgCoordinateSystemGridBase})
 * the members derived from the {@link MgCoordinateSystemGridBase} base class
 * can be used for MGRS grid drawing purposes.
 *
 */
 public class MgCoordinateSystemMgrs extends MgCoordinateSystemGridBase {
  private long swigCPtr;

  public MgCoordinateSystemMgrs(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemMgrsToMgCoordinateSystemGridBase(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemMgrs() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemMgrs(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemMgrs obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Converts a geographic coordinate to MGRS string form.
 *
 * @param  dLongitude (double)  Longitude of the geographic position to be converted, in degrees  relative to Greenwich.  Use negative value for west longitude.
 * @param  dLatitude (double)  Latitude of the geographic position to be converted, in degrees.  Use negative value for south latitude.
 * @param  nPrecision (int)  A value between zero and five, indicates the precision of the  numeric portion of the returned MGRS designation.
 * @return  The MGRs representation for the given point.
 */
 public String ConvertFromLonLat(double dLongitude, double dLatitude, int nPrecision) throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemMgrs_ConvertFromLonLat__SWIG_0(swigCPtr, dLongitude, dLatitude, nPrecision); }
}

  
/**
 * Converts a geographic coordinate to MGRS string form.
 *
 * @param  pLonLat (String/string)  The geographic position to be converted.  X coordinate is the longitude  in degrees relative to Greenwich, negative indicating west longitude.  Y coordinate is latitude in degrees, negative indicating south latitude.
 * @param  nPrecision (int)  A value between zero and five, indicates the precision of the  numeric portion of the returned MGRS designation.
 * @return  The MGRs representation for the given point.
 */
 public String ConvertFromLonLat(MgCoordinate pLonLat, int nPrecision) throws MgException  {
  { return MapGuideJavaApiJNI.MgCoordinateSystemMgrs_ConvertFromLonLat__SWIG_1(swigCPtr, MgCoordinate.getCPtr(pLonLat), nPrecision); }
}

  
/**
 * Converts an MGRS string to geographic coordinates.
 *
 * @param  s{@link Mgrs} (String/string)  The MGRS string to be converted.
 * @return  The geographic coordinates of the location identified by the provided
 *  MGRS string (center of the grid sqaure).
 */
 public MgCoordinate ConvertToLonLat(String sMgrs) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemMgrs_ConvertToLonLat__SWIG_0(swigCPtr, sMgrs);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts an MGRS string to geographic coordinates.
 *
 * @param  s{@link Mgrs} (String/string)  The MGRS string to be converted.
 * @param  grdSqrPosition (int)  A value from the {@link MgCoordinateSystemMgrsGridSquarePosition} enumeration  which indicates the position within the grid sqaure referenced by  the s{@link Mgrs} argumjent which is to be returned.
 * @return  The geographic coordinates of the location identified by the provided
 *  MGRS string.
 */
 public MgCoordinate ConvertToLonLat(String sMgrs, int grdSqrPosition) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemMgrs_ConvertToLonLat__SWIG_1(swigCPtr, sMgrs, grdSqrPosition);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a value as defined by the {@link MgCoordinateSystemMgrsLetteringScheme}
 * object indicating which lettering scheme is currently active.
 *
 * @return  Either {@link MgCoordinateSystemMgrsLetteringScheme}::Normal or
 *  {@link MgCoordinateSystemMgrsLetteringScheme}::Alternative
 */
 public short GetLetteringScheme() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemMgrs_GetLetteringScheme(swigCPtr);
  }

}
