package org.osgeo.mapguide;


/**
 * Defines coordinate system projection codes
 *
 */
public class MgCoordinateSystemProjectionCode
{
   
/**
 * Albers Equal Area Conic Projection
 *
 */

   public static final int Alber = 4 ; 
   
/**
 * Azimuthal Equi-Distant; Elevated ellipsoid.
 *
 */

   public static final int Azede = 59 ; 
   
/**
 * Lambert Azimuthal Equal Area Projection
 *
 */

   public static final int Azmea = 11 ; 
   
/**
 * Lambert Azimuthal Equidistant Projection
 *
 */

   public static final int Azmed = 7 ; 
   
/**
 * Bipolar Oblique Conformal Conic Projection
 *
 */

   public static final int Bipolar = 31 ; 
   
/**
 * Bonne Pseudoconical Projection
 *
 */

   public static final int Bonne = 24 ; 
   
/**
 * Cassini Projection
 *
 */

   public static final int Cassini = 22 ; 
   
/**
 * Ekert Pseudocylindrical Projection; Number IV
 *
 */

   public static final int Eckert4 = 25 ; 
   
/**
 * Ekert Pseudocylindrical Projection; Number VI
 *
 */

   public static final int Eckert6 = 26 ; 
   
/**
 * Equidistant Conic Projection; aka Simple Conic
 *
 */

   public static final int Edcnc = 12 ; 
   
/**
 * Equidistant Cylindrical Projection (Spherical only)
 *
 */

   public static final int Edcyl = 20 ; 
   
/**
 * Gauss-Kruger: Transverse Mercator without scale reduction parameter.
 *
 */

   public static final int GaussK = 46 ; 
   
/**
 * Gnomonic Projection
 *
 */

   public static final int Gnomonic = 19 ; 
   
/**
 * Goode Homolosine Projection
 *
 */

   public static final int Goode = 28 ; 
   
/**
 * Unrectified Hotine Oblique Mercator Projection; Sngl Point Form
 *
 */

   public static final int Hom1uv = 1281 ; 
   
/**
 * Rectified Hotine Oblique Mercator Projection; Single Point Form
 *
 */

   public static final int Hom1xy = 1282 ; 
   
/**
 * Unrectified Hotine Oblique Mercator Projection; Two Point Form
 *
 */

   public static final int Hom2uv = 1283 ; 
   
/**
 * Rectified Hotine Oblique Mercator Projection; Two Point Form
 *
 */

   public static final int Hom2xy = 1284 ; 
   
/**
 * Czech Krovak; original.
 *
 */

   public static final int Krovak = 47 ; 
   
/**
 * Czech Krovak; includes 1995 adjustment.
 *
 */

   public static final int Krvk95 = 51 ; 
   
/**
 * Null Projection; produces/processes Latitude and Longitude
 *
 */

   public static final int LL = 1 ; 
   
/**
 * Single standard parallel variation of the Lambert Conformal Conic.
 *
 */

   public static final int Lm1sp = 36 ; 
   
/**
 * Double standard parallel variation of the Lambert Conformal Conic.
 *
 */

   public static final int Lm2sp = 37 ; 
   
/**
 * Belgian variation of the Lambert Conformal Conic Projection.
 *
 */

   public static final int Lmblg = 38 ; 
   
/**
 * Lambert Tangential Conformal Conic Projection
 *
 */

   public static final int Lmtan = 8 ; 
   
/**
 * Miller Cylindrical Projection
 *
 */

   public static final int Miller = 13 ; 
   
/**
 * Minnesota DOT variation of the Lambert Conformal Conic.
 *
 */

   public static final int Mndotl = 41 ; 
   
/**
 * Minnesota DOT variation of the Transverse Mercator projection.
 *
 */

   public static final int Mndott = 42 ; 
   
/**
 * Lallemand IMW Modified Polyconic Projection
 *
 */

   public static final int Modpc = 10 ; 
   
/**
 * Mollweide Projection
 *
 */

   public static final int Mollweid = 27 ; 
   
/**
 * Mercator Cylindrical Projection
 *
 */

   public static final int Mrcat = 6 ; 
   
/**
 * Standard Mercator with a scale reduction factor instead of a standard parallel.
 *
 */

   public static final int MrcatK = 49 ; 
   
/**
 * Modified Sterographic Projection
 *
 */

   public static final int Mstero = 15 ; 
   
/**
 * Normal Aspect; Equal Area Cylindrical Projection
 *
 */

   public static final int Neacyl = 29 ; 
   
/**
 * Non-georeferenced coordinate system.  Named Non-Earth by Map Info.
 *
 */

   public static final int Nerth = 55 ; 
   
/**
 * New Zealand National Grid
 *
 */

   public static final int Nzealand = 16 ; 
   
/**
 * Oblique Mercator (obsolete)
 *
 */

   public static final int OblqM = 5 ; 
   
/**
 * Oblique Cylindrical; a generalized version of the Swiss projection; specifically for Hungary
 *
 */

   public static final int Obqcyl = 56 ; 
   
/**
 * Orthographic Projection
 *
 */

   public static final int Ortho = 18 ; 
   
/**
 * The Transverse Mercator with specific parameters; with the OSTN02 grid shift tacked on.  This is a combination of a projection and a datum shift
 *
 */

   public static final int Ostn02 = 60 ; 
   
/**
 * The Transverse Mercator with specific parameters; with the OSTN97 grid shoft tacked on.  This is a combination of a projection and a datum shift
 *
 */

   public static final int Ostn97 = 58 ; 
   
/**
 * Oblique Sterographic
 *
 */

   public static final int Ostro = 34 ; 
   
/**
 * Hassler American Polyconic Projection
 *
 */

   public static final int Plycn = 9 ; 
   
/**
 * Polar sterographic
 *
 */

   public static final int Pstro = 33 ; 
   
/**
 * Polar sterographic with standard latitude
 *
 */

   public static final int Pstrosl = 53 ; 
   
/**
 * cs_PRJCOD_RSKEW
 *
 */

   public static final int Rskew = 1285 ; 
   
/**
 * cs_PRJCOD_RSKEWC
 *
 */

   public static final int Rskewc = 1286 ; 
   
/**
 * cs_PRJCOD_RSKEWO - Rectified Skew Orthomorphic; Skew Azimuth at Rectified Origin
 *
 */

   public static final int Rskewo = 1287 ; 
   
/**
 * Robinson Cylindrical Projection
 *
 */

   public static final int Robinson = 23 ; 
   
/**
 * Sinusoidal Projection; Optionally Interrupted
 *
 */

   public static final int Sinus = 17 ; 
   
/**
 * South Oriented variation of the Transverse Mercator Projection.
 *
 */

   public static final int Sotrm = 43 ; 
   
/**
 * Synder's Oblique Sterographic
 *
 */

   public static final int Sstro = 35 ; 
   
/**
 * "Swiss" Projection
 *
 */

   public static final int Swiss = 32 ; 
   
/**
 * Combination of Transverse Mercator and a polynomial expansion used in Denmark
 *
 */

   public static final int Sys34 = 57 ; 
   
/**
 * Combination of Transverse Mercator and polynomial expansion used in Denmark.  Polynominals are of the 1999 vintage.
 *
 */

   public static final int Sys34_99 = 61 ; 
   
/**
 * Transverse Aspect; Equal Area Cylindrical Projection
 *
 */

   public static final int Teacyl = 30 ; 
   
/**
 * Transverse Mercator or Gauss Kruger Projection
 *
 */

   public static final int Tm = 3 ; 
   
/**
 * Transverse Mercator with affiine post-processor.
 *
 */

   public static final int Trmeraf = 54 ; 
   
/**
 * Transverse Mercator using Kruger Formulation
 *
 */

   public static final int Trmrkrg = 62 ; 
   
/**
 * Transverse Mercator per J. P. Snyder.
 *
 */

   public static final int Trmrs = 45 ; 
   
/**
 * Van Der Grinten Projection
 *
 */

   public static final int Vdgrntn = 21 ; 
   
/**
 * Wisconsin County Coord System variation; Lambert Conformal Conic
 *
 */

   public static final int Wccsl = 39 ; 
   
/**
 * Wisconsin County Coord System variation; Transverse Mercator projection
 *
 */

   public static final int Wccst = 40 ; 
   
/**
 * The UTM direct variation of the Transverse Mercator projection
 *
 */

   public static final int Utm = 44 ; 
   
/**
 * Winkel-Tripel; variable standard latitude
 *
 */

   public static final int Winkl = 63 ; 
   
/**
 * Nerth with scale and rotation
 *
 */

   public static final int Nrthsrt = 64 ; 
   
/**
 * Lambert Conformal Conic with affine post-processor.
 *
 */

   public static final int Lmbrtaf = 65 ; 
   
/**
 * Combination of Transverse Mercator and polynomial expansion used in Denmark.  Polynominals are of the 2001 vintage.
 *
 */

   public static final int Sys34_01 = 66 ; 
   
/**
 * Equidistant Cylindrical Projection, Ellipsoidal or Spherical
 *
 */

   public static final int EdcylE = 67 ; 
   
/**
 * Inplementation of Plate Carree as a variation of the Equidistant Cylindrical
 *
 */

   public static final int PlateCarree = 68 ; 
   
/**
 * Popular Visualization Pseudo Mercator (aka Google Earth)
 *
 */

   public static final int PvMercator = 69 ; 
   
/**
 * Lambert Conformal Conic, Michigan Variation
 *
 */

   public static final int LmMich = 70 ; 
   
/**
 * Unknown
 *
 */

   public static final int Unknown = 0 ; 
   
}

