/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Provides operations for transforming coordinates from one
 * coordinate system to another.
 *
 */
 public class MgCoordinateSystemTransform extends MgTransform {
  private long swigCPtr;

  public MgCoordinateSystemTransform(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCoordinateSystemTransformToMgTransform(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemTransform() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCoordinateSystemTransform(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemTransform obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Transforms the given X and Y values whose frame of reference
 * is the source coordinate system into an XY coordinate whose
 * frame of reference is the target coordinate system.
 *
 * @param  x (double)  The X ordinate to transform.
 * @param  y (double)  The Y ordinate to transform.
 * @return  Returns an {@link MgCoordinate} object which is the equivalent in
 *  the target coordinate system of the given X and Y ordinates.
 * @exception  MgCoordinateSystemTransformFailedException
 */
 public MgCoordinate Transform(double x, double y) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_Transform__SWIG_0(swigCPtr, x, y);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Transforms the given X, Y, and M values whose frame of
 * reference is the source coordinate system into a coordinate
 * whose frame of reference is the target coordinate system.
 *
 * @param  x (double)  The X ordinate to transform.
 * @param  y (double)  The Y ordinate to transform.
 * @param  m (double)  The measure to transform.
 * @return  Returns an {@link MgCoordinate} object which is the equivalent in
 *  the target coordinate system of the given X, Y, and M values.
 * @exception  MgCoordinateSystemTransformFailedException
 */
 public MgCoordinate TransformM(double x, double y, double m) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_TransformM__SWIG_0(swigCPtr, x, y, m);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Transforms the given X, Y and Z values whose frame of
 * reference is the source coordinate system into a coordinate
 * whose frame of reference is the target coordinate system.
 *
 * @param  x (double)  The X ordinate to transform.
 * @param  y (double)  The Y ordinate to transform.
 * @param  z (double)  The Z ordinate to transform.
 * @return  Returns an {@link MgCoordinate} object which is the equivalent in
 *  the target coordinate system of the given X, Y, and Z
 *  ordinates.
 * @exception  MgCoordinateSystemTransformFailedException
 */
 public MgCoordinate Transform(double x, double y, double z) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_Transform__SWIG_1(swigCPtr, x, y, z);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Transforms the given X, Y, Z, and M values whose frame of
 * reference is the source coordinate system into a coordinate
 * whose frame of reference is the target coordinate system.
 *
 * @param  x (double)  The X ordinate to transform.
 * @param  y (double)  The Y ordinate to transform.
 * @param  z (double)  The Z ordinate to transform.
 * @param  m (double)  The measure to transform.
 * @return  Returns an {@link MgCoordinate} object which is the equivalent in
 *  the target coordinate system of the given X, Y, Z, and M
 *  values.
 * @exception  MgCoordinateSystemTransformFailedException
 */
 public MgCoordinate TransformM(double x, double y, double z, double m) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_TransformM__SWIG_1(swigCPtr, x, y, z, m);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Transforms the given coordinate whose frame of reference is
 * the source coordinate system into a coordinate whose frame of
 * reference is the target coordinate system.
 *
 * @param  coordinate ({@link MgCoordinate})  An {@link MgCoordinate} object defined in terms  of the source coordinate system.
 * @return  Returns an {@link MgCoordinate} object which is the equivalent in
 *  the target coordinate system of the given coordinate.
 * @exception  MgCoordinateSystemTransformFailedException
 */
 public MgCoordinate Transform(MgCoordinate coordinate) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_Transform__SWIG_2(swigCPtr, MgCoordinate.getCPtr(coordinate));
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Transforms an {@link MgEnvelope} instance for the source coordinate
 * system into an {@link MgEnvelope} instance for target coordinate
 * system.
 *
 * @param  envelope ({@link MgEnvelope})  An {@link MgEnvelope} object obtained from the  {@link MgCoordinateSystemMeasure} for the source  coordinate system.
 * @return  Returns an {@link MgEnvelope} object for the target coordinate
 *  system..
 * @exception  MgCoordinateSystemTransformFailedException
 */
 public MgEnvelope Transform(MgEnvelope envelope) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_Transform__SWIG_3(swigCPtr, MgEnvelope.getCPtr(envelope));
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Transforms the specified coordinate in-place.
 *
 * @param  coordinate ({@link MgCoordinate})  The coordinate that will be transformed in-place
 */
 public void TransformCoordinate(MgCoordinate coordinate) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemTransform_TransformCoordinate(swigCPtr, MgCoordinate.getCPtr(coordinate));
  }

  
/**
 * Generates a {@link MgLineString} which represents, in the target coordinate
 * system, the linear line segment provided in the source coordinate
 * system.
 *
 * @param  fromPnt  The starting point of the linear segment in source system coordinates.
 * @param  toPnt  The end point of the linear segment in source system coordinates.
 * @param  curvePrecision  The returned line string is segmented to the degree necessary such  that the distance between the LineString approximation of the true  curve and the true curve istself is never more than this value.  Units  must be the same as the target coordinate system.
 * @param  maxPoints  The generation algorithm will always quit after generating this  number of points in result.  A typical value is 500.  DO NOIT rely  on the algorithm stopping at exactly this value.  The typical value  of 500 can and will produce a LineString with as many of 750 points  before terminating.
 * @return  The result of the transformation is returned in the form of a
 *  disposable LineString object.  While the result can be as simple as
 *  a single straight line segment, more often it will be a multi-segment
 *  approximation of a complex curve.
 */
 public MgLineString GridLine(MgCoordinate fromPnt, MgCoordinate toPnt, double curvePrecision, int maxPoints) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_GridLine(swigCPtr, MgCoordinate.getCPtr(fromPnt), MgCoordinate.getCPtr(toPnt), curvePrecision, maxPoints);
    return (cPtr == 0) ? null : (MgLineString)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets whether the given source point is valid
 *
 * @param  x (double)  The X coordinate of the source point
 * @param  y (double)  The Y coordinate of the source point
 * @return  true if this given source point is valid. false otherwise
 */
 public boolean IsValidSourcePoint(double x, double y) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_IsValidSourcePoint__SWIG_0(swigCPtr, x, y);
  }

  
/**
 * Gets whether the given source point is valid
 *
 * @param  x (double)  The X coordinate of the source point
 * @param  y (double)  The Y coordinate of the source point
 * @param  z (double)  The Z coordinate of the source point
 * @return  true if this given source point is valid. false otherwise
 */
 public boolean IsValidSourcePoint(double x, double y, double z) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_IsValidSourcePoint__SWIG_1(swigCPtr, x, y, z);
  }

  
/**
 * Gets whether the given target point is valid
 *
 * @param  x (double)  The X coordinate of the target point
 * @param  y (double)  The Y coordinate of the target point
 * @return  true if this given target point is valid. false otherwise
 */
 public boolean IsValidTargetPoint(double x, double y) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_IsValidTargetPoint__SWIG_0(swigCPtr, x, y);
  }

  
/**
 * Gets whether the given target point is valid
 *
 * @param  x (double)  The X coordinate of the target point
 * @param  y (double)  The Y coordinate of the target point
 * @param  z (double)  The Z coordinate of the target point
 * @return  true if this given target point is valid. false otherwise
 */
 public boolean IsValidTargetPoint(double x, double y, double z) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_IsValidTargetPoint__SWIG_1(swigCPtr, x, y, z);
  }

  
/**
 * Gets the source coordinate system ({@link MgCoordinateSystem})
 *
 * @return  The source coordinate system
 */
 public MgCoordinateSystem GetSource() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetSource(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystem)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the target coordinate system ({@link MgCoordinateSystem})
 *
 * @return  The target coordinate system
 */
 public MgCoordinateSystem GetTarget() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetTarget(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystem)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the source and target coordinate systems
 *
 * @param  pSource ({@link MgCoordinateSystem})  The source coordinate system
 * @param  pTarget ({@link MgCoordinateSystem})  The target coordinate system
 */
 public void SetSourceAndTarget(MgCoordinateSystem pSource, MgCoordinateSystem pTarget) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemTransform_SetSourceAndTarget(swigCPtr, MgCoordinateSystem.getCPtr(pSource), MgCoordinateSystem.getCPtr(pTarget));
  }

  
/**
 * Returns the number of geodetic transformations used in the implicit or
 * explicit path used to convert the source to the target coordinate system.
 * For a geodetic transformation to take place, both the source and the target
 * coordinate systems have to be referenced to a datum.
 *
 * @return  Returns the number of geodetic transformations in the path as described above.
 *  Returns 0, if no geodetic transformation will have to be done when converting from
 *  the source coordinate system to the target coordinate system. In
 *  particular, this method returns 0 in the following cases:
 */
 public int GetGeodeticTransformationCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetGeodeticTransformationCount(swigCPtr);
  }

  
/**
 * Returns a pointer to the catalog-resident(!) geodetic transformation definition indicated
 * by the index parameter.
 *
 * @param  index  A zero based index indicating the specific transformation definition  which is to be returned.
 * @return  Returns a disposable pointer to the geodetic transformation definition
 *  indicated by the index parameter. The {@link MgCoordinateSystemGeodeticTransformDef}
 *  instance is guaranteed to exist in the geodetic transformation definition
 *  dictionary.
 * @exception   MgIndexOutOfRangeException if index is out of range. See MgCoordinateSystemTransform::GetGeodeticTransformationCount.
 * @exception   MgCoordinateSystemLoadFailedException if the geodetic transformation
 * @exception   MgCoordinateSystemInitializationFailedException if the
 * @exception   MgException if the dictionaries could not be accessed or
 */
 public MgCoordinateSystemGeodeticTransformDef GetGeodeticTransformation(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetGeodeticTransformation(swigCPtr, index);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticTransformDef)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the direction of the transformation definition indicated by
 * the index parameter.
 *
 * @param  index  A zero based index indicating the specific transformation definition  for which the direction is to be returned.
 * @return  Returns a memebr of the {@link MgCoordinateSystemGeodeticDirection} class:
 *  * {@link MgCoordinateSystemGeodeticDirection}::GeodeticDirectionForward for the forward direction,
 *  * {@link MgCoordinateSystemGeodeticDirection}::GeodeticDirectionInverse or the inverse direction,
 *  * {@link MgCoordinateSystemGeodeticDirection}::GeodeticDirectionNone if there is no specification (e.g. a null transformation), and
 *  * {@link MgCoordinateSystemGeodeticDirection}::GeodeticDirectionError if the index parameter is invalid.
 */
 public int GetGeodeticTransformationDirection(int index) throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetGeodeticTransformationDirection(swigCPtr, index);
  }

  
/**
 * Returns the definition of the geodetic path used to build the
 * transformation, but only if the path was explicitly obtained from the
 * Geodetic Path dictionary.
 *
 * @return  Returns a disposable pointer to the Geodetic Path definition which
 *  was used to build the conversion from the source to target datums.
 *  Returns null is the path from source to taregt datums was implicitly
 *  generated by CS-MAP.
 */
 public MgCoordinateSystemGeodeticPath GetExplicitGeodeticPath() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetExplicitGeodeticPath(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemGeodeticPath)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets whether datum shift warnings will be ignored
 *
 * @param  bIgnoreDatumShiftWarning (boolean/bool)  true if datum shift warnings will be ignored. false otherwise
 */
 public void IgnoreDatumShiftWarning(boolean bIgnoreDatumShiftWarning) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemTransform_IgnoreDatumShiftWarning(swigCPtr, bIgnoreDatumShiftWarning);
  }

  
/**
 * Gets whether datum shift warnings will be ignored
 *
 * @return  true if this datum shift warnings will be ignored. false otherwise
 */
 public boolean IsIgnoreDatumShiftWarning() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_IsIgnoreDatumShiftWarning(swigCPtr);
  }

  
/**
 * Sets whether outside domain warnings will be ignored
 *
 * @param  bIgnoreOutsideDomainWarning (boolean/bool)  true if outside domain warnings will be ignored. false otherwise
 */
 public void IgnoreOutsideDomainWarning(boolean bIgnoreOutsideDomainWarning) throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemTransform_IgnoreOutsideDomainWarning(swigCPtr, bIgnoreOutsideDomainWarning);
  }

  
/**
 * Gets whether outside domain warnings will be ignored
 *
 * @return  true if this outside domain warnings will be ignored. false otherwise
 */
 public boolean IsIgnoreOutsideDomainWarning() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_IsIgnoreOutsideDomainWarning(swigCPtr);
  }

  public int GetSourceWarningCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetSourceWarningCount(swigCPtr);
  }

  public int GetdatumWarningCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetdatumWarningCount(swigCPtr);
  }

  public int GetTargetWarningCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetTargetWarningCount(swigCPtr);
  }

  
/**
 * Gets the last transformation status
 *
 * @return  The last transformation status
 */
 public int GetLastTransformStatus() throws MgException  {
    return MapGuideJavaApiJNI.MgCoordinateSystemTransform_GetLastTransformStatus(swigCPtr);
  }

  
/**
 * Resets the last transformation status
 *
 */
 public void ResetLastTransformStatus() throws MgException  {
    MapGuideJavaApiJNI.MgCoordinateSystemTransform_ResetLastTransformStatus(swigCPtr);
  }

}
