/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCurveStringCollection} provides support for defining an ordered set of
 * curve strings.
 *
 */
 public class MgCurveStringCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgCurveStringCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgCurveStringCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgCurveStringCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCurveStringCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of curve strings in the collection.
 *
 * @return  Returns number of curve strings in the collection.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgCurveStringCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the curve string in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the curve string to retrieve.
 * @return  Returns the curve string in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgCurveString GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgCurveStringCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgCurveString)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the curve string in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgCurveString})  curve string to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void SetItem(int index, MgCurveString value) throws MgException  {
    MapGuideJavaApiJNI.MgCurveStringCollection_SetItem(swigCPtr, index, MgCurveString.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgCurveString})  curve string to add to the collection.
 * @return  Returns nothing
 */
 public void Add(MgCurveString value) throws MgException  {
    MapGuideJavaApiJNI.MgCurveStringCollection_Add(swigCPtr, MgCurveString.getCPtr(value));
  }

  
/**
 * Inserts the specified curve string at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgCurveString})  curve string to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void Insert(int index, MgCurveString value) throws MgException  {
    MapGuideJavaApiJNI.MgCurveStringCollection_Insert(swigCPtr, index, MgCurveString.getCPtr(value));
  }

  
/**
 * Removes all curve strings from the collection.
 *
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgCurveStringCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified curve string from the collection. Return true if
 * the curve string was removed.
 *
 * @param  value ({@link MgCurveString})  curve string reference to remove.
 * @return  Returns true if curve string was removed.
 */
 public boolean Remove(MgCurveString value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurveStringCollection_Remove(swigCPtr, MgCurveString.getCPtr(value));
  }

  
/**
 * Removes the curve string at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the curve string to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgCurveStringCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified curve string, false
 * otherwise.
 *
 * @param  value ({@link MgCurveString})  curve string reference to check containment of.
 * @return  True if the collection contains the specified curve string, false
 *  otherwise.
 */
 public boolean Contains(MgCurveString value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurveStringCollection_Contains(swigCPtr, MgCurveString.getCPtr(value));
  }

  
/**
 * Returns the index of the specified curve string in the collection or -1
 * if the curve string does not exist.
 *
 * @param  value ({@link MgCurveString})  curve string reference to find the index of.
 * @return  The index of the specified curve string in the collection or -1 if the
 *  curve string does not exist.
 */
 public int IndexOf(MgCurveString value) throws MgException  {
    return MapGuideJavaApiJNI.MgCurveStringCollection_IndexOf(swigCPtr, MgCurveString.getCPtr(value));
  }

  
/**
 * Construct a {@link MgCurveStringCollection} object
 *
 */
 public MgCurveStringCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgCurveStringCollection(), true);
  }

}
