/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Represents a collection of feature commands.
 *
 */
 public class MgFeatureCommandCollection extends MgSerializable {
  private long swigCPtr;

  public MgFeatureCommandCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgFeatureCommandCollectionToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgFeatureCommandCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgFeatureCommandCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of commands in the collection.
 *
 * @return  Returns number of commands in the collection
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgFeatureCommandCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the command in the collection at the specified index.
 *
 * @param  index (int)  Input index
 * @return  Returns the command in the collection at the specified index
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public MgFeatureCommand GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgFeatureCommandCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgFeatureCommand)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the command in the collection at the specified index to the specified command.
 * If there was already command assigned to specified index, it will be overwritten.
 *
 * @param  index (int)  Input index
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public void SetItem(int index, MgFeatureCommand command) throws MgException  {
    MapGuideJavaApiJNI.MgFeatureCommandCollection_SetItem(swigCPtr, index, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Adds the specified command to the end of the collection.
 *
 * @param  command ({@link MgFeatureCommand})  One of type {@link MgDeleteFeatures}, {@link MgInsertFeatures},  or {@link MgUpdateFeatures}
 * @return  Returns nothing.
 */
 public void Add(MgFeatureCommand command) throws MgException  {
    MapGuideJavaApiJNI.MgFeatureCommandCollection_Add(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Inserts the specified command at the specified index within the collection.
 * Items following the insertion point are moved down to accommodate the new command.
 *
 * @param  index (int)  Input index
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public void Insert(int index, MgFeatureCommand command) throws MgException  {
    MapGuideJavaApiJNI.MgFeatureCommandCollection_Insert(swigCPtr, index, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Removes all commands from the collection.
 *
 * @return  Returns nothing
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgFeatureCommandCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified command from the collection.
 *
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns true if removal was successful.
 */
 public boolean Remove(MgFeatureCommand command) throws MgException  {
    return MapGuideJavaApiJNI.MgFeatureCommandCollection_Remove(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Removes the specified command from the collection.
 *
 * @param  index (int)  Input index
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgFeatureCommandCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified command, false otherwise.
 *
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns true if the collection contains the specified command, false otherwise
 */
 public boolean Contains(MgFeatureCommand command) throws MgException  {
    return MapGuideJavaApiJNI.MgFeatureCommandCollection_Contains(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Returns the index of the specified command in the collection or -1 if the command does not exist.
 *
 * @param  command ({@link MgFeatureCommand})  Input command
 * @return  Returns the index of the specified command in the collection or -1 if the command does not exist
 */
 public int IndexOf(MgFeatureCommand command) throws MgException  {
    return MapGuideJavaApiJNI.MgFeatureCommandCollection_IndexOf(swigCPtr, MgFeatureCommand.getCPtr(command));
  }

  
/**
 * Constructor.  Creates an empty collection of feature commands.
 *
 */
 public MgFeatureCommandCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgFeatureCommandCollection(), true);
  }

}
