package org.osgeo.mapguide;


/**
 * Defines names for the different types of property
 * definitions. See {@link MgPropertyDefinition}::GetPropertyType.
 *
 */
public class MgFeaturePropertyType
{
   
/**
 * Type name for a data property definition. See
 * {@link MgDataPropertyDefinition}.
 *
 */

   public static final int DataProperty = 100 ; 
   
/**
 * Type name for an object property definition. See
 * {@link MgObjectPropertyDefinition}.
 *
 */

   public static final int ObjectProperty = 101 ; 
   
/**
 * Type name for a geometric property definition. See
 * {@link MgGeometricPropertyDefinition}.
 *
 */

   public static final int GeometricProperty = 102 ; 
   
/**
 * Type name for an association property definition.
 *
 */

   public static final int AssociationProperty = 103 ; 
   
/**
 * Type name for a raster property definition. See
 * {@link MgRasterPropertyDefinition}.
 *
 */

   public static final int RasterProperty = 104 ; 
   
}

