/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Defines a geometric property belonging to a feature class.
 *
 */
 public class MgGeometricPropertyDefinition extends MgPropertyDefinition {
  private long swigCPtr;

  public MgGeometricPropertyDefinition(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgGeometricPropertyDefinitionToMgPropertyDefinition(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgGeometricPropertyDefinition() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgGeometricPropertyDefinition(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgGeometricPropertyDefinition obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an {@link MgGeometricPropertyDefinition} object
 *
 * @param  name (String/string)  The name of the property.
 */
 public MgGeometricPropertyDefinition(String name) throws MgException {
    this(MapGuideJavaApiJNI.new_MgGeometricPropertyDefinition(name), true);
  }

  
/**
 * Gets the {@link MgFeatureGeometricType} types which specify the
 * categories of the geometries (point, line, surface, solid)
 * that can be stored in this geometric property.
 *
 * @return  Returns the bit-wise OR combination of one or more of the
 *  {@link MgFeatureGeometricType} constants.
 */
 public int GetGeometryTypes() throws MgException  {
    return MapGuideJavaApiJNI.MgGeometricPropertyDefinition_GetGeometryTypes(swigCPtr);
  }

  
/**
 * Gets the specific geometry types that can be stored in this geometric
 * property. The returned value is a list of geometry types that are
 * supported.  The caller does NOT own the array of types and should not free its memory.
 *
 * @return  Returns a list of geometry types that are supported.
 * @since  2.0 */
 public MgGeometryTypeInfo GetSpecificGeometryTypes() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometricPropertyDefinition_GetSpecificGeometryTypes(swigCPtr);
    return (cPtr == 0) ? null : (MgGeometryTypeInfo)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets a Boolean value that indicates whether this geometric
 * property is read-only.
 *
 * @return  Returns a Boolean value that indicates whether this
 *  geometric property is read-only.
 */
 public boolean GetReadOnly() throws MgException  {
    return MapGuideJavaApiJNI.MgGeometricPropertyDefinition_GetReadOnly(swigCPtr);
  }

  
/**
 * Gets a Boolean value that indicates whether the points in the
 * geometry contained in this property include elevation
 * (Z-coordinate) values.
 *
 * @return  Returns a Boolean value that indicates whether the points in
 *  the geometry contained in this property includes elevation
 *  (Z-coordinate) values
 */
 public boolean GetHasElevation() throws MgException  {
    return MapGuideJavaApiJNI.MgGeometricPropertyDefinition_GetHasElevation(swigCPtr);
  }

  
/**
 * Gets a Boolean value that indicates whether the points in the
 * geometry contained in this property includes measurement
 * values (M-ordinates).
 *
 * @return  Returns true if the points in the geometry contained in this
 *  property include measurement values (M-ordinates); otherwise
 *  returns false.
 */
 public boolean GetHasMeasure() throws MgException  {
    return MapGuideJavaApiJNI.MgGeometricPropertyDefinition_GetHasMeasure(swigCPtr);
  }

  
/**
 * Gets the Spatial Context name associated with this geometric
 * property.
 *
 * @return  Returns a String value representing the Spatial Context
 *  name. If the value is empty then the geometric property is
 *  associated with all the spatial contexts in the datastore.
 */
 public String GetSpatialContextAssociation() throws MgException  {
  { return MapGuideJavaApiJNI.MgGeometricPropertyDefinition_GetSpatialContextAssociation(swigCPtr); }
}

  
/**
 * Sets the categories of geometries (point, line, surface,
 * solid) that can be stored in this geometric property.
 *
 * @param  types (int)  One or more of the {@link MgFeatureGeometricType}  constants combined by a bit-wise OR operation.
 */
 public void SetGeometryTypes(int types) throws MgException  {
    MapGuideJavaApiJNI.MgGeometricPropertyDefinition_SetGeometryTypes(swigCPtr, types);
  }

  
/**
 * Sets the specific list of geometry types that can be stored in this
 * geometric property. The provided value is a list of geometry types
 * that are supported.
 *
 * @param  typeInfo ({@link MgGeometryTypeInfo})  The specific set of geometry types that can be stored in this  geometric property.
 * @return  Returns nothing.
 * @since  2.0 */
 public void SetSpecificGeometryTypes(MgGeometryTypeInfo typeInfo) throws MgException  {
    MapGuideJavaApiJNI.MgGeometricPropertyDefinition_SetSpecificGeometryTypes(swigCPtr, MgGeometryTypeInfo.getCPtr(typeInfo));
  }

  
/**
 * Determines whether this geometric property is read-only.
 *
 * @param  value (boolean/bool)  True configures the property to be read-only  and false configures it to be user settable.
 * @return  Returns nothing.
 */
 public void SetReadOnly(boolean value) throws MgException  {
    MapGuideJavaApiJNI.MgGeometricPropertyDefinition_SetReadOnly(swigCPtr, value);
  }

  
/**
 * Determines whether the geometry contained in this property
 * can include elevation values, that is, whether the
 * coordinates in the geometry contain Z-ordinates.
 *
 * @param  hasElevation (boolean/bool)  True configures this property so that it can  contain a geometry whose coordinates have elevation  values (Z-ordinates), and false configures it so  that the points in the geometry cannot take an  elevation value.
 * @return  Returns nothing.
 */
 public void SetHasElevation(boolean hasElevation) throws MgException  {
    MapGuideJavaApiJNI.MgGeometricPropertyDefinition_SetHasElevation(swigCPtr, hasElevation);
  }

  
/**
 * Determines whether the points in the geometry contained in
 * this property can include a measurement value (M-ordinate).
 *
 * @param  hasMeasure (boolean/bool)  True configures the property to take  geometries whose coordinates have an M-ordinate  and false configures it so that M-ordinates  are not permissible.
 * @return  Returns nothing.
 */
 public void SetHasMeasure(boolean hasMeasure) throws MgException  {
    MapGuideJavaApiJNI.MgGeometricPropertyDefinition_SetHasMeasure(swigCPtr, hasMeasure);
  }

  
/**
 * Sets a Spatial Context association for this geometric
 * property.
 *
 * @param  spatialContextName (String/string)  The Spatial Context name to  be set.
 * @return  Returns nothing.
 */
 public void SetSpatialContextAssociation(String spatialContextName) throws MgException  {
    MapGuideJavaApiJNI.MgGeometricPropertyDefinition_SetSpatialContextAssociation(swigCPtr, spatialContextName);
  }

}
