/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * The {@link MgGeometryFactory} class is used to construct objects
 * whose classes are derived from {@link MgGeometry}.
 *
 */
 public class MgGeometryFactory extends MgGuardDisposable {
  private long swigCPtr;

  public MgGeometryFactory(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgGeometryFactoryToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgGeometryFactory(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgGeometryFactory obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Creates an {@link MgGeometryFactory} object
 *
 */
 public MgGeometryFactory() throws MgException {
    this(MapGuideJavaApiJNI.new_MgGeometryFactory(), true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XY, X = x, Y
 * = y.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate CreateCoordinateXY(double x, double y) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateCoordinateXY(swigCPtr, x, y);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XYM, X = x, Y
 * = y, M = m.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @param  m (double)  M value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate CreateCoordinateXYM(double x, double y, double m) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateCoordinateXYM(swigCPtr, x, y, m);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XYZ, X = x, Y
 * = y, Z = z.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @param  z (double)  Z value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate CreateCoordinateXYZ(double x, double y, double z) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateCoordinateXYZ(swigCPtr, x, y, z);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an {@link MgCoordinate} object with Dimension = XYZM, X = x,
 * Y = y, Z = z, M = m.
 *
 * @param  x (double)  X value for the coordinate.
 * @param  y (double)  Y value for the coordinate.
 * @param  z (double)  Z value for the coordinate.
 * @param  m (double)  M value for the coordinate.
 * @return  An initialized {@link MgCoordinate} instance.
 */
 public MgCoordinate CreateCoordinateXYZM(double x, double y, double z, double m) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateCoordinateXYZM(swigCPtr, x, y, z, m);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an arc segment from start, end, and control
 * coordinates.
 *
 * @param  start ({@link MgCoordinate})  The {@link MgCoordinate} that specifies the start point  of the arc.
 * @param  end ({@link MgCoordinate})  The {@link MgCoordinate} that specifies the end point  of the arc.
 * @param  control ({@link MgCoordinate})  The {@link MgCoordinate} that specifies the control  point of the arc.
 * @return  An instance of {@link MgArcSegment}.
 */
 public MgArcSegment CreateArcSegment(MgCoordinate start, MgCoordinate end, MgCoordinate control) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateArcSegment(swigCPtr, MgCoordinate.getCPtr(start), MgCoordinate.getCPtr(end), MgCoordinate.getCPtr(control));
    return (cPtr == 0) ? null : (MgArcSegment)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a linear segment from a collection of coordinates.
 *
 * @param  coordinates ({@link MgCoordinateCollection})  An {@link MgCoordinateCollection} that specifies the coordinates of the linear  segment. The collection must contain at least two coordinates.
 * @return  An instance of {@link MgLinearSegment}.
 */
 public MgLinearSegment CreateLinearSegment(MgCoordinateCollection coordinates) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateLinearSegment(swigCPtr, MgCoordinateCollection.getCPtr(coordinates));
    return (cPtr == 0) ? null : (MgLinearSegment)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a linear ring from a collection of coordinates.
 *
 * @param  coordinates ({@link MgCoordinateCollection})  An {@link MgCoordinateCollection} that specifies the coordinates of the linear  ring. The collection must contain at least three coordinates.
 * @return  An instance of {@link MgLinearRing}.
 */
 public MgLinearRing CreateLinearRing(MgCoordinateCollection coordinates) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateLinearRing(swigCPtr, MgCoordinateCollection.getCPtr(coordinates));
    return (cPtr == 0) ? null : (MgLinearRing)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a curve ring from a collection of curve segments.
 *
 * @param  curveSegments ({@link MgCurveSegmentCollection})  An {@link MgCurveSegmentCollection} that specifies the segments  of the curve ring. The segments in the collection must  form a closed shape. See the example php code for  details about the construction of the segments so that  the resulting shape is closed.
 * @return  An instance of {@link MgCurveRing}.
 */
 public MgCurveRing CreateCurveRing(MgCurveSegmentCollection curveSegments) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateCurveRing(swigCPtr, MgCurveSegmentCollection.getCPtr(curveSegments));
    return (cPtr == 0) ? null : (MgCurveRing)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a point from a coordinate.
 *
 * @param  coordinate ({@link MgCoordinate})  An {@link MgCoordinate} that specifies the location of this point.
 * @return  An instance of {@link MgPoint}.
 */
 public MgPoint CreatePoint(MgCoordinate coordinate) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreatePoint(swigCPtr, MgCoordinate.getCPtr(coordinate));
    return (cPtr == 0) ? null : (MgPoint)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a line string from a collection of coordinates.
 *
 * @param  coordinates ({@link MgCoordinateCollection})  An {@link MgCoordinateCollection} that specifies the coordinates of the line  string. The collection must contain at least two coordinates.
 * @return  An instance of {@link MgLineString}.
 */
 public MgLineString CreateLineString(MgCoordinateCollection coordinates) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateLineString(swigCPtr, MgCoordinateCollection.getCPtr(coordinates));
    return (cPtr == 0) ? null : (MgLineString)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a curve string from a collection of curve segments.
 *
 * @param  curveSegments ({@link MgCurveSegmentCollection})  An {@link MgCurveSegmentCollection} that specifies the segments of the  curve string. The collection must contain at least one segment.
 * @return  An instance of {@link MgCurveString}.
 */
 public MgCurveString CreateCurveString(MgCurveSegmentCollection curveSegments) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateCurveString(swigCPtr, MgCurveSegmentCollection.getCPtr(curveSegments));
    return (cPtr == 0) ? null : (MgCurveString)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a polygon from an outer ring and a collection of inner rings.
 *
 * @param  outerRing ({@link MgLinearRing})  An {@link MgLinearRing} that specifies the polygons outer boundary.
 * @param  innerRings ({@link MgLinearRingCollection})  An {@link MgLinearRingCollection} that specifies the polygons holes.  This parameter may be null.
 * @return  An instance of {@link MgPolygon}.
 */
 public MgPolygon CreatePolygon(MgLinearRing outerRing, MgLinearRingCollection innerRings) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreatePolygon(swigCPtr, MgLinearRing.getCPtr(outerRing), MgLinearRingCollection.getCPtr(innerRings));
    return (cPtr == 0) ? null : (MgPolygon)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a curve polygon from an outer ring and a collection of inner
 * rings.
 *
 * @param  outerRing ({@link MgCurveRing})  An {@link MgCurveRing} that specifies the polygons outer boundary.
 * @param  innerRings ({@link MgCurveRingCollection})  An {@link MgCurveRingCollection} that specifies the polygons holes.  This parameter may be null.
 * @return  An instance of {@link MgCurvePolygon}.
 */
 public MgCurvePolygon CreateCurvePolygon(MgCurveRing outerRing, MgCurveRingCollection innerRings) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateCurvePolygon(swigCPtr, MgCurveRing.getCPtr(outerRing), MgCurveRingCollection.getCPtr(innerRings));
    return (cPtr == 0) ? null : (MgCurvePolygon)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi point aggregate geometry from a collection of points.
 *
 * @param  points ({@link MgPointCollection})  An {@link MgGeometryCollection} that specifies the points. All geometry  objects in this collection must be of type {@link MgPoint}.
 * @return  An instance of {@link MgMultiPoint}.
 */
 public MgMultiPoint CreateMultiPoint(MgPointCollection points) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateMultiPoint(swigCPtr, MgPointCollection.getCPtr(points));
    return (cPtr == 0) ? null : (MgMultiPoint)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi line string aggregate geometry from a collection of
 * line strings.
 *
 * @param  lineStrings ({@link MgLineStringCollection})  An {@link MgGeometryCollection} that specifies the line strings. All geometry  objects in this collection must be of type {@link MgLineString}.
 * @return  An instance of {@link MgMultiLineString}.
 */
 public MgMultiLineString CreateMultiLineString(MgLineStringCollection lineStrings) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateMultiLineString(swigCPtr, MgLineStringCollection.getCPtr(lineStrings));
    return (cPtr == 0) ? null : (MgMultiLineString)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi curve string aggregate geometry from a collection of
 * curve strings.
 *
 * @param  curveStrings ({@link MgCurveStringCollection})  An {@link MgGeometryCollection} that specifies the curve strings. All geometry  objects in this collection must be of type {@link MgCurveString}.
 * @return  An instance of {@link MgMultiCurveString}.
 */
 public MgMultiCurveString CreateMultiCurveString(MgCurveStringCollection curveStrings) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateMultiCurveString(swigCPtr, MgCurveStringCollection.getCPtr(curveStrings));
    return (cPtr == 0) ? null : (MgMultiCurveString)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi polygon aggregate geometry from a collection of
 * polygons.
 *
 * @param  polygons ({@link MgPolygonCollection})  An {@link MgGeometryCollection} that specifies the polygons. All geometry  objects in this collection must be of type {@link MgPolygon}.
 * @return  An instance of {@link MgMultiPolygon}.
 */
 public MgMultiPolygon CreateMultiPolygon(MgPolygonCollection polygons) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateMultiPolygon(swigCPtr, MgPolygonCollection.getCPtr(polygons));
    return (cPtr == 0) ? null : (MgMultiPolygon)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates a multi curve polygon aggregate geometry from a collection of
 * curve polygons.
 *
 * @param  polygons ({@link MgCurvePolygonCollection})  An {@link MgGeometryCollection} that specifies the curve polygons. All geometry  objects in this collection must be of type {@link MgCurvePolygon}.
 * @return  An instance of {@link MgMultiCurvePolygon}.
 */
 public MgMultiCurvePolygon CreateMultiCurvePolygon(MgCurvePolygonCollection polygons) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateMultiCurvePolygon(swigCPtr, MgCurvePolygonCollection.getCPtr(polygons));
    return (cPtr == 0) ? null : (MgMultiCurvePolygon)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Creates an aggregate geometry from a collection of geometry objects.
 *
 * @param  geometries ({@link MgGeometryCollection})  An {@link MgGeometryCollection} that specifies the geometries.
 * @return  An instance of {@link MgMultiGeometry}.
 */
 public MgMultiGeometry CreateMultiGeometry(MgGeometryCollection geometries) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgGeometryFactory_CreateMultiGeometry(swigCPtr, MgGeometryCollection.getCPtr(geometries));
    return (cPtr == 0) ? null : (MgMultiGeometry)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
