/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class represents a collection of integers.  The integers are owned and managed by the collection.
 *
 */
 public class MgIntCollection extends MgCollection {
  private long swigCPtr;

  public MgIntCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgIntCollectionToMgCollection(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgIntCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgIntCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs a StringCollection.  Collection is initially empty.
 *
 */
 public MgIntCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgIntCollection(), true);
  }

  
/**
 * Gets the number of items in the collection.
 *
 * @return  Returns number of items in the collection.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgIntCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the item in the collection at the specified index.
 *
 * @param  index (int)  Input index
 * @return  Returns the item in the collection at the specified index
 * @exception  MgIndexOutOfRangeException if index is out of range
 */
 public int GetItem(int index) throws MgException  {
    return MapGuideJavaApiJNI.MgIntCollection_GetItem(swigCPtr, index);
  }

  
/**
 * Sets the item in the collection at the specified index to the specified value.
 *
 * @param  index (int)  Input index
 * @param  value (int)  Input value
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range
 * @exception  MgDuplicateObjectException if it is duplicate
 */
 public void SetItem(int index, int value) throws MgException  {
    MapGuideJavaApiJNI.MgIntCollection_SetItem(swigCPtr, index, value);
  }

  
/**
 * Adds the specified item to the end of the collection.
 *
 * @param  value (int)  Input value
 * @return  Returns nothing
 * @exception  MgDuplicateObjectException if it is duplicate
 */
 public void Add(int value) throws MgException  {
    MapGuideJavaApiJNI.MgIntCollection_Add(swigCPtr, value);
  }

  
/**
 * Inserts the specified item at the specified index within the collection.
 * Items following the insertion point are moved down to accommodate the new item.
 *
 * @param  index (int)  Input index
 * @param  value (int)  Input value
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range
 * @exception  MgDuplicateObjectException if it is duplicate
 */
 public void Insert(int index, int value) throws MgException  {
    MapGuideJavaApiJNI.MgIntCollection_Insert(swigCPtr, index, value);
  }

  
/**
 * Removes all items from the collection.
 *
 * @return  Returns nothing
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgIntCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  value (int)  Input value
 * @return  Returns true if removal was successful
 */
 public boolean Remove(int value) throws MgException  {
    return MapGuideJavaApiJNI.MgIntCollection_Remove(swigCPtr, value);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  index (int)  Input index
 * @return  Returns nothing
 * @exception  MgIndexOutOfRangeException if index is out of range
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgIntCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  value (int)  Input value
 * @return  Returns true if the collection contains the specified item, false otherwise
 */
 public boolean Contains(int value) throws MgException  {
    return MapGuideJavaApiJNI.MgIntCollection_Contains(swigCPtr, value);
  }

  
/**
 * Returns the index of the specified item in the collection or -1 if the item does not exist.
 *
 * @param  value (int)  Input value
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist
 */
 public int IndexOf(int value) throws MgException  {
    return MapGuideJavaApiJNI.MgIntCollection_IndexOf(swigCPtr, value);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates an XML document representing the collection.
 * Order of properties in XML would be same as order of properties in collection.
 * It starts with item zero to length of collection.
 * TODO: Add a snippet of XML here?
 *
 * @return  Pointer to an {@link MgByteReader} object
 */
 public MgByteReader ToXml() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgIntCollection_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
