/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Manipulates collections of {@link MgLayerBase} objects.
 *
 */
 public class MgLayerCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgLayerCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgLayerCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayerCollection() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgLayerCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayerCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of layers in the collection.
 *
 * @return  Returns the number of layers.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgLayerCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the layer at the specified index.
 *
 * @param  index (int)  Index of the layer to get.
 * @return  Returns the layer.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public MgLayerBase GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLayerCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the layer with the specified name.
 *
 * @param  name (String/string)  Name of the layer to get.
 * @return  Returns the layer.
 * @exception  MgObjectNotFoundException if the name does not exist.
 */
 public MgLayerBase GetItem(String name) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLayerCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgLayerBase)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the layer in the collection at the specified index to
 * the specified value.
 *
 * @param  index (int)  Position in the collection to set the layer.
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to be set in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void SetItem(int index, MgLayerBase value) throws MgException  {
    MapGuideJavaApiJNI.MgLayerCollection_SetItem(swigCPtr, index, MgLayerBase.getCPtr(value));
  }

  
/**
 * Adds a layer to the end of the collection.
 *
 * @param  value ({@link MgLayerBase})  Layer to be added.
 * @return  Returns nothing.
 */
 public void Add(MgLayerBase value) throws MgException  {
    MapGuideJavaApiJNI.MgLayerCollection_Add(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Inserts a layer at a specified location in the collection.
 *
 * @param  index (int)  Position in the collection to insert the layer.
 * @param  value ({@link MgLayerBase})  Layer to be inserted in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void Insert(int index, MgLayerBase value) throws MgException  {
    MapGuideJavaApiJNI.MgLayerCollection_Insert(swigCPtr, index, MgLayerBase.getCPtr(value));
  }

  
/**
 * Removes all layers from the collection.
 *
 * @return  Returns nothing.
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgLayerCollection_Clear(swigCPtr);
  }

  
/**
 * Removes a layer from the collection.
 *
 * @param  value ({@link MgLayerBase})  Layer to be removed.
 * @return  Returns true if removal was successful.
 */
 public boolean Remove(MgLayerBase value) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerCollection_Remove(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Removes a layer from the collection at the specified index.
 *
 * @param  index (int)  Index of the layer to be removed.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgLayerCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Determines if the collection contains the specified layer.
 *
 * @param  name (String/string)  Name of the layer to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean Contains(String name) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerCollection_Contains__SWIG_0(swigCPtr, name);
  }

  
/**
 * Determines if the collection contains the specified layer.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean Contains(MgLayerBase value) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerCollection_Contains__SWIG_1(swigCPtr, MgLayerBase.getCPtr(value));
  }

  
/**
 * Gets the index of the specified layer in the collection.
 *
 * @param  name (String/string)  Name of the layer to search for.
 * @return  Returns the layer's index if the collection contains the
 *  specified layer, or false (-1) otherwise.
 */
 public int IndexOf(String name) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerCollection_IndexOf__SWIG_0(swigCPtr, name);
  }

  
/**
 * Gets the index of the specified layer in the collection.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerBase} to search for.
 * @return  Returns the layer's index if the collection contains the
 *  specified layer, or false (-1) otherwise.
 */
 public int IndexOf(MgLayerBase value) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerCollection_IndexOf__SWIG_1(swigCPtr, MgLayerBase.getCPtr(value));
  }

}
