/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Manipulates collections of {@link MgLayerGroup} objects.
 *
 */
 public class MgLayerGroupCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgLayerGroupCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgLayerGroupCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayerGroupCollection() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgLayerGroupCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayerGroupCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of layer groups in the collection.
 *
 * @return  Returns the number of layer groups.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroupCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the layer group at the specified index.
 *
 * @param  index (int)  Index of the layer group to get.
 * @return  Returns the layer group.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public MgLayerGroup GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLayerGroupCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLayerGroup)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the layer group with the specified name.
 *
 * @param  name (String/string)  Name of the layer group to get.
 * @return  Returns the layer group.
 * @exception  MgObjectNotFoundException if the name does not exist.
 */
 public MgLayerGroup GetItem(String name) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLayerGroupCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgLayerGroup)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the layer group in the collection at the specified index to
 * the specified value.
 *
 * @param  index (int)  Position in the collection to set the layer group.
 * @param  value ({@link MgLayerGroup})  {@link MgLayerGroup} to be set in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void SetItem(int index, MgLayerGroup value) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroupCollection_SetItem(swigCPtr, index, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Adds a layer group to the end of the collection.
 *
 * @param  value ({@link MgLayerGroup})  Layer group to be added.
 * @return  Returns nothing.
 */
 public void Add(MgLayerGroup value) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroupCollection_Add(swigCPtr, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Inserts a layer group at a specified location in the collection.
 *
 * @param  index (int)  Position in the collection to insert the layer group.
 * @param  value ({@link MgLayerGroup})  Layer group to be inserted in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void Insert(int index, MgLayerGroup value) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroupCollection_Insert(swigCPtr, index, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Removes all layer groups from the collection.
 *
 * @return  Returns nothing.
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroupCollection_Clear(swigCPtr);
  }

  
/**
 * Removes a layer group from the collection.
 *
 * @param  value ({@link MgLayerGroup})  Layer group to be removed.
 * @return  Returns true if removal was successful.
 */
 public boolean Remove(MgLayerGroup value) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroupCollection_Remove(swigCPtr, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Removes a layer group from the collection at the specified index.
 *
 * @param  index (int)  Index of the layer group to be removed.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgLayerGroupCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Determines if the collection contains the specified layer group.
 *
 * @param  name (String/string)  Name of the layer group to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean Contains(String name) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroupCollection_Contains__SWIG_0(swigCPtr, name);
  }

  
/**
 * Determines if the collection contains the specified layer group.
 *
 * @param  value ({@link MgLayerGroup})  {@link MgLayerGroup} to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean Contains(MgLayerGroup value) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroupCollection_Contains__SWIG_1(swigCPtr, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Gets the index of the specified layer group in the collection.
 *
 * @param  name (String/string)  Name of the layer group to search for.
 * @return  Returns the layer group's index if the collection contains the
 *  specified layer group, or false (-1) otherwise.
 */
 public int IndexOf(String name) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroupCollection_IndexOf__SWIG_0(swigCPtr, name);
  }

  
/**
 * Gets the index of the specified layer group in the collection.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerGroup} to search for.
 * @return  Returns the layer group's index if the collection contains the
 *  specified layer group, or false (-1) otherwise.
 */
 public int IndexOf(MgLayerGroup value) throws MgException  {
    return MapGuideJavaApiJNI.MgLayerGroupCollection_IndexOf__SWIG_1(swigCPtr, MgLayerGroup.getCPtr(value));
  }

}
