/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Provides forward-only, read-only functionality for describing
 * a set of long transactions that exist in the feature source.
 *
 */
 public class MgLongTransactionReader extends MgSerializable {
  private long swigCPtr;

  public MgLongTransactionReader(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgLongTransactionReaderToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLongTransactionReader() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgLongTransactionReader(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLongTransactionReader obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the name of the long transaction currently being read.
 *
 * @return  Returns the name of the long transaction.
 */
 public String GetName() throws MgException  {
  { return MapGuideJavaApiJNI.MgLongTransactionReader_GetName(swigCPtr); }
}

  
/**
 * Gets the description of the long transaction currently being
 * read.
 *
 * @return  Returns the description of the long transaction.
 */
 public String GetDescription() throws MgException  {
  { return MapGuideJavaApiJNI.MgLongTransactionReader_GetDescription(swigCPtr); }
}

  
/**
 * Provides access to the direct descendant long transactions
 * for the long transaction being currently read.
 *
 * @return  Returns an {@link MgLongTransactionReader} instance containing the
 *  direct descendants for the long transaction currently being
 *  read.
 */
 public MgLongTransactionReader GetChildren() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLongTransactionReader_GetChildren(swigCPtr);
    return (cPtr == 0) ? null : (MgLongTransactionReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Provides access to the direct ascendant long transactions for
 * the long transaction being currently read.
 *
 * @return  Returns an {@link MgLongTransactionReader} instance containing the
 *  direct ascendants for the long transaction currently being
 *  read.
 */
 public MgLongTransactionReader GetParents() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLongTransactionReader_GetParents(swigCPtr);
    return (cPtr == 0) ? null : (MgLongTransactionReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the owner of the long transaction currently being read.
 *
 * @return  Returns the owner name.
 */
 public String GetOwner() throws MgException  {
  { return MapGuideJavaApiJNI.MgLongTransactionReader_GetOwner(swigCPtr); }
}

  
/**
 * Gets the creation date of the long transaction currently
 * being read.
 *
 * @return  Returns an {@link MgDateTime} object containing the date when the
 *  long transaction was created.
 */
 public MgDateTime GetCreationDate() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLongTransactionReader_GetCreationDate(swigCPtr);
    return (cPtr == 0) ? null : (MgDateTime)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Specifies whether the long transaction currently being read
 * is the active long transaction.
 *
 * @return  Returns true if the long transaction is active; otherwise
 *  returns false.
 */
 public boolean IsActive() throws MgException  {
    return MapGuideJavaApiJNI.MgLongTransactionReader_IsActive(swigCPtr);
  }

  
/**
 * Specifies whether the long transaction currently being read
 * is frozen.
 *
 * @return  Returns true if the long transaction is frozen; otherwise
 *  returns false.
 */
 public boolean IsFrozen() throws MgException  {
    return MapGuideJavaApiJNI.MgLongTransactionReader_IsFrozen(swigCPtr);
  }

  
/**
 * Advances the reader to the next long transaction.
 *
 * @return  Returns true if there is a next item.
 */
 public boolean ReadNext() throws MgException  {
    return MapGuideJavaApiJNI.MgLongTransactionReader_ReadNext(swigCPtr);
  }

  
/**
 * Closes the {@link MgLongTransactionReader} object, freeing any
 * resources it may be holding.
 *
 * @return  Returns nothing.
 */
 public void Close() throws MgException  {
    MapGuideJavaApiJNI.MgLongTransactionReader_Close(swigCPtr);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Serializes the long transactions in the reader to XML whose structure
 * is governed by the FdoLongTransactionList schema.
 *
 * @return  Returns an {@link MgByteReader} object containing the contents of
 *  the long transaction reader in XML format.
 */
 public MgByteReader ToXml() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgLongTransactionReader_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
