/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * The {@link MgMapPlot} class allows the developer to specify the map,
 * the view of the map, the plot specification, and the layout
 * for one sheet within a call to GenerateMultiPlot.
 *
 */
 public class MgMapPlot extends MgNamedSerializable {
  private long swigCPtr;

  public MgMapPlot(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgMapPlotToMgNamedSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgMapPlot() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgMapPlot(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgMapPlot obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Create and initialize an {@link MgMapPlot} instance using
 * the map center and scale. Sets the MapPlotInstruction value
 * appropriately.
 *
 * @return  Nothing.
 */
 public MgMapPlot(MgMap map, MgPlotSpecification plotSpec, MgLayout layout) throws MgException {
    this(MapGuideJavaApiJNI.new_MgMapPlot__SWIG_0(MgMap.getCPtr(map), MgPlotSpecification.getCPtr(plotSpec), MgLayout.getCPtr(layout)), true);
  }

  
/**
 * Create and initialize an {@link MgMapPlot} instance using
 * the specified center and scale.  Sets the MapPlotInstruction value
 * appropriately.
 *
 * @return  Nothing.
 */
 public MgMapPlot(MgMap map, MgCoordinate center, double scale, MgPlotSpecification plotSpec, MgLayout layout) throws MgException {
    this(MapGuideJavaApiJNI.new_MgMapPlot__SWIG_1(MgMap.getCPtr(map), MgCoordinate.getCPtr(center), scale, MgPlotSpecification.getCPtr(plotSpec), MgLayout.getCPtr(layout)), true);
  }

  
/**
 * Create and initialize an {@link MgMapPlot} instance using
 * the specified extents  Sets the MapPlotInstruction value
 * appropriately.
 *
 * @return  Nothing.
 */
 public MgMapPlot(MgMap map, MgEnvelope extent, boolean expandToFit, MgPlotSpecification plotSpec, MgLayout layout) throws MgException {
    this(MapGuideJavaApiJNI.new_MgMapPlot__SWIG_2(MgMap.getCPtr(map), MgEnvelope.getCPtr(extent), expandToFit, MgPlotSpecification.getCPtr(plotSpec), MgLayout.getCPtr(layout)), true);
  }

  
/**
 * Get the {@link MgMap} object to plot.
 *
 * @return  The {@link MgMap} object.
 */
 public MgMap GetMap() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapPlot_GetMap(swigCPtr);
    return (cPtr == 0) ? null : (MgMap)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Set the {@link MgMap} object to plot.
 *
 * @param  map ({@link MgMap})  The {@link MgMap} object to plot.
 * @return  Nothing
 */
 public void SetMap(MgMap map) throws MgException  {
    MapGuideJavaApiJNI.MgMapPlot_SetMap(swigCPtr, MgMap.getCPtr(map));
  }

  
/**
 * Get the MapPlotInstruction, which defines how the view of the map
 * to be plotted is defined.
 *
 * @return  The MapPlotInstruction value.
 */
 public int GetMapPlotInstruction() throws MgException  {
    return MapGuideJavaApiJNI.MgMapPlot_GetMapPlotInstruction(swigCPtr);
  }

  
/**
 * Set the MapPlotInstruction, which defines how the view of the map
 * to be plotted is defined.
 *
 * @param  plotInstruction (int)  The enumeration value defining  how the view of the map is defined.
 * @return  Nothing
 */
 public void SetMapPlotInstruction(int plotInstruction) throws MgException  {
    MapGuideJavaApiJNI.MgMapPlot_SetMapPlotInstruction(swigCPtr, plotInstruction);
  }

  
/**
 * Get view center
 *
 * @return  The coordinates of the center of the view of map
 */
 public MgCoordinate GetCenter() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapPlot_GetCenter(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Get view scale
 *
 * @return  The scale of the view of map
 */
 public double GetScale() throws MgException  {
    return MapGuideJavaApiJNI.MgMapPlot_GetScale(swigCPtr);
  }

  
/**
 * Set the view center and scale of the map.
 *
 * @param  center ({@link MgCoordinate})  The coordinates of the center of the view of the map.
 * @param  scale (double)  The scale of the view of the map.
 * @return  Nothing
 */
 public void SetCenterAndScale(MgCoordinate center, double scale) throws MgException  {
    MapGuideJavaApiJNI.MgMapPlot_SetCenterAndScale(swigCPtr, MgCoordinate.getCPtr(center), scale);
  }

  
/**
 * Get extents of the view of the map.
 *
 * @return  The extents of the view of the map.
 */
 public MgEnvelope GetExtent() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapPlot_GetExtent(swigCPtr);
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets flag indicating whether extents of the view of the map
 * should be expanded to fill the space within the page margins.
 *
 * @return  The expand to fit flag.
 */
 public boolean GetExpandToFit() throws MgException  {
    return MapGuideJavaApiJNI.MgMapPlot_GetExpandToFit(swigCPtr);
  }

  
/**
 * Set the extents of the map.
 *
 * @param  extent ({@link MgEnvelope})  The extents of the map.
 * @param  expandToFit (boolean/bool)  Flag indicating whether the extents should be  expanded to fill the space within the page margins.
 * @return  Nothing
 */
 public void SetExtent(MgEnvelope extent, boolean expandToFit) throws MgException  {
    MapGuideJavaApiJNI.MgMapPlot_SetExtent(swigCPtr, MgEnvelope.getCPtr(extent), expandToFit);
  }

  
/**
 * Gets the plot specification.
 *
 * @return  The {@link MgPlotSpecification}.
 */
 public MgPlotSpecification GetPlotSpecification() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapPlot_GetPlotSpecification(swigCPtr);
    return (cPtr == 0) ? null : (MgPlotSpecification)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Set the plot specification.
 *
 * @param  plotSpec ({@link MgPlotSpecification})  The plot specification.
 * @return  Nothing
 */
 public void SetPlotSpecification(MgPlotSpecification plotSpec) throws MgException  {
    MapGuideJavaApiJNI.MgMapPlot_SetPlotSpecification(swigCPtr, MgPlotSpecification.getCPtr(plotSpec));
  }

  
/**
 * Get the layout.  This value is optional; if null the map will fill
 * the entire page area within the margins.
 *
 * @return  The {@link MgLayout}.
 */
 public MgLayout GetLayout() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgMapPlot_GetLayout(swigCPtr);
    return (cPtr == 0) ? null : (MgLayout)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Set the layout.
 *
 * @param  layout ({@link MgLayout})  The object defining the layout for the plot.
 * @return  Nothing
 */
 public void SetLayout(MgLayout layout) throws MgException  {
    MapGuideJavaApiJNI.MgMapPlot_SetLayout(swigCPtr, MgLayout.getCPtr(layout));
  }

}
