/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Defines a feature property which contains one or more objects
 * whose type is a feature class. If there is more than one
 * object, an identity property is defined that is used to
 * select an object from the collection.
 *
 */
 public class MgObjectPropertyDefinition extends MgPropertyDefinition {
  private long swigCPtr;

  public MgObjectPropertyDefinition(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgObjectPropertyDefinitionToMgPropertyDefinition(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgObjectPropertyDefinition() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgObjectPropertyDefinition(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgObjectPropertyDefinition obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs a {@link MgObjectPropertyDefinition} object.
 *
 * @param  name (String/string)  The name of the property.
 */
 public MgObjectPropertyDefinition(String name) throws MgException {
    this(MapGuideJavaApiJNI.new_MgObjectPropertyDefinition(name), true);
  }

  
/**
 * Gets an {@link MgClassDefinition} object that defines the type of
 * this property.
 *
 * @return  Returns an {@link MgClassDefinition} object.
 */
 public MgClassDefinition GetClassDefinition() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgObjectPropertyDefinition_GetClassDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgClassDefinition)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the type of this object property (value, collection, or
 * ordered collection).
 *
 * @return  Returns an {@link MgObjectPropertyType} value.
 */
 public int GetObjectType() throws MgException  {
    return MapGuideJavaApiJNI.MgObjectPropertyDefinition_GetObjectType(swigCPtr);
  }

  
/**
 * Gets the {@link MgOrderingOption} value (ascending or descending) for
 * this object property.
 *
 * @return  Returns an {@link MgOrderingOption} value.
 */
 public int GetOrderType() throws MgException  {
    return MapGuideJavaApiJNI.MgObjectPropertyDefinition_GetOrderType(swigCPtr);
  }

  
/**
 * Gets an {@link MgDataPropertyDefinition} object that defines the
 * property used to identify an object property uniquely.
 *
 * @return  Returns an {@link MgDataPropertyDefinition} object if the type of
 *  the object property is {@link MgObjectPropertyType}::Collection or
 *  {@link MgObjectPropertyType}::OrderedCollection.
 */
 public MgDataPropertyDefinition GetIdentityProperty() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgObjectPropertyDefinition_GetIdentityProperty(swigCPtr);
    return (cPtr == 0) ? null : (MgDataPropertyDefinition)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets a reference to the {@link MgClassDefinition} that defines the
 * type of this property.
 *
 * @param  classDef ({@link MgClassDefinition})  The class definition used to create the  object or objects that constitute the  property.
 * @return  Returns nothing.
 */
 public void SetClassDefinition(MgClassDefinition classDef) throws MgException  {
    MapGuideJavaApiJNI.MgObjectPropertyDefinition_SetClassDefinition(swigCPtr, MgClassDefinition.getCPtr(classDef));
  }

  
/**
 * Sets the {@link MgObjectPropertyType} type (either value, collection,
 * or ordered collection) of this object property.
 *
 * @param  objType (int)  The {@link MgObjectPropertyType} type of this  object property.
 * @return  Returns nothing.
 */
 public void SetObjectType(int objType) throws MgException  {
    MapGuideJavaApiJNI.MgObjectPropertyDefinition_SetObjectType(swigCPtr, objType);
  }

  
/**
 * Sets the {@link MgOrderingOption} type (either ascending or
 * descending) for this object property.
 *
 * @param  orderType (int)  The ordering option type of this object  property.
 * @return  Returns nothing.
 */
 public void SetOrderType(int orderType) throws MgException  {
    MapGuideJavaApiJNI.MgObjectPropertyDefinition_SetOrderType(swigCPtr, orderType);
  }

  
/**
 * Sets a reference to an {@link MgDataPropertyDefinition} used to
 * create the identity properties that uniquely identify the
 * objects that constitute the object property.
 *
 * @param  propDef ({@link MgDataPropertyDefinition})  The data property definition used to create  the identity properties for the object  collection in this object property.
 * @return  Returns nothing.
 */
 public void SetIdentityProperty(MgDataPropertyDefinition propDef) throws MgException  {
    MapGuideJavaApiJNI.MgObjectPropertyDefinition_SetIdentityProperty(swigCPtr, MgDataPropertyDefinition.getCPtr(propDef));
  }

}
