package org.osgeo.mapguide;


/**
 * The {@link MgParameterDirection} defines integer constants used to signify the
 * direction in which a parameter value will be used within the context of a
 * FDO Command.
 *
 * @since  2.2 */
public class MgParameterDirection
{
   
/**
 * Specifies that the parameter is an input parameter.
 *
 */

   public static final int Input = 0 ; 
   
/**
 * Specifies that the parameter is an output parameter.
 *
 */

   public static final int Output = 1 ; 
   
/**
 * Specifies that the parameter is an input and output parameter.
 *
 */

   public static final int InputOutput = 2 ; 
   
/**
 * Specifies that the parameter is a return parameter.
 *
 */

   public static final int Ret = 3 ; 
   
}

