/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class provides services to profile exsiting MapGuide APIs
 *
 * @since  2.4 */
 public class MgProfilingService extends MgService {
  private long swigCPtr;

  public MgProfilingService(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgProfilingServiceToMgService(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgProfilingService() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgProfilingService(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgProfilingService obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Profile the process of rendering all dynamic layers in the specified
 * {@link MgMap} to a dynamic overlay image with a transparent background.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  options  Input  rendering options
 * @return  A byte reader containing the profile result
 */
 public MgByteReader ProfileRenderDynamicOverlay(MgMap map, MgSelection selection, MgRenderingOptions options) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgProfilingService_ProfileRenderDynamicOverlay(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgRenderingOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Profile the process of rendering a {@link MgMap} to the requested image
 * format with specified center point and scale.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  center  Input  map center point. Specifies the center point for the map
 * @param  scale  Input  map scale. Specifies the scale for the map
 * @param  width  Input  image width. Specifies the image width in pixels
 * @param  height  Input  image height. Specifies the image height in pixels
 * @param  backgroundColor  Input  background color. Specifies the map background color
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @return  A byte reader containing the profile result
 */
 public MgByteReader ProfileRenderMap(MgMap map, MgSelection selection, MgCoordinate center, double scale, int width, int height, MgColor backgroundColor, String format, boolean bKeepSelection) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgProfilingService_ProfileRenderMap(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgCoordinate.getCPtr(center), scale, width, height, MgColor.getCPtr(backgroundColor), format, bKeepSelection);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
