/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgPropertyCollection} represents a collection of properties.
 * All properties contained in an instance of a property
 * collection are objects whose base class is {@link MgProperty} and
 * whose derived class is one of the classes referenced in the
 *
 */
 public class MgPropertyCollection extends MgCollection {
  private long swigCPtr;

  public MgPropertyCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgPropertyCollectionToMgCollection(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgPropertyCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgPropertyCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs a PropertyCollection.  The collection is initially empty.
 *
 */
 public MgPropertyCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgPropertyCollection(), true);
  }

  
/**
 * Sets the item in the collection at the specified index to the specified value.
 *
 * @param  index (int)  Input index
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 * @exception  MgDuplicateObjectException if it is a duplicate.
 */
 public void SetItem(int index, MgProperty value) throws MgException  {
    MapGuideJavaApiJNI.MgPropertyCollection_SetItem(swigCPtr, index, MgProperty.getCPtr(value));
  }

  
/**
 * Adds the specified item to the end of the collection.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns nothing.
 * @exception  MgDuplicateObjectException if the index is a duplicate.
 */
 public void Add(MgProperty value) throws MgException  {
    MapGuideJavaApiJNI.MgPropertyCollection_Add(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Inserts the specified item at the specified index within the collection.
 * Items following the insertion point are moved down to accommodate the new item.
 *
 * @param  index (int)  Input index
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 * @exception  MgDuplicateObjectException if it is a duplicate.
 */
 public void Insert(int index, MgProperty value) throws MgException  {
    MapGuideJavaApiJNI.MgPropertyCollection_Insert(swigCPtr, index, MgProperty.getCPtr(value));
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns true if removal was successful.
 */
 public boolean Remove(MgProperty value) throws MgException  {
    return MapGuideJavaApiJNI.MgPropertyCollection_Remove(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Gets the item in the collection at the specified index.
 *
 * @param  index (int)  Input index
 * @return  Returns the item in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public MgProperty GetItem(int index) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgPropertyCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgProperty)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the item in the collection with the specified name.
 *
 * @param  name (String/string)  Input item name
 * @return  Returns the item in the collection with the specified name.
 * @exception  MgObjectNotFoundException if the item does not exist within the collection.
 */
 public MgProperty GetItem(String name) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgPropertyCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgProperty)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the number of items in the collection.
 *
 * @return  Returns the number of items in the collection.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgPropertyCollection_GetCount(swigCPtr);
  }

  
/**
 * Removes all items from the collection.
 *
 * @return  Returns nothing.
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgPropertyCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  index (int)  Input index
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgPropertyCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns true if the collection contains the specified item, false otherwise.
 */
 public boolean Contains(MgProperty value) throws MgException  {
    return MapGuideJavaApiJNI.MgPropertyCollection_Contains__SWIG_0(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  name (String/string)  Input the item name
 * @return  Returns true if the collection contains the specified item, false otherwise.
 */
 public boolean Contains(String name) throws MgException  {
    return MapGuideJavaApiJNI.MgPropertyCollection_Contains__SWIG_1(swigCPtr, name);
  }

  
/**
 * Returns the index of the specified item in the collection or -1 if the item does not exist.
 *
 * @param  value ({@link MgProperty})  Input value
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist.
 */
 public int IndexOf(MgProperty value) throws MgException  {
    return MapGuideJavaApiJNI.MgPropertyCollection_IndexOf__SWIG_0(swigCPtr, MgProperty.getCPtr(value));
  }

  
/**
 * Returns the index of the specified item (by name) in the collection or -1 if the item does not exist.
 *
 * @param  name (String/string)  Input the item name
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist.
 */
 public int IndexOf(String name) throws MgException  {
    return MapGuideJavaApiJNI.MgPropertyCollection_IndexOf__SWIG_1(swigCPtr, name);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates an XML document representing the collection.
 * The order of the properties in the XML is the same as the order of the properties in the collection.
 * It starts with item zero to length of collection.
 * TODO: Add a snippet of XML here?
 *
 * @return  A pointer to an {@link MgByteReader} object.
 */
 public MgByteReader ToXml() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgPropertyCollection_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
