package org.osgeo.mapguide;


/**
 * Enumerated values used to determine the type
 * of units for plot decorations (scale bar).
 *
 */
public class MgRasterDataModelType
{
   
/**
 * Data is organized in an unknown or provider specific manner.
 *
 */

   public static final int Unknown  = 0; 
   
/**
 * Data is rectangular grid, floating point data model.
 *
 */

   public static final int Data  = 1; 
   
/**
 * Data is one bit (black/white - bitonal) pixels.
 *
 */

   public static final int Bitonal  = 2; 
   
/**
 * Data is monochrome (black->gray->white) pixels.
 * It is necessary to know the BitsPerPixel value to interpret the data.
 *
 */

   public static final int Gray  = 3; 
   
/**
 * Data is red/green/blue (in that order) pixels.
 * It is necessary to know the BitsPerPixel value to interpret the data.
 *
 */

   public static final int RGB  = 4; 
   
/**
 * Data is red/green/blue/alpha (in that order) pixels; RGB with transparency.
 * It is necessary to know the BitsPerPixel value to interpret the data.
 *
 */

   public static final int RGBA  = 5; 
   
/**
 * Data is monochrome but backed by a pallette (value->pallette->colour) pixels.
 * It is necessary to know the BitsPerPixel value to interpret the data.
 *
 */

   public static final int Palette  = 6; 
   
}

