/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class provides services to render a map into an image
 *
 */
 public class MgRenderingService extends MgService {
  private long swigCPtr;

  public MgRenderingService(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgRenderingServiceToMgService(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgRenderingService() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgRenderingService(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgRenderingService obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Returns the specified base map tile for the given map.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  baseMapLayerGroupName  Input  Specifies the name of the baseMapLayerGroup for which to render the tile.
 * @param  tileColumn  Input  Specifies the column index of the tile to return.
 * @param  tileRow  Input  Specifies the row index of the tile to return.
 * @return  A byte reader containing the rendered tile image.
 */
@Deprecated
 public MgByteReader RenderTile(MgMap map, String baseMapLayerGroupName, int tileColumn, int tileRow) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderTile__SWIG_0(swigCPtr, MgMap.getCPtr(map), baseMapLayerGroupName, tileColumn, tileRow);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the specified base map tile for the given map.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  baseMapLayerGroupName  Input  Specifies the name of the baseMapLayerGroup for which to render the tile.
 * @param  tileColumn  Input  Specifies the column index of the tile to return.
 * @param  tileRow  Input  Specifies the row index of the tile to return.
 * @param  tileWidth  Input  Specifies the width of the tile to return.
 * @param  tileHeight  Input  Specifies the height of the tile to return.
 * @param  tileDpi  Input  Specifies the dpi the tile to return.
 * @param  tileImageFormat  Input
 * @return  A byte reader containing the rendered tile image.
 */
 public MgByteReader RenderTile(MgMap map, String baseMapLayerGroupName, int tileColumn, int tileRow, int tileWidth, int tileHeight, int tileDpi, String tileImageFormat) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderTile__SWIG_1(swigCPtr, MgMap.getCPtr(map), baseMapLayerGroupName, tileColumn, tileRow, tileWidth, tileHeight, tileDpi, tileImageFormat);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the specified map tile for the given map. Tile structure is
 * based on the XYZ tiling scheme used by Google Maps, OpenStreetMap, and
 * others
 *
 * @param  map  Input  map object containing current state of map.
 * @param  baseMapLayerGroupName  Input  Specifies the name of the baseMapLayerGroup for which to render the tile.
 * @param  x  Input  Specifies the row index of the tile to return.
 * @param  y  Input  Specifies the column index of the tile to return.
 * @param  z  Input  Specifies the zoom level of the tile to return.
 * @return  A byte reader containing the rendered tile image.
 * @since  3.0 */
 public MgByteReader RenderTileXYZ(MgMap map, String baseMapLayerGroupName, int x, int y, int z) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderTileXYZ__SWIG_0(swigCPtr, MgMap.getCPtr(map), baseMapLayerGroupName, x, y, z);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the specified map tile for the given map. Tile structure is
 * based on the XYZ tiling scheme used by Google Maps, OpenStreetMap, and
 * others
 *
 * @param  map  Input  map object containing current state of map.
 * @param  baseMapLayerGroupName  Input  Specifies the name of the baseMapLayerGroup for which to render the tile.
 * @param  x  Input  Specifies the row index of the tile to return.
 * @param  y  Input  Specifies the column index of the tile to return.
 * @param  z  Input  Specifies the zoom level of the tile to return.
 * @param  dpi  Input  Specifies the dpi of the tile to return.
 * @param  tileImageFormat  Input  Specifies the image format of the tile to return.
 * @return  A byte reader containing the rendered tile image.
 */
 public MgByteReader RenderTileXYZ(MgMap map, String baseMapLayerGroupName, int x, int y, int z, int dpi, String tileImageFormat) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderTileXYZ__SWIG_1(swigCPtr, MgMap.getCPtr(map), baseMapLayerGroupName, x, y, z, dpi, tileImageFormat);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders all dynamic layers in the specified {@link MgMap} to a dynamic overlay image
 * with a transparent background. The center, scale, size, and layers to be
 * rendered are defined by the specified map instance.  The format parameter
 * must be set to an image format that supports transparency.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  format  Input  image format. Defines the format of the resulting image
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderDynamicOverlay(MgMap map, MgSelection selection, String format) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderDynamicOverlay__SWIG_0(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders all dynamic layers in the specified {@link MgMap} to a dynamic overlay image
 * with a transparent background. The center, scale, size, and layers to be
 * rendered are defined by the specified map instance.  The format parameter
 * must be set to an image format that supports transparency.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderDynamicOverlay(MgMap map, MgSelection selection, String format, boolean bKeepSelection) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderDynamicOverlay__SWIG_1(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), format, bKeepSelection);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders all dynamic layers in the specified {@link MgMap} to a dynamic overlay image
 * with a transparent background. The center, scale, size, and layers to be
 * rendered are defined by the specified map instance.  The format parameter
 * must be set to an image format that supports transparency.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  options  Input  rendering options
 * @return  A byte reader containing the rendered image
 * @since  2.0 */
 public MgByteReader RenderDynamicOverlay(MgMap map, MgSelection selection, MgRenderingOptions options) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderDynamicOverlay__SWIG_2(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgRenderingOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  format  Input  image format. Defines the format of the resulting image
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, String format) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_0(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, String format, boolean bKeepSelection) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_1(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), format, bKeepSelection);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @param  bClip  Input  true if you want to clip feature geometry
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, String format, boolean bKeepSelection, boolean bClip) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_2(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), format, bKeepSelection, bClip);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @param  bClip  Input  true if you want to clip feature geometry
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, String format, boolean bKeepSelection, boolean bClip, MgColor selectionColor) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_3(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), format, bKeepSelection, bClip, MgColor.getCPtr(selectionColor));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  extents  Input  map extents. Specifies the extents for the map
 * @param  width  Input  image width. Specifies the image width in pixels
 * @param  height  Input  image height. Specifies the image height in pixels
 * @param  backgroundColor  Input  background color. Specifies the map background color
 * @param  format  Input  image format. Defines the format of the resulting image
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, MgEnvelope extents, int width, int height, MgColor backgroundColor, String format) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_4(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgEnvelope.getCPtr(extents), width, height, MgColor.getCPtr(backgroundColor), format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  extents  Input  map extents. Specifies the extents for the map
 * @param  width  Input  image width. Specifies the image width in pixels
 * @param  height  Input  image height. Specifies the image height in pixels
 * @param  backgroundColor  Input  background color. Specifies the map background color
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, MgEnvelope extents, int width, int height, MgColor backgroundColor, String format, boolean bKeepSelection) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_5(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgEnvelope.getCPtr(extents), width, height, MgColor.getCPtr(backgroundColor), format, bKeepSelection);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  center  Input  map center point. Specifies the center point for the map
 * @param  scale  Input  map scale. Specifies the scale for the map
 * @param  width  Input  image width. Specifies the image width in pixels
 * @param  height  Input  image height. Specifies the image height in pixels
 * @param  backgroundColor  Input  background color. Specifies the map background color
 * @param  format  Input  image format. Defines the format of the resulting image
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, MgCoordinate center, double scale, int width, int height, MgColor backgroundColor, String format) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_6(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgCoordinate.getCPtr(center), scale, width, height, MgColor.getCPtr(backgroundColor), format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  center  Input  map center point. Specifies the center point for the map
 * @param  scale  Input  map scale. Specifies the scale for the map
 * @param  width  Input  image width. Specifies the image width in pixels
 * @param  height  Input  image height. Specifies the image height in pixels
 * @param  backgroundColor  Input  background color. Specifies the map background color
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, MgCoordinate center, double scale, int width, int height, MgColor backgroundColor, String format, boolean bKeepSelection) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_7(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgCoordinate.getCPtr(center), scale, width, height, MgColor.getCPtr(backgroundColor), format, bKeepSelection);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the specified {@link MgMap} to the requested image format.
 *
 * @param  map  Input  map object containing current state of map.
 * @param  selection  Input  map feature selection. Specifies the selected features on the map
 * @param  center  Input  map center point. Specifies the center point for the map
 * @param  scale  Input  map scale. Specifies the scale for the map
 * @param  width  Input  image width. Specifies the image width in pixels
 * @param  height  Input  image height. Specifies the image height in pixels
 * @param  backgroundColor  Input  background color. Specifies the map background color
 * @param  format  Input  image format. Defines the format of the resulting image
 * @param  bKeepSelection  Input  true if you want to keep the selection
 * @param  selectionColor  Input  The color to use for rendered selections
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMap(MgMap map, MgSelection selection, MgCoordinate center, double scale, int width, int height, MgColor backgroundColor, String format, boolean bKeepSelection, MgColor selectionColor) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMap__SWIG_8(swigCPtr, MgMap.getCPtr(map), MgSelection.getCPtr(selection), MgCoordinate.getCPtr(center), scale, width, height, MgColor.getCPtr(backgroundColor), format, bKeepSelection, MgColor.getCPtr(selectionColor));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Renders the legend for the specified {@link MgMap} to the requested size and format
 *
 * @param  map  Input  map object containing current state of map.
 * @param  width  Input  width of legend image in pixels
 * @param  height  Input  height of legend image in pixels
 * @param  backgroundColor  Input  background color. Specifies the map legend background color
 * @param  format  Input  image format. Defines the format of the resulting image
 * @return  A byte reader containing the rendered image
 */
 public MgByteReader RenderMapLegend(MgMap map, int width, int height, MgColor backgroundColor, String format) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_RenderMapLegend(swigCPtr, MgMap.getCPtr(map), width, height, MgColor.getCPtr(backgroundColor), format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * The QueryFeatures operation identifies those features that
 * meet the specified spatial selection criteria. This operation
 * is used to implement server-side selection. In addition to
 * a selection set, this operation returns attribute information
 * in case only one feature is selected
 *
 * @param  map  Input  map object containing current state of map.
 * @param  layerNames  Input  Active layer names for which to query features
 * @param  filterGeometry  Input  geometry object specifying the selection area
 * @param  selectionVariant  Input  selection criterion - integer value corresponding to one of  the {@link MgFeatureSpatialOperations} values
 * @param  maxFeatures  Input  the maximum number of features to return
 * @return  An {@link MgSelection} instance identifying the features that meet the
 *  selection criteria. Returns null if no features are identified.
 */
 public MgFeatureInformation QueryFeatures(MgMap map, MgStringCollection layerNames, MgGeometry filterGeometry, int selectionVariant, int maxFeatures) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_QueryFeatures__SWIG_0(swigCPtr, MgMap.getCPtr(map), MgStringCollection.getCPtr(layerNames), MgGeometry.getCPtr(filterGeometry), selectionVariant, maxFeatures);
    return (cPtr == 0) ? null : (MgFeatureInformation)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * The QueryFeatures operation identifies those features that
 * meet the specified spatial selection criteria. This operation
 * is used to implement server-side selection. In addition to
 * a selection set, this operation returns attribute information
 * in case only one feature is selected
 *
 * @param  map  Input  map object containing current state of map.
 * @param  layerNames  Input  Active layer names for which to query features
 * @param  filterGeometry  Input  geometry object specifying the selection area
 * @param  selectionVariant  Input  selection criterion - integer value corresponding to one of  the {@link MgFeatureSpatialOperations} values
 * @param  featureFilter  Input  an XML selection string containing the required feature IDs
 * @param  maxFeatures  Input  the maximum number of features to return
 * @param  layerAttributeFilter  Input  bitmask values - 1=Visible, 2=Selectable, 4=HasTooltips
 * @return  An {@link MgSelection} instance identifying the features that meet the
 *  selection criteria. Returns null if no features are identified.
 * @since  1.2 */
 public MgFeatureInformation QueryFeatures(MgMap map, MgStringCollection layerNames, MgGeometry filterGeometry, int selectionVariant, String featureFilter, int maxFeatures, int layerAttributeFilter) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_QueryFeatures__SWIG_1(swigCPtr, MgMap.getCPtr(map), MgStringCollection.getCPtr(layerNames), MgGeometry.getCPtr(filterGeometry), selectionVariant, featureFilter, maxFeatures, layerAttributeFilter);
    return (cPtr == 0) ? null : (MgFeatureInformation)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * The QueryFeatureProeprties operation identifies those features that
 * meet the specified spatial selection criteria. This operation
 * is used to implement WMS feature info and returns property values
 * for all features which match the spatial query
 *
 * @param  map  Input  map object containing current state of map.
 * @param  layerNames  Input  Active layer names for which to query features
 * @param  filterGeometry  Input  geometry object specifying the selection area
 * @param  selectionVariant  Input  selection criterion - integer value corresponding to one of  the {@link MgFeatureSpatialOperations} values
 * @param  maxFeatures  Input  the maximum number of features to return
 * @return  An {@link MgSelection} instance identifying the features that meet the
 *  selection criteria. Returns null if no features are identified.
 */
 public MgBatchPropertyCollection QueryFeatureProperties(MgMap map, MgStringCollection layerNames, MgGeometry filterGeometry, int selectionVariant, int maxFeatures) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_QueryFeatureProperties__SWIG_0(swigCPtr, MgMap.getCPtr(map), MgStringCollection.getCPtr(layerNames), MgGeometry.getCPtr(filterGeometry), selectionVariant, maxFeatures);
    return (cPtr == 0) ? null : (MgBatchPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * The QueryFeatureProperties operation identifies those features that
 * meet the specified spatial selection criteria. This operation
 * is used to implement WMS feature info and returns property values
 * for all features which match the spatial query
 *
 * @param  map  Input  map object containing current state of map.
 * @param  layerNames  Input  Active layer names for which to query features
 * @param  filterGeometry  Input  geometry object specifying the selection area
 * @param  selectionVariant  Input  selection criterion - integer value corresponding to one of  the {@link MgFeatureSpatialOperations} values
 * @param  featureFilter  Input  an XML selection string containing the required feature IDs
 * @param  maxFeatures  Input  the maximum number of features to return
 * @param  layerAttributeFilter  Input  bitmask values - 1=Visible, 2=Selectable, 4=HasTooltips
 * @return  An {@link MgSelection} instance identifying the features that meet the
 *  selection criteria. Returns null if no features are identified.
 * @since  1.2 */
 public MgBatchPropertyCollection QueryFeatureProperties(MgMap map, MgStringCollection layerNames, MgGeometry filterGeometry, int selectionVariant, String featureFilter, int maxFeatures, int layerAttributeFilter) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgRenderingService_QueryFeatureProperties__SWIG_1(swigCPtr, MgMap.getCPtr(map), MgStringCollection.getCPtr(layerNames), MgGeometry.getCPtr(filterGeometry), selectionVariant, featureFilter, maxFeatures, layerAttributeFilter);
    return (cPtr == 0) ? null : (MgBatchPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
