/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public class MgSelectionBase extends MgResource {
  private long swigCPtr;

  public MgSelectionBase(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgSelectionBaseToMgResource(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgSelectionBase() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgSelectionBase(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgSelectionBase obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Initialize selection generation from a map
 *
 */
 public MgSelectionBase(MgMapBase map) throws MgException {
    this(MapGuideJavaApiJNI.new_MgSelectionBase__SWIG_0(MgMapBase.getCPtr(map)), true);
  }

  
/**
 * Initialize selection from a map and xml selection
 *
 */
 public MgSelectionBase(MgMapBase map, String xmlSelectionString) throws MgException {
    this(MapGuideJavaApiJNI.new_MgSelectionBase__SWIG_1(MgMapBase.getCPtr(map), xmlSelectionString), true);
  }

  
/**
 * Returns the number of selected features.
 *
 * @param  layer ({@link MgLayerBase})  Input layer.
 * @param  className (String/string)  Input feature class name.
 * @return  Returns Count of all selected features.
 * @since  2.0 */
 public int GetSelectedFeaturesCount(MgLayerBase layer, String className) throws MgException  {
    return MapGuideJavaApiJNI.MgSelectionBase_GetSelectedFeaturesCount(swigCPtr, MgLayerBase.getCPtr(layer), className);
  }

  
/**
 * Returns the selected feature data for the specified feature class.
 *
 * @param  layer ({@link MgLayerBase})  Input layer.
 * @param  className (String/string)  Input feature class name.
 * @param  mappedOnly (boolean/bool)  Return mapped (true) or all (false) properties for selected features
 * @return  Returns a feature reader containing all the features for the given
 *  feature class in this selection.
 * @since  2.0 */
 public MgFeatureReader GetSelectedFeatures(MgLayerBase layer, String className, boolean mappedOnly) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSelectionBase_GetSelectedFeatures__SWIG_0(swigCPtr, MgLayerBase.getCPtr(layer), className, mappedOnly);
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  layer ({@link MgLayerBase})  Input layer.
 * @param  className (String/string)  Input feature class name.
 * @param  propertyNames ({@link MgStringCollection})  Properties to return for selected features.
 * @return  Returns a feature reader containing all the features for the given
 *  feature class in this selection.
 * @since  2.0 */
 public MgFeatureReader GetSelectedFeatures(MgLayerBase layer, String className, MgStringCollection propertyNames) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSelectionBase_GetSelectedFeatures__SWIG_1(swigCPtr, MgLayerBase.getCPtr(layer), className, MgStringCollection.getCPtr(propertyNames));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Read selection from XML document.  Previous selection is cleared.
 *
 */
 public void FromXml(String xmlSelectionString) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_FromXml(swigCPtr, xmlSelectionString);
  }

  
/**
 * Write selection as XML document.  This document will typically
 * be passed back to a viewer to select the desired features.
 *
 */
 public String ToXml() throws MgException  {
  { return MapGuideJavaApiJNI.MgSelectionBase_ToXml(swigCPtr); }
}

  
/**
 * Add nFeatures to selection set from the FeatureReader.
 * Specify nFeatures = 0 for all features in reader.
 * Internal identity mapping for layer dictates the properties used
 *
 */
 public void AddFeatures(MgLayerBase layer, MgFeatureReader features, int nFeatures) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_AddFeatures(swigCPtr, MgLayerBase.getCPtr(layer), MgFeatureReader.getCPtr(features), nFeatures);
  }

  
/**
 * Add a single selection to the set based on a collection of identity properties
 *
 */
 public void AddFeatureIds(MgLayerBase layer, String className, MgPropertyCollection identityProperties) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_AddFeatureIds(swigCPtr, MgLayerBase.getCPtr(layer), className, MgPropertyCollection.getCPtr(identityProperties));
  }

  
/**
 * Add a single selection to the set where the identity property is a 16-bit integer.
 *
 */
 public void AddFeatureIdInt16(MgLayerBase layer, String className, short identifier) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_AddFeatureIdInt16(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a 32-bit integer.
 *
 */
 public void AddFeatureIdInt32(MgLayerBase layer, String className, int identifier) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_AddFeatureIdInt32(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a 64-bit integer.
 *
 */
 public void AddFeatureIdInt64(MgLayerBase layer, String className, long identifier) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_AddFeatureIdInt64(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a string.
 *
 */
 public void AddFeatureIdString(MgLayerBase layer, String className, String identifier) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_AddFeatureIdString(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Add a single selection to the set where the identity property is a double.
 *
 */
 public void AddFeatureIdDouble(MgLayerBase layer, String className, double identifier) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_AddFeatureIdDouble(swigCPtr, MgLayerBase.getCPtr(layer), className, identifier);
  }

  
/**
 * Returns list of selected layers
 *
 */
 public MgReadOnlyLayerCollection GetLayers() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSelectionBase_GetLayers(swigCPtr);
    return (cPtr == 0) ? null : (MgReadOnlyLayerCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns list of selected classes for a layer
 *
 */
 public MgStringCollection GetClasses(String layer) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSelectionBase_GetClasses(swigCPtr, layer);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the class name for the layer
 *
 */
 public String GetClass(String layer) throws MgException  {
  { return MapGuideJavaApiJNI.MgSelectionBase_GetClass(swigCPtr, layer); }
}

  
/**
 * Does a particular layer and class have selections.
 *
 */
 public boolean Contains(MgLayerBase layer, String className) throws MgException  {
    return MapGuideJavaApiJNI.MgSelectionBase_Contains(swigCPtr, MgLayerBase.getCPtr(layer), className);
  }

  
/**
 * Generates an Fdo filter text for the selections of the
 * specified layer and class
 *
 */
 public String GenerateFilter(MgLayerBase layer, String className) throws MgException  {
  { return MapGuideJavaApiJNI.MgSelectionBase_GenerateFilter(swigCPtr, MgLayerBase.getCPtr(layer), className); }
}

  
/**
 * Generates a collection of FDO filter strings for the selections
 * of the specified layer and class
 *
 * @return  Returns the collection of FDO filter strings
 */
 public MgStringCollection GenerateFilters(MgLayerBase layer, String className, int selectionSize) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSelectionBase_GenerateFilters(swigCPtr, MgLayerBase.getCPtr(layer), className, selectionSize);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the extents of the selection set.
 *
 * @param  featureService ({@link MgFeatureService})  {@link MgFeatureService} that can be used to retrieve the extents  for each feature class definition
 * @return  Returns the {@link MgEnvelope} object with extent of selection
 */
 public MgEnvelope GetExtents(MgFeatureService featureService) throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgSelectionBase_GetExtents(swigCPtr, MgFeatureService.getCPtr(featureService));
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Adds the given feature (represented by its base64 encoded id)
 * to the selection set
 *
 * @param  layer (CREFSTRING)  Name of layer
 * @param  className (CREFSTRING)  Name of feature class
 * @param  id (CREFSTRING)  Base 64 string encoded ID of the feature
 */
 public void Add(String layer, String className, String id) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_Add(swigCPtr, layer, className, id);
  }

  
/**
 * Loads the map object from a session repository.
 *
 * @param  resourceService ({@link MgResourceService})  An {@link MgResourceService} that can be used to retrieve  the map.
 * @param  mapName (String/string)  A string that specifies the name of the map. This
 * @return  Returns nothing.
 */
 public void Open(MgResourceService resourceService, String mapName) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_Open(swigCPtr, MgResourceService.getCPtr(resourceService), mapName);
  }

  
/**
 * Save the map object to a session repository.
 *
 * @param  resourceService ({@link MgResourceService})  An {@link MgResourceService} that can be used to retrieve  the map.
 * @param  mapName (String/string)  A string that specifies the name of the map. This
 * @return  Returns nothing.
 */
 public void Save(MgResourceService resourceService, String mapName) throws MgException  {
    MapGuideJavaApiJNI.MgSelectionBase_Save(swigCPtr, MgResourceService.getCPtr(resourceService), mapName);
  }

  
/**
 * Builds a resource name based on the map name amd the session id
 *
 * @param  sessionId (String/string)  A string that specifies the session id
 * @param  mapName (String/string)  A string that specifies the name of the map. This
 * @return  Resource name.
 */
 public String GetResourceName(String sessionId, String mapName) throws MgException  {
  { return MapGuideJavaApiJNI.MgSelectionBase_GetResourceName(swigCPtr, sessionId, mapName); }
}

}
