/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class represents a collection of strings.  The collection maintains its own copy of strings.
 *
 */
 public class MgStringCollection extends MgCollection {
  private long swigCPtr;

  public MgStringCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgStringCollectionToMgCollection(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgStringCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgStringCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs a StringCollection.  The collection is initially empty.
 *
 */
 public MgStringCollection() throws MgException {
    this(MapGuideJavaApiJNI.new_MgStringCollection(), true);
  }

  
/**
 * Gets the number of items in the collection.
 *
 * @return  Returns the number of items in the collection.
 */
 public int GetCount() throws MgException  {
    return MapGuideJavaApiJNI.MgStringCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the item in the collection at the specified index.
 *
 * @param  index (int)  Input index
 * @return  Returns the item in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException if index is out of range.
 */
 public String GetItem(int index) throws MgException  {
  { return MapGuideJavaApiJNI.MgStringCollection_GetItem(swigCPtr, index); }
}

  
/**
 * Sets the item in the collection at the specified index position to the specified value.
 *
 * @param  index (int)  Input index
 * @param  value (String/string)  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public void SetItem(int index, String value) throws MgException  {
    MapGuideJavaApiJNI.MgStringCollection_SetItem(swigCPtr, index, value);
  }

  
/**
 * Adds the specified item to the end of the collection.
 *
 * @param  value (String/string)  Input value
 * @return  Returns nothing.
 */
 public void Add(String value) throws MgException  {
    MapGuideJavaApiJNI.MgStringCollection_Add(swigCPtr, value);
  }

  
/**
 * Inserts the specified item at the specified index position within the collection.
 * Items following the insertion point are moved down to accommodate the new item.
 *
 * @param  index (int)  Input index
 * @param  value (String/string)  Input value
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public void Insert(int index, String value) throws MgException  {
    MapGuideJavaApiJNI.MgStringCollection_Insert(swigCPtr, index, value);
  }

  
/**
 * Removes all items from the collection.
 *
 * @return  Returns nothing.
 */
 public void Clear() throws MgException  {
    MapGuideJavaApiJNI.MgStringCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  value (String/string)  Input value
 * @return  Returns true if removal was successful.
 */
 public boolean Remove(String value) throws MgException  {
    return MapGuideJavaApiJNI.MgStringCollection_Remove(swigCPtr, value);
  }

  
/**
 * Removes the specified item from the collection.
 *
 * @param  index (int)  Input index
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the index is out of range.
 */
 public void RemoveAt(int index) throws MgException  {
    MapGuideJavaApiJNI.MgStringCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified item, false otherwise.
 *
 * @param  value (String/string)  Input value
 * @return  Returns true if the collection contains the specified item, false otherwise.
 */
 public boolean Contains(String value) throws MgException  {
    return MapGuideJavaApiJNI.MgStringCollection_Contains(swigCPtr, value);
  }

  
/**
 * Returns the index of the specified item in the collection or -1 if the item does not exist.
 *
 * @param  value (String/string)  Input value
 * @return  Returns the index of the specified item in the collection or -1 if the item does not exist.
 */
 public int IndexOf(String value) throws MgException  {
    return MapGuideJavaApiJNI.MgStringCollection_IndexOf(swigCPtr, value);
  }

  
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * Creates an XML document representing the collection.
 * The order of the properties in the XML is the same as the order of properties in the collection.
 * It starts with item zero to length of collection.
 * TODO: Add a snippet of XML here?
 *
 * @return  A pointer to an {@link MgByteReader} object.
 */
 public MgByteReader ToXml() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgStringCollection_ToXml(swigCPtr);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

}
