/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgTransaction} represents a transaction to be performed in a DataStore.
 * If the transaction is time out, commit or rollback a transaction will
 * result in one exception {@link MgFeatureServiceException} thrown.
 *
 * @since  2.2 */
 public class MgTransaction extends MgSerializable {
  private long swigCPtr;

  public MgTransaction(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiJNI.SWIGMgTransactionToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgTransaction() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiJNI.delete_MgTransaction(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgTransaction obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Commit the transaction.
 *
 */
 public void Commit() throws MgException  {
    MapGuideJavaApiJNI.MgTransaction_Commit(swigCPtr);
  }

  
/**
 * Rollback the transaction.
 *
 */
 public void Rollback() throws MgException  {
    MapGuideJavaApiJNI.MgTransaction_Rollback__SWIG_0(swigCPtr);
  }

  
/**
 * Get the identifier of feature source associated with the transaction.
 *
 * @return  Returns the identifier of feature source associated with the transaction.
 */
 public MgResourceIdentifier GetFeatureSource() throws MgException  {
    long cPtr = MapGuideJavaApiJNI.MgTransaction_GetFeatureSource(swigCPtr);
    return (cPtr == 0) ? null : (MgResourceIdentifier)ObjectFactory.createObject(MapGuideJavaApiJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 *  Create a save point in this transaction.
 *
 * @param  suggestName  Suggested save point name.
 * @return  The actual name used
 * @since  2.4 */
 public String AddSavePoint(String suggestName) throws MgException  {
  { return MapGuideJavaApiJNI.MgTransaction_AddSavePoint(swigCPtr, suggestName); }
}

  
/**
 *  Release a specific save point.
 *
 * @param  savePointName  Save point name.
 * @return  Returns nothing
 * @since  2.4 */
 public void ReleaseSavePoint(String savePointName) throws MgException  {
    MapGuideJavaApiJNI.MgTransaction_ReleaseSavePoint(swigCPtr, savePointName);
  }

  
/**
 *  Rollback the transaction to a specified save point.
 *
 * @param  savePointName  Save point name.
 * @return  Returns nothing
 * @since  2.4 */
 public void Rollback(String savePointName) throws MgException  {
    MapGuideJavaApiJNI.MgTransaction_Rollback__SWIG_1(swigCPtr, savePointName);
  }

}
