/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * The {@link MgAgfReaderWriter} class is used to translate an
 * {@link MgGeometry} object into into an {@link MgByteReader} object and to do
 * the reverse translation.
 *
 */
 public class MgAgfReaderWriter extends MgGuardDisposable {
  private long swigCPtr;

  public MgAgfReaderWriter(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgAgfReaderWriterToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgAgfReaderWriter(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgAgfReaderWriter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Creates an {@link MgAgfReaderWriter} object
 *
 */
 public MgAgfReaderWriter() {
    this(MapGuideJavaApiExJNI.new_MgAgfReaderWriter(), true);
  }

  
/**
 * Translates an {@link MgByteReader} object into an {@link MgGeometry} object.
 * The contents of the {@link MgByteReader} is in Autodesk Geometry
 * Format (AGF).
 *
 * @param  agf ({@link MgByteReader})  An {@link MgByteReader} that supplies the AGF byte  stream.
 * @return  An instance of {@link MgGeometry} that corresponds to the specified
 *  AGF.
 */
 public MgGeometry read(MgByteReader agf) {
    long cPtr = MapGuideJavaApiExJNI.MgAgfReaderWriter_Read__SWIG_0(swigCPtr, MgByteReader.getCPtr(agf));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Reads a geometry object from a stream of bytes in AGF format applying
 * the specified transform during the read.
 *
 * @param  agf ({@link MgByteReader})  An {@link MgByteReader} that supplies the AGF byte stream.
 * @param  transform ({@link MgTransform})  An {@link MgTransform} that is used to transform each coordinate read from the  AGF representation.
 * @return  An instance of {@link MgGeometry} that corresponds to the specified AGF with
 *  the specified transform applied.
 */
 public MgGeometry read(MgByteReader agf, MgTransform transform) {
    long cPtr = MapGuideJavaApiExJNI.MgAgfReaderWriter_Read__SWIG_1(swigCPtr, MgByteReader.getCPtr(agf), MgTransform.getCPtr(transform));
    return (cPtr == 0) ? null : (MgGeometry)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Translates an {@link MgGeometry} object into a stream of bytes in AGF
 * (Autodesk Geometry Format).
 *
 * @param  geometry ({@link MgGeometry})  An {@link MgGeometry} object to write to AGF.
 * @return  An {@link MgByteReader} which contains the AGF representation of the
 *  {@link MgGeometry} object.
 */
 public MgByteReader write(MgGeometry geometry) {
    long cPtr = MapGuideJavaApiExJNI.MgAgfReaderWriter_Write__SWIG_0(swigCPtr, MgGeometry.getCPtr(geometry));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Writes a geometry object to a stream of bytes in AGF format applying
 * the specified transform during the write.
 *
 * @param  geometry ({@link MgGeometry})  An {@link MgGeometry} object to write to AGF.
 * @param  transform ({@link MgTransform})  An {@link MgTransform} that is used to transform each coordinate written to the  AGF representation.
 * @return  An {@link MgByteReader} that contains the transformed AGF representation.
 */
 public MgByteReader write(MgGeometry geometry, MgTransform transform) {
    long cPtr = MapGuideJavaApiExJNI.MgAgfReaderWriter_Write__SWIG_1(swigCPtr, MgGeometry.getCPtr(geometry), MgTransform.getCPtr(transform));
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
