/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Reads data from a byte source. Once read, the data in the
 * reader cannot be reread.
 *
 */
 public class MgByteReader extends MgSerializable {
  private long swigCPtr;

  public MgByteReader(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgByteReaderToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgByteReader() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgByteReader(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgByteReader obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Creates a byte reader from a file
 *
 * @param  fileName (string/String/string)  Name of file on disk.
 * @param  mimeType (string/String/string)  Mime type for content
 * @param  removeFile (bool)  Remove file when byte reader is deleted
 * @return  Returns nothing
 */
 public MgByteReader(String fileName, String mimeType, boolean removeFile) {
    this(MapGuideJavaApiExJNI.new_MgByteReader__SWIG_0(fileName, mimeType, removeFile), true);
  }

  
/**
 * Creates a byte reader from a string
 *
 * @param  contents (string/String/string)  String contents for byte reader.
 * @param  mimeType (string/String/string)  Mime type for content.
 * @return  Returns nothing
 */
 public MgByteReader(String contents, String mimeType) {
    this(MapGuideJavaApiExJNI.new_MgByteReader__SWIG_1(contents, mimeType), true);
  }

  
/**
 * Creates a byte reader from an array of bytes
 *
 * @param  contents (Byte[]/byte[]/string)  Binary contents for byte reader.
 * @param  length (int/int/int)  Length of contents.
 * @param  mimeType (string/String/string)  Mime type for content.
 * @return  Returns nothing
 */
 public MgByteReader(byte[] contents, int length, String mimeType) {
    this(MapGuideJavaApiExJNI.new_MgByteReader__SWIG_2(contents, length, mimeType), true);
  }

  
/**
 * Reads a buffer
 *
 * @param  buffer (byte[]/Byte[]/string)  A buffer receiving the data.
 * @param  length (int)  Maximum number of bytes to read
 * @return  Actual number of bytes put in the buffer. 0 means end of bytes
 */
 public int read(byte[] buffer, int length) {
    return MapGuideJavaApiExJNI.MgByteReader_Read(swigCPtr, buffer, length);
  }

  
/**
 * Gets the mime type of the data in this reader.  See {@link MgMimeType}
 * for list of possible mime types.
 *
 * @return  string representing the type, for example text/xml
 */
 public String getMimeType() {
  { return MapGuideJavaApiExJNI.MgByteReader_GetMimeType(swigCPtr); }
}

  
/**
 * Returns the contents of the reader as a string.  The mime
 * type must be a text type, for example text/xml.
 *
 * @return  Text string of reader contents
 * @exception  MgInvalidArgumentException is thrown if the reader does not contain text
 */
 public String toString() {
  { return MapGuideJavaApiExJNI.MgByteReader_ToString(swigCPtr); }
}

  
/**
 * Writes the the contents of the reader to a file.
 *
 * @return  Returns nothing
 * @exception  MgFileIoException is thrown if file cannot be written
 */
 public void toFile(String fileName) {
    MapGuideJavaApiExJNI.MgByteReader_ToFile(swigCPtr, fileName);
  }

  
/**
 * Returns the remaining length of the underlying byte source.
 * This length is adjusted for previous reads.  If the returned length is zero
 * then the underlying source may be a streaming format and the length
 * is not known.
 *
 * @return  Remaining length of underlying byte source
 */
 public long getLength() {
    return MapGuideJavaApiExJNI.MgByteReader_GetLength(swigCPtr);
  }

  
/**
 * Determines if the reader is rewindable.
 *
 * @return  true if the source is rewindable, false otherwise.
 */
 public boolean isRewindable() {
    return MapGuideJavaApiExJNI.MgByteReader_IsRewindable(swigCPtr);
  }

  
/**
 * Rewinds to the start of the reader.  Depending on the source of
 * the reader, Rewind may not be supported.  Readers sourced from
 * true streams cannot be rewound.
 *
 * @return  Nothing
 * @exception  MgIoException if reader cannot be rewound
 */
 public void rewind() {
    MapGuideJavaApiExJNI.MgByteReader_Rewind(swigCPtr);
  }

}
