package org.osgeo.mapguide;


/**
 * Properties stored in an {@link MgConfiguration} object.  Note that the properties are
 * organized into Property Sections.  These sections may be used in the API to
 * set/get groups of configuration properties.
 * INTERNAL_ONLY:
 *
 */
public class MgConfigProperties
{
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DefaultConfigurationFilename  = "webconfig.ini"; 
   public static final String ServerConfigurationFilename  = "serverconfig.ini"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertiesSection  = "GeneralProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyConnectionTimeout  = "ConnectionTimeout"; 
   public static final int DefaultGeneralPropertyConnectionTimeout  = 120; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyConnectionTimerInterval  = "ConnectionTimerInterval"; 
   public static final int DefaultGeneralPropertyConnectionTimerInterval  = 60; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyLocale  = "Locale"; 
   public static final String DefaultGeneralPropertyLocale  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyDefaultMessageLocale  = "DefaultMessageLocale"; 
   public static final String DefaultGeneralPropertyDefaultMessageLocale  = "en"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyDisplayName  = "DisplayName"; 
   public static final String DefaultGeneralPropertyDisplayName  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyFdoPath  = "FdoPath"; 
   public static final String DefaultGeneralPropertyFdoPath  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyMentorDictionaryPath  = "MentorDictionaryPath"; 
   public static final String DefaultGeneralPropertyMentorDictionaryPath  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyMentorUserDictionaryPath  = "MentorUserDictionaryPath"; 
   public static final String DefaultGeneralPropertyMentorUserDictionaryPath  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyLicenseServerPath  = "LicenseServerPath"; 
   public static final String DefaultGeneralPropertyLicenseServerPath  = ""; ///  ; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyLinuxMemDebug  = "LinuxMemDebug"; 
   public static final boolean DefaultGeneralPropertyLinuxMemDebug  = false; ///  ; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyLinuxFontDirectories  = "LinuxFontDirectories"; 
   public static final String DefaultGeneralPropertyLinuxFontDirectories  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyLogsDelimiter  = "LogsDelimiter"; 
   public static final String DefaultGeneralPropertyLogsDelimiter  = "\t"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyLogsDetail  = "LogsDetail"; 
   public static final String DefaultGeneralPropertyLogsDetail  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyLogsPath  = "LogsPath"; 
   public static final String DefaultGeneralPropertyLogsPath  = "Logs/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyMachineIp  = "MachineIp"; 
   public static final String DefaultGeneralPropertyMachineIp  = "127.0.0.1"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyMaxLogFileSize  = "MaxLogFileSize"; 
   public static final int DefaultGeneralPropertyMaxLogFileSize  = 64; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyMaxLogFileSizeEnabled  = "MaxLogFileSizeEnabled"; 
   public static final boolean DefaultGeneralPropertyMaxLogFileSizeEnabled  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyResourcesPath  = "ResourcesPath"; 
   public static final String DefaultGeneralPropertyResourcesPath  = "Resources/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertySerialNumber  = "SerialNumber"; 
   public static final String DefaultGeneralPropertySerialNumber  = ""; ///  ; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyServiceRegistrationTimerInterval  = "ServiceRegistrationTimerInterval"; 
   public static final int DefaultGeneralPropertyServiceRegistrationTimerInterval  = 60; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyTcpIpMtu  = "TcpIpMtu"; 
   public static final int DefaultGeneralPropertyTcpIpMtu  = 1460; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyTempPath  = "TempPath"; 
   public static final String DefaultGeneralPropertyTempPath  = "Temp/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyWfsDocumentPath  = "WfsDocumentPath"; 
   public static final String DefaultGeneralPropertyWfsDocumentPath  = "Wfs/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyWmsDocumentPath  = "WmsDocumentPath"; 
   public static final String DefaultGeneralPropertyWmsDocumentPath  = "Wms/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyRenderer  = "Renderer"; 
   public static final String DefaultGeneralPropertyRenderer  = "GD"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String GeneralPropertyPreCacheMaps  = "PreCacheMaps"; 
   public static final String DefaultGeneralPropertyPreCacheMaps  = ""; 
      
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdministrativeConnectionPropertiesSection  = "AdministrativeConnectionProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdministrativeConnectionPropertyEmail  = "Email"; 
   public static final String DefaultAdministrativeConnectionPropertyEmail  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdministrativeConnectionPropertyMaxConnections  = "MaxConnections"; 
   public static final int DefaultAdministrativeConnectionPropertyMaxConnections  = 20; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdministrativeConnectionPropertyPort  = "Port"; 
   public static final int DefaultAdministrativeConnectionPropertyPort  = 5555; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdministrativeConnectionPropertyQueueSize  = "QueueSize"; 
   public static final int DefaultAdministrativeConnectionPropertyQueueSize  = 10; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdministrativeConnectionPropertyThreadPoolSize  = "ThreadPoolSize"; 
   public static final int DefaultAdministrativeConnectionPropertyThreadPoolSize  = 5; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ClientConnectionPropertiesSection  = "ClientConnectionProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ClientConnectionPropertyMaxConnections  = "MaxConnections"; 
   public static final int DefaultClientConnectionPropertyMaxConnections  = 100; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ClientConnectionPropertyPort  = "Port"; 
   public static final int DefaultClientConnectionPropertyPort  = 4444; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ClientConnectionPropertyQueueSize  = "QueueSize"; 
   public static final int DefaultClientConnectionPropertyQueueSize  = 10; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ClientConnectionPropertyThreadPoolSize  = "ThreadPoolSize"; 
   public static final int DefaultClientConnectionPropertyThreadPoolSize  = 10; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteConnectionPropertiesSection  = "SiteConnectionProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteConnectionPropertyIpAddress  = "IpAddress"; 
   public static final String DefaultSiteConnectionPropertyIpAddress  = "127.0.0.1"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteConnectionPropertyMaxConnections  = "MaxConnections"; 
   public static final int DefaultSiteConnectionPropertyMaxConnections  = 20; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteConnectionPropertyPort  = "Port"; 
   public static final int DefaultSiteConnectionPropertyPort  = 3333; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteConnectionPropertyQueueSize  = "QueueSize"; 
   public static final int DefaultSiteConnectionPropertyQueueSize  = 10; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteConnectionPropertyThreadPoolSize  = "ThreadPoolSize"; 
   public static final int DefaultSiteConnectionPropertyThreadPoolSize  = 5; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertiesSection  = "HostProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyDrawingService  = "DrawingService"; 
   public static final boolean DefaultHostPropertyDrawingService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyFeatureService  = "FeatureService"; 
   public static final boolean DefaultHostPropertyFeatureService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyKmlService  = "KmlService"; 
   public static final boolean DefaultHostPropertyKmlService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyMappingService  = "MappingService"; 
   public static final boolean DefaultHostPropertyMappingService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyRenderingService  = "RenderingService"; 
   public static final boolean DefaultHostPropertyRenderingService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyResourceService  = "ResourceService"; 
   public static final boolean DefaultHostPropertyResourceService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyProfilingService  = "ProfilingService"; 
   public static final boolean DefaultHostPropertyProfilingService  = false; 
      
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertySiteService  = "SiteService"; 
   public static final boolean DefaultHostPropertySiteService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String HostPropertyTileService  = "TileService"; 
   public static final boolean DefaultHostPropertyTileService  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DrawingServicePropertiesSection  = "DrawingServiceProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertiesSection  = "FeatureServiceProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyCacheSize  = "CacheSize"; 
   public static final int DefaultFeatureServicePropertyCacheSize  = 100; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyCacheTimeLimit  = "CacheTimeLimit"; 
   public static final int DefaultFeatureServicePropertyCacheTimeLimit  = 86400; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyCacheTimerInterval  = "CacheTimerInterval"; 
   public static final int DefaultFeatureServicePropertyCacheTimerInterval  = 3600; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataCacheSize  = "DataCacheSize"; 
   public static final int DefaultFeatureServicePropertyDataCacheSize  = 100; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataConnectionPoolEnabled  = "DataConnectionPoolEnabled"; 
   public static final boolean DefaultFeatureServicePropertyDataConnectionPoolEnabled  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataConnectionPoolExcludedProviders  = "DataConnectionPoolExcludedProviders"; 
   public static final String DefaultFeatureServicePropertyDataConnectionPoolExcludedProviders  = "OSGeo.SDF,OSGeo.SHP"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataConnectionPoolSize  = "DataConnectionPoolSize"; 
   public static final int DefaultFeatureServicePropertyDataConnectionPoolSize  = 50; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataConnectionPoolSizeCustom  = "DataConnectionPoolSizeCustom"; 
   public static final String DefaultFeatureServicePropertyDataConnectionPoolSizeCustom  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataConnectionTimeout  = "DataConnectionTimeout"; 
   public static final int DefaultFeatureServicePropertyDataConnectionTimeout  = 600; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataConnectionTimerInterval  = "DataConnectionTimerInterval"; 
   public static final int DefaultFeatureServicePropertyDataConnectionTimerInterval  = 60; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyJoinQueryBatchSize  = "JoinQueryBatchSize"; 
   public static final int DefaultFeatureServicePropertyJoinQueryBatchSize  = 100; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataConnectionUseLimit  = "DataConnectionUseLimit"; 
   public static final String DefaultFeatureServicePropertyDataConnectionUseLimit  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataTransactionTimeout  = "DataTransactionTimeout"; 
   public static final int DefaultFeatureServicePropertyDataTransactionTimeout  = 360; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyDataTransactionTimerInterval  = "DataTransactionTimerInterval"; 
   public static final int DefaultFeatureServicePropertyDataTransactionTimerInterval  = 60; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyFDOConnectionTimeoutCustom  = "FDOConnectionTimeoutCustom"; 
   public static final String DefaultFeatureServicePropertyFDOConnectionTimeoutCustom  = "OSGeo.WMS:120"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FeatureServicePropertyUseFdoJoinOptimization  = "UseFdoJoinOptimization"; 
   public static final boolean DefaultFeatureServicePropertyUseFdoJoinOptimization  = true; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String MappingServicePropertiesSection  = "MappingServiceProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String MappingServicePropertyLegendFont  = "LegendFont"; 
   public static final String DefaultMappingServicePropertyLegendFont  = "Arial"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertiesSection  = "RenderingServiceProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyTileExtentOffset  = "TileExtentOffset"; 
   public static final double DefaultRenderingServicePropertyTileExtentOffset  = 0.35; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyRasterGridSize  = "RasterGridSize"; 
   public static final int DefaultRenderingServicePropertyRasterGridSize  = 100; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyMinRasterGridSize  = "MinRasterGridSize"; 
   public static final int DefaultRenderingServicePropertyMinRasterGridSize  = 10; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyRasterGridSizeOverrideRatio  = "RasterGridSizeOverrideRatio"; 
   public static final double DefaultRenderingServicePropertyRasterGridSizeOverrideRatio  = 0.25; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyRasterGridSizeForPlot  = "RasterGridSizeForPlot"; 
   public static final int DefaultRenderingServicePropertyRasterGridSizeForPlot  = 50; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyMinRasterGridSizeForPlot  = "MinRasterGridSizeForPlot"; 
   public static final int DefaultRenderingServicePropertyMinRasterGridSizeForPlot  = 5; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyRasterGridSizeOverrideRatioForPlot  = "RasterGridSizeOverrideRatioForPlot"; 
   public static final double DefaultRenderingServicePropertyRasterGridSizeOverrideRatioForPlot  = 0.10; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyRenderSelectionBatchSize  = "RenderSelectionBatchSize"; 
   public static final int DefaultRenderingServicePropertyRenderSelectionBatchSize  = 10000; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyClampPoints  = "ClampPoints"; 
   public static final boolean DefaultRenderingServicePropertyClampPoints  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyGeneralizeData  = "GeneralizeData"; 
   public static final boolean DefaultRenderingServicePropertyGeneralizeData  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyMaxRasterImageWidth  = "MaxRasterImageWidth"; 
   public static final int DefaultRenderingServicePropertyMaxRasterImageWidth  = 2048; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String RenderingServicePropertyMaxRasterImageHeight  = "MaxRasterImageHeight"; 
   public static final int DefaultRenderingServicePropertyMaxRasterImageHeight  = 2048; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String FontAliasMappingSection  = "FontAliases"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String UnmanagedDataMappingsSection  = "UnmanagedDataMappings"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertiesSection  = "ResourceServiceProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyLibraryRepositoryPath  = "LibraryRepositoryPath"; 
   public static final String DefaultResourceServicePropertyLibraryRepositoryPath  = "Repositories/Library/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyLibraryResourceDataFilePath  = "LibraryResourceDataFilePath"; 
   public static final String DefaultResourceServicePropertyLibraryResourceDataFilePath  = "Repositories/Library/DataFiles/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyPackagesPath  = "PackagesPath"; 
   public static final String DefaultResourceServicePropertyPackagesPath  = "Packages/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyRepositoryCheckpointsTimerInterval  = "RepositoryCheckpointsTimerInterval"; 
   public static final int DefaultResourceServicePropertyRepositoryCheckpointsTimerInterval  = 600; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyResourceChangeTimerInterval  = "ResourceChangeTimerInterval"; 
   public static final int DefaultResourceServicePropertyResourceChangeTimerInterval  = 5; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyResourceDataFileTrashFolderName  = "ResourceDataFileTrashFolderName"; 
   public static final String DefaultResourceServicePropertyResourceDataFileTrashFolderName  = "Trash"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyResourcePermissionCacheSize  = "ResourcePermissionCacheSize"; 
   public static final int DefaultResourceServicePropertyResourcePermissionCacheSize  = 1000; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertyResourceSchemaFilePath  = "ResourceSchemaFilePath"; 
   public static final String DefaultResourceServicePropertyResourceSchemaFilePath  = "Schema/"; 
      
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertySessionRepositoryPath  = "SessionRepositoryPath"; 
   public static final String DefaultResourceServicePropertySessionRepositoryPath  = "Repositories/Session/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertySessionResourceDataFilePath  = "SessionResourceDataFilePath"; 
   public static final String DefaultResourceServicePropertySessionResourceDataFilePath  = "Repositories/Session/DataFiles/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ResourceServicePropertySiteRepositoryPath  = "SiteRepositoryPath"; 
   public static final String DefaultResourceServicePropertySiteRepositoryPath  = "Repositories/Site/"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteServicePropertiesSection  = "SiteServiceProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteServicePropertySessionTimeout  = "SessionTimeout"; 
   public static final int DefaultSiteServicePropertySessionTimeout  = 1200; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SiteServicePropertySessionTimerInterval  = "SessionTimerInterval"; 
   public static final int DefaultSiteServicePropertySessionTimerInterval  = 400; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TileServicePropertiesSection  = "TileServiceProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TileServicePropertyRenderOnly  = "RenderOnly"; 
   public static final boolean DefaultTileServicePropertyRenderOnly  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TileServicePropertyTileCachePath  = "TileCachePath"; 
   public static final String DefaultTileServicePropertyTileCachePath  = "Repositories/TileCache/"; 
   public static final String TileServicePropertyTileColumnsPerFolder  = "TileColumnsPerFolder"; 
   public static final int DefaultTileServicePropertyTileColumnsPerFolder  = 30; 
   public static final String TileServicePropertyTileRowsPerFolder  = "TileRowsPerFolder"; 
   public static final int DefaultTileServicePropertyTileRowsPerFolder  = 30; 
   public static final String TileServicePropertyTileSizeX  = "DefaultTileSizeX"; ///  ; 
   public static final int DefaultTileServicePropertyTileSizeX  = 300; ///  ; 
   public static final String TileServicePropertyTileSizeY  = "DefaultTileSizeY"; ///  ; 
   public static final int DefaultTileServicePropertyTileSizeY  = 300; ///  ; 
   public static final String TileServicePropertyImageFormat  = "ImageFormat"; 
   public static final String DefaultTileServicePropertyImageFormat  = "PNG"; 
      
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 * The remaining properties are log properties.  For each type of log, there is a "Parameters" property.
 * These parameters may be used to customize a log and are listed below.  Note that not
 * all of the parameters may be used with a particular log.  See the list of valid
 * parameters for each log type below. The Parameters string is a list of
 * comma-delimited parameter names.  Each log type has a different set of possible
 * parameters.
 * <table border="1" class="RuledTable">
 *    <tr>
 *        <th>Parameter</th>
 *        <th>Description</th>
 *    </tr>
 *    <tr>
 *        <td>ALL</td>
 *        <td>Activates all valid parameters for log.</td>
 *    </tr>
 *    <tr>
 *        <td>AKEY</td>
 *        <td>Access Key used by the map layer.</td>
 *    </tr>
 *    <tr>
 *        <td>CLIENT</td>
 *        <td>The client and version that generated the request.</td>
 *    </tr>
 *    <tr>
 *        <td>CLIENTID</td>
 *        <td>A unique identifier for the client computer that generated the request.</td>
 *    </tr>
 *    <tr>
 *        <td>DATASRC</td>
 *        <td>Data source name.</td>
 *    </tr>
 *    <tr>
 *        <td>ITEM</td>
 *        <td>The type of request</td>
 *    </tr>
 *    <tr>
 *        <td>LYRTYPE</td>
 *        <td>Layer Type.</td>
 *    </tr>
 *    <tr>
 *        <td>MLNAME</td>
 *        <td>Map layer name.</td>
 *    </tr>
 *    <tr>
 *        <td>MWIN</td>
 *        <td>A composite item that generates entries for MWFURL, XMIN, YMIN, XMAX, and YMAX.</td>
 *    </tr>
 *    <tr>
 *        <td>MWFURL</td>
 *        <td>The URL of the map that generated the request.</td>
 *    </tr>
 *    <tr>
 *        <td>NLAYER</td>
 *        <td>The number of layers in the request.</td>
 *    </tr>
 *    <tr>
 *        <td>NSCALOG</td>
 *        <td>A composite item that generates several entries that conform to the NCSA/CERN log file standard.</td>
 *    </tr>
 *    <tr>
 *        <td>PASSWORD</td>
 *        <td>Password used by the map layer.</td>
 *    </tr>
 *    <tr>
 *        <td>PREC</td>
 *        <td>A number that indicates map data precision.</td>
 *    </tr>
 *    <tr>
 *        <td>REQID</td>
 *        <td>The request identification number.</td>
 *    </tr>
 *    <tr>
 *        <td>REQTIME</td>
 *        <td>Time taken to process the request in seconds.</td>
 *    </tr>
 *    <tr>
 *        <td>SCALE</td>
 *        <td>The current scale.</td>
 *    </tr>
 *    <tr>
 *        <td>TABLE</td>
 *        <td>Feature table name used by the map layer.</td>
 *    </tr>
 *    <tr>
 *        <td>TRACKID</td>
 *        <td>Customer tracking ID.</td>
 *    </tr>
 *    <tr>
 *        <td>USER</td>
 *        <td>User ID used by this map layer.</td>
 *    </tr>
 *    <tr>
 *        <td>XMAX</td>
 *        <td>The maximum X value of the area covered by the request.</td>
 *    </tr>
 *    <tr>
 *        <td>YMAX</td>
 *        <td>The maximum Y value of the area covered by the request.</td>
 *    </tr>
 *    <tr>
 *        <td>XMIN</td>
 *        <td>The minimum X value of the area covered by the request.</td>
 *    </tr>
 *    <tr>
 *        <td>YMIN</td>
 *        <td>The minimum Y value of the area covered by the request.</td>
 *    </tr>
 * </table>
 *
 */

   public static final String AccessLogPropertiesSection  = "AccessLogProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AccessLogPropertyEnabled  = "Enabled"; 
   public static final boolean DefaultAccessLogPropertyEnabled  = true; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AccessLogPropertyFilename  = "Filename"; 
   public static final String DefaultAccessLogPropertyFilename  = "Access.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AccessLogPropertyParameters  = "Parameters"; 
   public static final String DefaultAccessLogPropertyParameters  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdminLogPropertiesSection  = "AdminLogProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdminLogPropertyEnabled  = "Enabled"; 
   public static final boolean DefaultAdminLogPropertyEnabled  = true; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdminLogPropertyFilename  = "Filename"; 
   public static final String DefaultAdminLogPropertyFilename  = "Admin.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AdminLogPropertyParameters  = "Parameters"; 
   public static final String DefaultAdminLogPropertyParameters  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AuthenticationLogPropertiesSection  = "AuthenticationLogProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AuthenticationLogPropertyEnabled  = "Enabled"; 
   public static final boolean DefaultAuthenticationLogPropertyEnabled  = true; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AuthenticationLogPropertyFilename  = "Filename"; 
   public static final String DefaultAuthenticationLogPropertyFilename  = "Authentication.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AuthenticationLogPropertyParameters  = "Parameters"; 
   public static final String DefaultAuthenticationLogPropertyParameters  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ErrorLogPropertiesSection  = "ErrorLogProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ErrorLogPropertyEnabled  = "Enabled"; 
   public static final boolean DefaultErrorLogPropertyEnabled  = true; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ErrorLogPropertyFilename  = "Filename"; 
   public static final String DefaultErrorLogPropertyFilename  = "Error.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ErrorLogPropertyParameters  = "Parameters"; 
   public static final String DefaultErrorLogPropertyParameters  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String PerformanceLogPropertiesSection  = "PerformanceLogProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String PerformanceLogPropertyEnabled  = "Enabled"; 
   public static final boolean DefaultPerformanceLogPropertyEnabled  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String PerformanceLogPropertyFilename  = "Filename"; 
   public static final String DefaultPerformanceLogPropertyFilename  = "Performance.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String PerformanceLogPropertyParameters  = "Parameters"; 
   public static final String DefaultPerformanceLogPropertyParameters  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String PerformanceLogPropertyInterval  = "Interval"; 
   public static final int DefaultPerformanceLogPropertyInterval  = 300; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionLogPropertiesSection  = "SessionLogProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionLogPropertyEnabled  = "Enabled"; 
   public static final boolean DefaultSessionLogPropertyEnabled  = true; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionLogPropertyFilename  = "Filename"; 
   public static final String DefaultSessionLogPropertyFilename  = "Session.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionLogPropertyParameters  = "Parameters"; 
   public static final String DefaultSessionLogPropertyParameters  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TraceLogPropertiesSection  = "TraceLogProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TraceLogPropertyEnabled  = "Enabled"; 
   public static final boolean DefaultTraceLogPropertyEnabled  = true; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TraceLogPropertyFilename  = "Filename"; 
   public static final String DefaultTraceLogPropertyFilename  = "Trace.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TraceLogPropertyParameters  = "Parameters"; 
   public static final String DefaultTraceLogPropertyParameters  = ""; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DBEnvironmentPropertiesSection  = "DBEnvironmentProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String LibraryCacheSizeParameters  = "LibraryCacheSize"; 
   public static final int DefaultLibraryCacheSizeParameters  = 32; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionCacheSizeParamters  = "SessionCacheSize"; 
   public static final int DefaultSessionCacheSizeParamters  = 2; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DBPageSizeParameters  = "DBPageSize"; 
   public static final int DefaultDBPageSizeParameters  = 32; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DBXMLPageSizeParameters  = "DBXMLPageSize"; 
   public static final int DefaultDBXMLPageSizeParameters  = 32; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String LibraryLogBufferSizeParameters  = "LibraryLogBufferSize"; 
   public static final int DefaultLibraryLogBufferSizeParameters  = 12; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionLogBufferSizeParameters  = "SessionLogBufferSize"; 
   public static final int DefaultSessionLogBufferSizeParameters  = 1; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DBMaxTransactionsParamters  = "DBMaxTransactions"; 
   public static final int DefaultDBMaxTransactionsParamters  = 1000; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionDBPageSizeParameters  = "SessionDBPageSize"; 
   public static final int DefaultSessionDBPageSizeParameters  = 2; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String SessionDBXMLPageSizeParameters  = "SessionDBXMLPageSize"; 
   public static final double DefaultSessionDBXMLPageSizeParameters  = 0.5; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DBTimeoutParameters  = "DBTimeout"; 
   public static final double DefaultDBTimeoutParameters  = 0.2; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String DBMaxLockersParameters  = "DBMaxLockers"; 
   public static final int DefaultDBMaxLockersParameters  = 1000; 
      
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentPropertiesSection  = "AgentProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentDebugPause  = "DebugPause"; 
   public static final int DefaultAgentDebugPause  = 0; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentDisableAuthoring  = "DisableAuthoring"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentDisableWfs  = "DisableWfs"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentDisableWms  = "DisableWms"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentErrorLogEnabled  = "ErrorLogEnabled"; 
   public static final boolean DefaultAgentErrorLogEnabled  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentErrorLogFilename  = "ErrorLogFilename"; 
   public static final String DefaultAgentErrorLogFilename  = "Error.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentRequestLogEnabled  = "RequestLogEnabled"; 
   public static final boolean DefaultAgentRequestLogEnabled  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentRequestLogFilename  = "RequestLogFilename"; 
   public static final String DefaultAgentRequestLogFilename  = "Request.log"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentGlobalMaxFeatureQueryLimit  = "GlobalMaxFeatureQueryLimit"; 
   public static final int DefaultAgentGlobalMaxFeatureQueryLimit  = 0; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentGlobalMaxMapFeatureQueryLimit  = "GlobalMaxMapFeatureQueryLimit"; 
   public static final int DefaultAgentGlobalMaxMapFeatureQueryLimit  = 0; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String OgcPropertiesSection  = "OgcProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String WfsPassword  = "WfsPassword"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String WmsPassword  = "WmsPassword"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String CITEWfsEnabled  = "CITEWfsEnabled"; 
   public static final boolean DefaultCITEWfsEnabled  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String CITEWmsEnabled  = "CITEWmsEnabled"; 
   public static final boolean DefaultCITEWmsEnabled  = false; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentGlobalGetWfsFeaturesLimit  = "GlobalGetWfsFeaturesLimit"; 
   public static final int DefaultAgentGlobalGetWfsFeaturesLimit  = 0; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String AgentGlobalGetWmsFeatureInfoLimit  = "GlobalGetWmsFeatureInfoLimit"; 
   public static final int DefaultAgentGlobalGetWmsFeatureInfoLimit  = 0; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String WebApplicationPropertiesSection  = "WebApplicationProperties"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String TemplateRootFolder  = "TemplateRootFolder"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String WidgetInfoFolder  = "WidgetInfoFolder"; 
   
/**
 * (NOTE: This API is not officially supported and may be subject to removal in a future release without warning. Use with caution.)
 */

   public static final String ContainerInfoFolder  = "ContainerInfoFolder"; 
   
}

