/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public class MgCoordinateSystem extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystem(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystem() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystem(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystem obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the type of the coordinate system: arbitrary, geographic, or projected.
 *
 * @return  One of the values defined in {@link MgCoordinateSystemType}.
 */
 public int getType() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetType(swigCPtr);
  }

  
/**
 * Converts the specified {@link MgCoordinate} in lon/lat units to coordinate system units
 *
 * @param  lonLat ({@link MgCoordinate})  The {@link MgCoordinate} in lon/lat units
 * @return  The converted {@link MgCoordinate} in coordinate system units
 */
 public MgCoordinate convertFromLonLat(MgCoordinate lonLat) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertFromLonLat__SWIG_0(swigCPtr, MgCoordinate.getCPtr(lonLat));
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified {@link MgCoordinate} in coordinate system units to lon/lat units
 *
 * @param  coordinate ({@link MgCoordinate})  The {@link MgCoordinate} in coordinate system units
 * @return  The converted {@link MgCoordinate} in lon/lat units
 */
 public MgCoordinate convertToLonLat(MgCoordinate coordinate) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertToLonLat__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coordinate));
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the given value in coordinate system units to meters
 *
 * @param  units (double)  The value in coordinate system units
 * @return  The converted value in meters
 */
 public double convertCoordinateSystemUnitsToMeters(double units) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertCoordinateSystemUnitsToMeters(swigCPtr, units);
  }

  
/**
 * Converts the given value in meters to coordinate system units
 *
 * @param  meters (double)  The value in meters
 * @return  The converted value in coordinate system unit
 */
 public double convertMetersToCoordinateSystemUnits(double meters) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertMetersToCoordinateSystemUnits(swigCPtr, meters);
  }

  
/**
 * Measures the euclidean distance between two coordinates in coordinate system units.
 *
 * @param  coord1 ({@link MgCoordinate})  The first coordinate
 * @param  coord2 ({@link MgCoordinate})  The second coordinate
 * @return  The euclidean distance from coord1 to coord2 in coordinate system units.
 */
 public double measureEuclideanDistance(MgCoordinate coord1, MgCoordinate coord2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_MeasureEuclideanDistance__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Measures the euclidean distance between (x1, y1) and (x2, y2) in coordinate system units.
 *
 * @param  x1  The first X coordinate
 * @param  y1  The first Y coordinate
 * @param  x2  The second X coordinate
 * @param  y2  The second Y coordinate
 * @return  The euclidean distance from (x1, y1) to (x2, y2) in coordinate system units.
 */
 public double measureEuclideanDistance(double x1, double y1, double x2, double y2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_MeasureEuclideanDistance__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Measures the great circle distance between two coordinates in coordinate system units
 *
 * @param  coord1 ({@link MgCoordinate})  The first coordinate
 * @param  coord2 ({@link MgCoordinate})  The second coordinate
 * @return  The great circle distance from coord1 to coord2 in coordinate system units
 */
 public double measureGreatCircleDistance(MgCoordinate coord1, MgCoordinate coord2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_MeasureGreatCircleDistance__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Measures the distance between two coordinates (x1, y1) and (x2, y2) in coordinate system units
 *
 * @param  x1  The first X coordinate
 * @param  y1  The first Y coordinate
 * @param  x2  The second X coordinate
 * @param  y2  The second Y coordinate
 * @return  The great circle distance from (x1, y1) to (x2, y2) in coordinate system units
 */
 public double measureGreatCircleDistance(double x1, double y1, double x2, double y2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_MeasureGreatCircleDistance__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Gets the angle with respect to North of a vector formed by two coordinates
 *
 * @param  coord1 ({@link MgCoordinate})  The first coordinate
 * @param  coord2 ({@link MgCoordinate})  The second coordinate
 * @return  The azimuth (Angle with respect to North) of the vector formed by coord1 and coord2
 */
 public double getAzimuth(MgCoordinate coord1, MgCoordinate coord2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetAzimuth__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Gets the angle with respect to North of a vector formed by two coordinate
 *
 * @param  x1  The first X coordinate
 * @param  y1  The first Y coordinate
 * @param  x2  The second X coordinate
 * @param  y2  The second Y coordinate
 * @return  The azimuth (Angle with respect to the North) of the vector formed by (x1, y1) and (x2, y2)
 */
 public double getAzimuth(double x1, double y1, double x2, double y2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetAzimuth__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Computes a coordinate a given distance along a vector that is defined by a starting coordinate and an azimuth (Angle with respect to North).
 *
 * @param  coord ({@link MgCoordinate})  An {@link MgCoordinate} object in coordinate system  units that represents the start of the  vector.
 * @param  azimuth (double)  An azimuth (Angle with respect to the North)  that defines the direction of the vector.
 * @param  distance (double)  The distance along the vector to the desired  coordinate in meters.
 * @return  An {@link MgCoordinate} that lies the given distance along the vector.
 */
 public MgCoordinate getCoordinate(MgCoordinate coord, double azimuth, double distance) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetCoordinate__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord), azimuth, distance);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Computes a coordinate a given distance along a vector that is defined by a starting (x, y) coordinate and an azimuth (Angle with respect to North).
 *
 * @param  xStart (double)  The x value in coordinate system units of the  starting coordinate.
 * @param  yStart (double)  The y value in coordinate system units of the  starting coordinate.
 * @param  azimuth (double)  An azimuth (Angle with respect to the North)  that defines the direction of the vector.
 * @param  distance (double)  The distance along the vector to the desired  coordinate in meters.
 * @return  An {@link MgCoordinate} that lies the given distance along the vector.
 */
 public MgCoordinate getCoordinate(double xStart, double yStart, double azimuth, double distance) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetCoordinate__SWIG_1(swigCPtr, xStart, yStart, azimuth, distance);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the OGC WKT string representation of the coordinate system.
 *
 * @return  The OGC WKT string.
 */
 public String toString() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_ToString(swigCPtr); }
}

  
/**
 * Gets the coordinate system units
 *
 * @return  The coordinate system units string
 */
 public String getUnits() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetUnits(swigCPtr); }
}

  
/**
 * Gets the factor used to convert coordinate system units to meters
 *
 * @return  The factor used to convert coordinate system units to meters
 */
 public double getUnitScale() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetUnitScale(swigCPtr);
  }

  
/**
 * Gets the minimum X value.
 *
 * @return  The coordinate system minimum X value
 */
 public double getMinX() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetMinX(swigCPtr);
  }

  
/**
 * Gets the minimum Y value.
 *
 * @return  The coordinate system minimum Y value
 */
 public double getMinY() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetMinY(swigCPtr);
  }

  
/**
 * Gets the maximum X value
 *
 * @return  The coordinate system maximum X value
 */
 public double getMaxX() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetMaxX(swigCPtr);
  }

  
/**
 * Gets the maximum Y value
 *
 * @return  The coordinate system maximum Y value
 */
 public double getMaxY() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetMaxY(swigCPtr);
  }

  
/**
 * Returns the CS-Map coordinate system code
 *
 * @return  The CS-Map coordinate system code
 */
 public String getCsCode() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetCsCode(swigCPtr); }
}

  
/**
 * Returns the description of this coordinate system
 *
 * @return  The description of this coordinate system
 */
 public String getDescription() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetDescription(swigCPtr); }
}

  
/**
 * Returns the projection of this coordinate system
 *
 * @return  The projection of this coordinate system
 */
 public String getProjection() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetProjection(swigCPtr); }
}

  
/**
 * Returns the projection description of this coordinate system
 *
 * @return  The projection description of this coordinate system
 */
 public String getProjectionDescription() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetProjectionDescription(swigCPtr); }
}

  
/**
 * Returns the datum of this coordinate system
 *
 * @return  The coordinate system datum string
 */
 public String getDatum() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetDatum(swigCPtr); }
}

  
/**
 * Returns the datum description of this coordinate system
 *
 * @return  The datum description string of this coordinate system
 */
 public String getDatumDescription() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetDatumDescription(swigCPtr); }
}

  
/**
 * Returns the ellipsoid of this coordinate system
 *
 * @return  The ellipsoid string of this coordinate system
 */
 public String getEllipsoid() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetEllipsoid(swigCPtr); }
}

  
/**
 * Returns the ellipsoid description of this coordinate system
 *
 * @return  The ellipsoid description string of this coordinate system
 */
 public String getEllipsoidDescription() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetEllipsoidDescription(swigCPtr); }
}

  public int getEpsgCode() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetEpsgCode(swigCPtr);
  }

  public int getSridCode() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetSridCode(swigCPtr);
  }

  public short getEpsgQuadrant() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetEpsgQuadrant(swigCPtr);
  }

  
/**
 * Gets the measure object of this coordinate system
 *
 * @return  The {@link MgCoordinateSystemMeasure} object of this coordinate system
 * @since  2.0 */
 public MgCoordinateSystemMeasure getMeasure() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetMeasure(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemMeasure)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the categories of this coordinate system
 *
 * @return  The {@link MgStringCollection} containing the cateogories for this coordinate system
 */
 public MgStringCollection getCategories() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetCategories(swigCPtr);
    return (cPtr == 0) ? null : (MgStringCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the associated coordinate system catalog for this coordinate system
 *
 * @return  The associated {@link MgCoordinateSystemCatalog} object
 */
 public MgCoordinateSystemCatalog getCatalog() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetCatalog(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemCatalog)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the CS-Map coordinate system code for this coordinate system
 *
 * @param  sCode (String/string)  The CS-Map coordinate system code
 */
 public void setCsCode(String sCode) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetCsCode(swigCPtr, sCode);
  }

  
/**
 * Checks whether the given CS-Map coordinate system code is a legal one
 *
 * @return  true if the given code is a legal one, false otherwise
 */
 public boolean isLegalCsCode(String sCode) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsLegalCsCode(swigCPtr, sCode);
  }

  
/**
 * Checks whether this coordinate system is a valid one
 *
 * @return  true if this coordinate system is a valid one. false otherwise
 */
 public boolean isValid() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsValid(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public boolean isUsable(MgCoordinateSystemCatalog pCatalog) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsUsable(swigCPtr, MgCoordinateSystemCatalog.getCPtr(pCatalog));
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public boolean isSameAs(MgGuardDisposable pDef) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsSameAs(swigCPtr, MgGuardDisposable.getCPtr(pDef));
  }

  
/**
 * Sets the description of this coordinate system
 *
 * @param  sDesc (String/string)  The description of this coordinate system
 */
 public void setDescription(String sDesc) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetDescription(swigCPtr, sDesc);
  }

  
/**
 * Checks whether this description is legal for this coordinate system
 *
 * @param  sDesc (String/string)  The description to check
 * @return  true if the given description is a legal one, false otherwise
 */
 public boolean isLegalDescription(String sDesc) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsLegalDescription(swigCPtr, sDesc);
  }

  
/**
 * Gets the group of this coordinate system
 *
 * @return  The group of this coordinate system
 */
 public String getGroup() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetGroup(swigCPtr); }
}

  
/**
 * Sets the group of this coordinate system
 *
 * @param  sGroup (String/string)  The group
 */
 public void setGroup(String sGroup) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetGroup(swigCPtr, sGroup);
  }

  
/**
 * Checks whether this group is legal for this coordinate system
 *
 * @param  sGroup (String/string)  The group to check
 * @return  true if the given group is a legal one, false otherwise
 */
 public boolean isLegalGroup(String sGroup) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsLegalGroup(swigCPtr, sGroup);
  }

  
/**
 * Gets the source of this coordinate system
 *
 * @return  The source of this coordinate system
 */
 public String getSource() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetSource(swigCPtr); }
}

  
/**
 * Sets the source of this coordinate system
 *
 * @param  sSource (String/string)  The source
 */
 public void setSource(String sSource) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetSource(swigCPtr, sSource);
  }

  
/**
 * Checks whether this source is legal for this coordinate system
 *
 * @param  sSource (String/string)  The source to check
 * @return  true if the given source is a legal one, false otherwise
 */
 public boolean isLegalSource(String sSource) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsLegalSource(swigCPtr, sSource);
  }

  
/**
 * Checks whether this coordinate system is protected
 *
 * @return  true if this coordinate system is protected. false otherwise
 */
 public boolean isProtected() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsProtected(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public short getAge() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetAge(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public void setProtectMode(boolean bIsProtected) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetProtectMode(swigCPtr, bIsProtected);
  }

  
/**
 * Checks whether this coordinate system is encrypted
 *
 * @return  true if this coordinate system is encrypted. false otherwise
 */
 public boolean isEncrypted() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsEncrypted(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public void setEncryptMode(boolean bIsEncrypted) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetEncryptMode(swigCPtr, bIsEncrypted);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public MgCoordinateSystemEnumInteger32 getErrors() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetErrors(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemEnumInteger32)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the location of this coordinate system
 *
 * @return  The location of this coordinate system
 */
 public String getLocation() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetLocation(swigCPtr); }
}

  
/**
 * Sets the location of this coordinate system
 *
 * @param  sLoc (String/string)  The location
 */
 public void setLocation(String sLoc) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetLocation(swigCPtr, sLoc);
  }

  
/**
 * Checks whether this location is legal for this coordinate system
 *
 * @param  sLoc (String/string)  The location to check
 * @return  true if the given location is a legal one, false otherwise
 */
 public boolean isLegalLocation(String sLoc) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsLegalLocation(swigCPtr, sLoc);
  }

  
/**
 * Gets the country or state of this coordinate system
 *
 * @return  The country or state of this coordinate system
 */
 public String getCountryOrState() {
  { return MapGuideJavaApiExJNI.MgCoordinateSystem_GetCountryOrState(swigCPtr); }
}

  
/**
 * Sets the country or state of this coordinate system
 *
 * @param  sCountryOrState (String/string)  The country or state
 */
 public void setCountryOrState(String sCountryOrState) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetCountryOrState(swigCPtr, sCountryOrState);
  }

  
/**
 * Checks whether this country or state is legal for this coordinate system
 *
 * @param  sCountryOrState (String/string)  The country or state to check
 * @return  true if the given country or state is a legal one, false otherwise
 */
 public boolean isLegalCountryOrState(String sCountryOrState) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsLegalCountryOrState(swigCPtr, sCountryOrState);
  }

  
/**
 * Gets whether this coordinate system is geodetic
 *
 * @return  true if this coordinate system is geodetic. false otherwise
 */
 public boolean isGeodetic() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsGeodetic(swigCPtr);
  }

  
/**
 * Gets the projection code of this coordinate system (see {@link MgCoordinateSystemProjectionCode})
 *
 * @return  The projection code of this coordinate system
 */
 public int getProjectionCode() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetProjectionCode(swigCPtr);
  }

  
/**
 * Sets the projection code for this coordinate system
 *
 * @param  prjType (int)  The projection code (see {@link MgCoordinateSystemProjectionCode})
 */
 public void setProjectionCode(int prjType) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetProjectionCode(swigCPtr, prjType);
  }

  
/**
 * Gets the unit code of this coordinate system
 *
 * @return  The unit code of this coordinate system
 */
 public int getUnitCode() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetUnitCode(swigCPtr);
  }

  
/**
 * Sets the unit code for this coordinate system
 *
 * @param  unit (int)  The unit code
 */
 public void setUnitCode(int unit) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetUnitCode(swigCPtr, unit);
  }

  
/**
 * Gets the projection parameter count of this coordinate system
 *
 * @return  The projection parameter count of this coordinate system
 */
 public int getProjectionParameterCount() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetProjectionParameterCount(swigCPtr);
  }

  
/**
 * Gets the projection parameter count of this coordinate system at the specified index
 *
 * @param  nIndex (int)  The index at which to retrieve the projection parameter
 * @return  The projection parameter at the given index
 */
 public double getProjectionParameter(int nIndex) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetProjectionParameter(swigCPtr, nIndex);
  }

  
/**
 * Sets the projection parameter of this coordinate system at the specified index
 *
 * @param  nIndex (int)  The index at which to set the projection parameter
 * @param  dValue (double)  The projection parameter value
 */
 public void setProjectionParameter(int nIndex, double dValue) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetProjectionParameter(swigCPtr, nIndex, dValue);
  }

  
/**
 * Gets the origin longitude of this coordinate system
 *
 * @return  The origin longitude of this coordinate system
 */
 public double getOriginLongitude() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetOriginLongitude(swigCPtr);
  }

  
/**
 * Sets the origin longitude for this coordinate system
 *
 * @param  dOrgLng (double)  The origin longitude
 */
 public void setOriginLongitude(double dOrgLng) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetOriginLongitude(swigCPtr, dOrgLng);
  }

  
/**
 * Gets the origin latitude of this coordinate system
 *
 * @return  The origin latitude of this coordinate system
 */
 public double getOriginLatitude() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetOriginLatitude(swigCPtr);
  }

  
/**
 * Sets the origin latitude for this coordinate system
 *
 * @param  dOrgLat (double)  The origin latitude
 */
 public void setOriginLatitude(double dOrgLat) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetOriginLatitude(swigCPtr, dOrgLat);
  }

  
/**
 * Gets the X offset of this coordinate system
 *
 * @return  The X offset of this coordinate system
 */
 public double getOffsetX() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetOffsetX(swigCPtr);
  }

  
/**
 * Gets the Y offset of this coordinate system
 *
 * @return  The Y offset of this coordinate system
 */
 public double getOffsetY() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetOffsetY(swigCPtr);
  }

  
/**
 * Sets the X and Y offsets for this coordinate system
 *
 * @param  dXOffset (double)  The X offset
 * @param  dYOffset (double)  The Y offset
 */
 public void setOffsets(double dXOffset, double dYOffset) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetOffsets(swigCPtr, dXOffset, dYOffset);
  }

  
/**
 * Gets the scale reduction of this coordinate system
 *
 * @return  The scale reduction of this coordinate system
 */
 public double getScaleReduction() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetScaleReduction(swigCPtr);
  }

  
/**
 * Sets the scale reduction for this coordinate system
 *
 * @param  dSclRed (double)  The scale reduction
 */
 public void setScaleReduction(double dSclRed) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetScaleReduction(swigCPtr, dSclRed);
  }

  
/**
 * Gets the map scale for this coordinate system
 *
 * @return  The map scale for this coordinate system
 */
 public double getMapScale() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetMapScale(swigCPtr);
  }

  
/**
 * Sets the map scale for this coordinate system
 *
 * @param  dMapScale (double)  The map scale
 */
 public void setMapScale(double dMapScale) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetMapScale(swigCPtr, dMapScale);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double getZeroX() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetZeroX(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double getZeroY() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetZeroY(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public void setZeroes(double dXZero, double dYZero) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetZeroes(swigCPtr, dXZero, dYZero);
  }

  
/**
 * Returns this system's minimum longitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double getLonMin() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetLonMin(swigCPtr);
  }

  
/**
 * Returns this system's maximum longitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double getLonMax() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetLonMax(swigCPtr);
  }

  
/**
 * Returns this system's minimum latitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double getLatMin() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetLatMin(swigCPtr);
  }

  
/**
 * Returns this system's maximum latitude value in degrees. If not set in the dictionary,
 * the value returned here has been calculated by the underlying coordinate system
 * transformation engine.
 *
 * @return  Returns this system's minimum longitude value in degrees. Only returns 0 (if it's not the
 *  actual value) if explicitely set via SetLonLatBounds or CancelLonLatBounds.
 */
 public double getLatMax() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetLatMax(swigCPtr);
  }

  
/**
 * Allows to set the min/max longitude and latitude values in degrees this coordinate system is valid in.
 * This method must only be called on systems that are not protected.
 * When setting these values, the coordinate system API will perform the following actions:
 * <ol>
 * <li>(Re-)enable valid range checking: When converting coordinates, the values are checked to fall
 *     in the valid range as specified here</li>
 * <li>Save the values for later storage: When eventually writing this coordinate system to the
 *     dictionary, the values will be written, too.</li>
 * </ol>
 *
 * @param  dLonMin  The minimum longitude value
 * @param  dLatMin  The minimum latitude value
 * @param  dLonMax  The maximum longitude value
 * @param  dLatMax  The maximum latitude value
 * @return  Nothing
 */
 public void setLonLatBounds(double dLonMin, double dLatMin, double dLonMax, double dLatMax) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetLonLatBounds(swigCPtr, dLonMin, dLatMin, dLonMax, dLatMax);
  }

  
/**
 * Cancels only the range checking for coordinate transformations, if it has been enabled
 * via SetLonLatBounds before. Specifically, calling this method does not reset the
 * min/max values on the coordinate system definition itself. That is, when eventually writing
 * this object to the dictionary, the min/max values will be written, too.
 *
 * @return  Nothing
 */
 public void cancelLonLatBounds() {
    MapGuideJavaApiExJNI.MgCoordinateSystem_CancelLonLatBounds(swigCPtr);
  }

  
/**
 * Allows to set the min/max X and Y values in the coordinate system's units that this coordinate system is valid in.
 * This method must only be called on systems that are not protected.
 * When setting these values, the coordinate system API will perform the following actions:
 * <ol>
 * <li>(Re-)enable valid range checking: When converting coordinates, the values are checked to fall
 *     in the valid range as specified here</li>
 * <li>Save the values for later storage: When eventually writing this coordinate system to the
 *     dictionary, the values will be written, too.</li>
 * </ol>
 *
 * @param  dXMin  The minimum X value
 * @param  dYMin  The minimum Y value
 * @param  dXMax  The maximum X value
 * @param  dYMax  The maximum Y value
 * @return  Nothing
 */
 public void setXYBounds(double dXMin, double dYMin, double dXMax, double dYMax) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetXYBounds(swigCPtr, dXMin, dYMin, dXMax, dYMax);
  }

  
/**
 * Cancels only the range checking for coordinate transformations, if it has been enabled via
 * SetXYBounds
 *
 */
 public void cancelXYBounds() {
    MapGuideJavaApiExJNI.MgCoordinateSystem_CancelXYBounds(swigCPtr);
  }

  
/**
 * Gets the quadrant for this coordinate system
 *
 * @return  The quadrant for this coordinate system
 */
 public short getQuadrant() {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetQuadrant(swigCPtr);
  }

  
/**
 * Sets the quadrant for this coordinate system
 *
 * @param  sQuad (short/int)  The quadrant
 */
 public void setQuadrant(short sQuad) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetQuadrant(swigCPtr, sQuad);
  }

  
/**
 * Gets the datum definition for this coordinate system
 *
 * @return  The datum definition for this coordinate system
 */
 public MgCoordinateSystemDatum getDatumDefinition() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetDatumDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDatum)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the datum for this coordinate system
 *
 * @param  pDatum ({@link MgCoordinateSystemDatum})  The datum definition
 */
 public void setDatumDefinition(MgCoordinateSystemDatum pDatum) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetDatumDefinition(swigCPtr, MgCoordinateSystemDatum.getCPtr(pDatum));
  }

  
/**
 * Gets the ellipsoid for this coordinate system
 *
 * @return  The ellipsoid for this coordinate system
 */
 public MgCoordinateSystemEllipsoid getEllipsoidDefinition() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_GetEllipsoidDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemEllipsoid)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the ellipsoid definition for this coordinate system
 *
 * @param  pEllipsoid ({@link MgCoordinateSystemEllipsoid})  The ellipsoid definition
 */
 public void setEllipsoidDefinition(MgCoordinateSystemEllipsoid pEllipsoid) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_SetEllipsoidDefinition(swigCPtr, MgCoordinateSystemEllipsoid.getCPtr(pEllipsoid));
  }

  
/**
 * Gets the given X and Y coordinates are valid within this coordinate system
 *
 * @param  dX (double)  The X coordinate
 * @param  dY (double)  The Y coordinate
 * @return  true if the coordinates are valid. false otherwise
 */
 public boolean isValidXY(double dX, double dY) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsValidXY(swigCPtr, dX, dY);
  }

  
/**
 * Gets the given longitude and latitude coordinates are valid within this coordinate system
 *
 * @param  dLongitude (double)  The longitude coordinate
 * @param  dLatitude (double)  The latitude coordinate
 * @return  true if the coordinates are valid. false otherwise
 */
 public boolean isValidLonLat(double dLongitude, double dLatitude) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_IsValidLonLat(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * Converts the specified {@link MgCoordinate} in lon/lat units to coordinate system units
 *
 * @param  lonLatToCoordinate ({@link MgCoordinate})  The {@link MgCoordinate} in lon/lat units that will be converted
 */
 public void convertCoordinateFromLonLat(MgCoordinate lonLatToCoordinate) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertCoordinateFromLonLat(swigCPtr, MgCoordinate.getCPtr(lonLatToCoordinate));
  }

  
/**
 * Converts the specified {@link MgCoordinate} in coordinate system units to lon/lat units
 *
 * @param  coordinateToLonLat ({@link MgCoordinate})  The {@link MgCoordinate} in coordinate system units that will be converted
 */
 public void convertCoordinateToLonLat(MgCoordinate coordinateToLonLat) {
    MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertCoordinateToLonLat(swigCPtr, MgCoordinate.getCPtr(coordinateToLonLat));
  }

  
/**
 * Converts the specified coordinates in coordinate system units to lon/lat units
 *
 * @param  dX (double)  The X coordinate
 * @param  dY (double)  The Y coordinate
 * @return  The {@link MgCoordinate} in lon/lat units
 */
 public MgCoordinate convertToLonLat(double dX, double dY) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertToLonLat__SWIG_1(swigCPtr, dX, dY);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified coordinates in coordinate system units to lon/lat units
 *
 * @param  dX (double)  The X coordinate
 * @param  dY (double)  The Y coordinate
 * @param  dZ (double)  The Z coordinate
 * @return  The {@link MgCoordinate} in lon/lat units
 */
 public MgCoordinate convertToLonLat(double dX, double dY, double dZ) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertToLonLat__SWIG_2(swigCPtr, dX, dY, dZ);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified coordinates in lon/lat units to coordinate system units
 *
 * @param  dLongitude (double)  The longitude coordinate
 * @param  dLatitude (double)  The latitude coordinate
 * @return  The {@link MgCoordinate} in coordinate system units
 */
 public MgCoordinate convertFromLonLat(double dLongitude, double dLatitude) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertFromLonLat__SWIG_1(swigCPtr, dLongitude, dLatitude);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Converts the specified coordinates in lon/lat units to coordinate system units
 *
 * @param  dLongitude (double)  The longitude coordinate
 * @param  dLatitude (double)  The latitude coordinate
 * @param  dZ (double)  The Z coordinate
 * @return  The {@link MgCoordinate} in coordinate system units
 */
 public MgCoordinate convertFromLonLat(double dLongitude, double dLatitude, double dZ) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_ConvertFromLonLat__SWIG_2(swigCPtr, dLongitude, dLatitude, dZ);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double getConvergence(double dLongitude, double dLatitude) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetConvergence(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double getScale(double dLongitude, double dLatitude) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetScale(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double getScaleH(double dLongitude, double dLatitude) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetScaleH(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 */
 public double getScaleK(double dLongitude, double dLatitude) {
    return MapGuideJavaApiExJNI.MgCoordinateSystem_GetScaleK(swigCPtr, dLongitude, dLatitude);
  }

  
/**
 * Gets a cloned copy of this coordinate system
 *
 * @return  The cloned copy of this coordinate system
 */
 public MgCoordinateSystem createClone() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystem_CreateClone(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystem)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
