package org.osgeo.mapguide;


/**
 * Defines various error codes returned by the Coordinate System API
 *
 */
public class MgCoordinateSystemErrorCode
{
   
/**
 * Y axis azimuth specification is invalid.
 *
 */

   public static final int AZM = 201 ; 
   
/**
 * Great circle azimuth value is invalid.
 *
 */

   public static final int AZMTH = 202 ; 
   
/**
 * Invalid latitude detected in definition.
 *
 */

   public static final int LAT = 203 ; 
   
/**
 * Latitudes of defining points are equal.
 *
 */

   public static final int LATEQU = 204 ; 
   
/**
 * Invalid longitude detected in definition.
 *
 */

   public static final int LNG = 205 ; 
   
/**
 * First defining point may not be on the equator.
 *
 */

   public static final int LNGEQU = 206 ; 
   
/**
 * Invalid map scale value detected.
 *
 */

   public static final int MAPSCL = 207 ; 
   
/**
 * Standard meridians are the same.
 *
 */

   public static final int MEREQU = 208 ; 
   
/**
 * Defining great circle is a parallel, try Mercator.
 *
 */

   public static final int MRCAT = 209 ; 
   
/**
 * Invalid coefficient value specified.
 *
 */

   public static final int MSCOEF = 210 ; 
   
/**
 * System must be referenced to a datum or an ellipsoid.
 *
 */

   public static final int NOREF = 211 ; 
   
/**
 * Standard paralells are not ordered correctly.
 *
 */

   public static final int NOTNRTH = 212 ; 
   
/**
 * Standard parallells are not ordered correctly.
 *
 */

   public static final int NRTHLAT = 213 ; 
   
/**
 * Point defining Y axis direction incorrectly specified.
 *
 */

   public static final int NRTHPNT = 214 ; 
   
/**
 * Invalid latitude value given for projection origin.
 *
 */

   public static final int ORGLAT = 215 ; 
   
/**
 * Invalid longitude value given for projection origin.
 *
 */

   public static final int ORGLNG = 216 ; 
   
/**
 * Standard parallel location exceeds 90 degrees.
 *
 */

   public static final int PLL90 = 217 ; 
   
/**
 * Standard parallel locations are the same.
 *
 */

   public static final int PLLEQU = 218 ; 
   
/**
 * Standard parallel locations not inbetween poles.
 *
 */

   public static final int PLLLRG = 219 ; 
   
/**
 * Order of standard parallels incorrect.
 *
 */

   public static final int PLLREV = 220 ; 
   
/**
 * Standard parallel location is zero.
 *
 */

   public static final int PLLZERO = 221 ; 
   
/**
 * Poles are too far apart.
 *
 */

   public static final int POLDD = 222 ; 
   
/**
 * Poles are not sufficiently separated.
 *
 */

   public static final int POLDUP = 223 ; 
   
/**
 * Latitude of pole incorrectly specified.
 *
 */

   public static final int POLLAT = 224 ; 
   
/**
 * Longitude of pole incorrectly specified.
 *
 */

   public static final int POLLNG = 225 ; 
   
/**
 * Invalid quad specification detected.
 *
 */

   public static final int QUAD = 226 ; 
   
/**
 * Invalid scale reduction value encountered.
 *
 */

   public static final int SCLRED = 227 ; 
   
/**
 * Standard parallels are not ordered correctly.
 *
 */

   public static final int SOTHLAT = 228 ; 
   
/**
 * Standard parallel is incorrectly specified.
 *
 */

   public static final int STDLAT = 229 ; 
   
/**
 * Standard meridian specification is invalid.
 *
 */

   public static final int STDLNG = 230 ; 
   
/**
 * Standard parallel specifications are invalid.
 *
 */

   public static final int STDPLL = 231 ; 
   
/**
 * Southern parallel is equal to or north of northern.
 *
 */

   public static final int STDSOU = 232 ; 
   
/**
 * Standard meridian must be east of the central meridian.
 *
 */

   public static final int STDWEST = 233 ; 
   
/**
 * Invalid unit specification detected.
 *
 */

   public static final int UNIT = 234 ; 
   
/**
 * Invalid projection key name detected.
 *
 */

   public static final int INVPRJ = 235 ; 
   
/**
 * Invalid datum name specification detected.
 *
 */

   public static final int INVDTM = 236 ; 
   
/**
 * Invalid ellipsoid name specification detected.
 *
 */

   public static final int INVELP = 237 ; 
   
/**
 * Longitude range is too small.
 *
 */

   public static final int LLRNG = 238 ; 
   
/**
 * Longitude range values out of order.
 *
 */

   public static final int RNGORD = 239 ; 
   
/**
 * Invalid quadrant specification given.
 *
 */

   public static final int INVQUAD = 240 ; 
   
/**
 * Invalid invalid geographic useful range detected.
 *
 */

   public static final int GEOMM = 241 ; 
   
/**
 * Invalid invalid cartesian useful range detected.
 *
 */

   public static final int CRTMM = 242 ; 
   
/**
 * Standard parallels must be equidistant from poles.
 *
 */

   public static final int PLLED = 243 ; 
   
/**
 * Origin latitude is not polar; use oblique form of projection.
 *
 */

   public static final int PLRLAT = 244 ; 
   
/**
 * Origin latitude is polar; use polar form of projection.
 *
 */

   public static final int USEPLR = 245 ; 
   
/**
 * Invalid value given for UTM zone number.
 *
 */

   public static final int UTMZON = 246 ; 
   
/**
 * Invalid hemisphere specification (+1 = north, -1 = south).
 *
 */

   public static final int HMISPHR = 247 ; 
   
/**
 * Central azimuth is 90, use the Swiss Oblique Mercator.
 *
 */

   public static final int USESW = 248 ; 
   
/**
 * Eastern meridian is more than 15 degrees from the central meridian.
 *
 */

   public static final int MAX15 = 249 ; 
   
/**
 * Invalid oblique pole specification.
 *
 */

   public static final int OBLQPOLE = 250 ; 
   
/**
 * Denominator of affine is zero.
 *
 */

   public static final int AFFZERO = 251 ; 
   
/**
 * Non-earth system referenced to a datum.
 *
 */

   public static final int NRDATUM = 252 ; 
   
/**
 * OSTN97.TXT grid shift file could not be located or opened with read access.
 *
 */

   public static final int OSTN97 = 253 ; 
   
/**
 * Invalid region code specified for Danish System 34/45 (1=J, 2=S, 3=B).
 *
 */

   public static final int DENRGN = 253 ; 
   
/**
 * Value supplied for elevated ellipsoid is outside acceptable range
 *
 */

   public static final int ELEVEL = 254 ; 
   
/**
 * OSTN02.TXT grid shift file could not be located or opened with read access.
 *
 */

   public static final int OSTN02 = 255 ; 
   
/**
 * Transverse Mercator Kruger formulation requested with non-zero origin latitude.
 *
 */

   public static final int TMKRG0 = 256 ; 
   
/**
 * The operation succeeded
 *
 */

   public static final int Ok = 1000 ; 
   
/**
 * The operation ran out of memory
 *
 */

   public static final int OutOfMemory = 1001 ; 
   
/**
 * An initialization operation failed
 *
 */

   public static final int InitializationFailed = 1002 ; 
   
/**
 * A conversion operation failed
 *
 */

   public static final int ConversionFailed = 1003 ; 
   
/**
 * An argument supplied to an operation was null
 *
 */

   public static final int NullArgument = 1004 ; 
   
/**
 * An argument supplied to an operation was invalid
 *
 */

   public static final int InvalidArgument = 1005 ; 
   
}

