package org.osgeo.mapguide;


/**
 * This class defines the currently supported transformation methods for
 * analytical geodetic transformations as they can be read via the
 * {@link MgCoordinateSystemGeodeticTransformDefDictionary}. That is, the constants
 * defined below are only valid for {@link MgCoordinateSystemGeodeticTransformDef} instances
 * of type {@link MgCoordinateSystemGeodeticTransformDefType}.Analytical.
 *
 */
public class MgCoordinateSystemGeodeticAnalyticalTransformationMethod
{
   
/**
 * None
 *
 */

   public static final int None = 0 ; 
   
/**
 * Three Parameter
 *
 */

   public static final int ThreeParameter = 8193 ; 
   
/**
 * Molodensky
 *
 */

   public static final int Molodensky = 8194 ; 
   
/**
 * Abridged Molodensky
 *
 */

   public static final int AbridgedMolodensky = 8195 ; 
   
/**
 * Geocentric
 *
 */

   public static final int Geocentric = 8196 ; 
   
/**
 * Four Parameter
 *
 */

   public static final int FourParameter = 8197 ; 
   
/**
 * Six Parameter
 *
 */

   public static final int SixParameter = 8198 ; 
   
/**
 * Bursa
 *
 */

   public static final int Bursa = 8199 ; 
   
/**
 * Frame
 *
 */

   public static final int Frame = 8200 ; 
   
/**
 * Seven Parameter
 *
 */

   public static final int SevenParameter = 8201 ; 
   
/**
 * Molodensky Badekas
 *
 */

   public static final int MolodenskyBadekas = 8202 ; 
   
}

