package org.osgeo.mapguide;


/**
 * This class defines the currently supported transformation methods for
 * multiple regression geodetic transformations as they can be read via the
 * {@link MgCoordinateSystemGeodeticTransformDefDictionary}. That is, the constants
 * defined below are only valid for {@link MgCoordinateSystemGeodeticTransformDef} instances
 * of type {@link MgCoordinateSystemGeodeticTransformDefType}.MultipleRegression.
 *
 */
public class MgCoordinateSystemGeodeticMultipleRegressionTransformationMethod
{
   
/**
 *  None
 *
 */

   public static final int None = 0 ; 
   
/**
 *  Multiple Regression
 *
 */

   public static final int MultipleRegression = 20481 ; 
   
/**
 *  General Polynomial EPSG
 *
 */

   public static final int GeneralPolynomialEpsg = 20482 ; 
   
}

