/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * An instance of this class allow a caller do perform a geodetic transformation (datum shift).
 * That is, this class does not operate on coordinate system level, but rather on
 * datum level.
 *
 */
 public class MgCoordinateSystemGeodeticTransformation extends MgGuardDisposable {
  private long swigCPtr;

  public MgCoordinateSystemGeodeticTransformation(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemGeodeticTransformationToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemGeodeticTransformation() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystemGeodeticTransformation(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemGeodeticTransformation obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Sets the source and target datums of this geodetic transformation
 *
 * @param  pSource ({@link MgCoordinateSystemDatum})  The source datum
 * @param  pTarget ({@link MgCoordinateSystemDatum})  The target datum
 */
 public void setSourceAndTarget(MgCoordinateSystemDatum pSource, MgCoordinateSystemDatum pTarget) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_SetSourceAndTarget(swigCPtr, MgCoordinateSystemDatum.getCPtr(pSource), MgCoordinateSystemDatum.getCPtr(pTarget));
  }

  
/**
 * Gets the source datum of this geodetic transformation
 *
 * @return  The source datum of this geodetic transformation
 */
 public MgCoordinateSystemDatum getSource() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetSource(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDatum)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the target datum of this geodetic transformation
 *
 * @return  The target datum of this geodetic transformation
 */
 public MgCoordinateSystemDatum getTarget() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetTarget(swigCPtr);
    return (cPtr == 0) ? null : (MgCoordinateSystemDatum)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Shift this datum to the specified coordinate
 *
 * @param  pLonLat ({@link MgCoordinate})  The coordinate to shift to
 */
 public void shift(MgCoordinate pLonLat) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_Shift__SWIG_0(swigCPtr, MgCoordinate.getCPtr(pLonLat));
  }

  
/**
 * Shift this datum to the specified longitude/latitude coordinate
 *
 * @param  dLongitude (double)  The longitude coordinate to shift to
 * @param  dLatitude (double)  The longitude coordinate to shift to
 */
 public MgCoordinate shift(double dLongitude, double dLatitude) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_Shift__SWIG_1(swigCPtr, dLongitude, dLatitude);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Shift this datum to the specified longitude/latitude/z coordinate
 *
 * @param  dLongitude (double)  The longitude coordinate to shift to
 * @param  dLatitude (double)  The longitude coordinate to shift to
 * @param  dZ (double)  The Z coordinate to shift to
 */
 public MgCoordinate shift(double dLongitude, double dLatitude, double dZ) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_Shift__SWIG_2(swigCPtr, dLongitude, dLatitude, dZ);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getOffsetX() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetOffsetX(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getOffsetY() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetOffsetY(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getOffsetZ() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetOffsetZ(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public void setOffset(double x, double y, double z) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_SetOffset(swigCPtr, x, y, z);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getBursaWolfeTransformRotationX() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformRotationX(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getBursaWolfeTransformRotationY() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformRotationY(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getBursaWolfeTransformRotationZ() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformRotationZ(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getBursaWolfeTransformBwScale() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetBursaWolfeTransformBwScale(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public void setBursaWolfeTransform(double dRotationX, double dRotationY, double dRotationZ, double dBwScale) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_SetBursaWolfeTransform(swigCPtr, dRotationX, dRotationY, dRotationZ, dBwScale);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public int getGeodeticTransformationMethod() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetGeodeticTransformationMethod(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public void setGeodeticTransformationMethod(int nGeodeticTransformationMethod) {
    MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_SetGeodeticTransformationMethod(swigCPtr, nGeodeticTransformationMethod);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getMaxOffset() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetMaxOffset(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public boolean isLegalOffset(double dOffset) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_IsLegalOffset(swigCPtr, dOffset);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getMaxRotation() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetMaxRotation(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public boolean isLegalRotation(double dRotation) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_IsLegalRotation(swigCPtr, dRotation);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getBwScaleMin() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetBwScaleMin(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public double getBwScaleMax() {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_GetBwScaleMax(swigCPtr);
  }

  
/**
 * Obsolete. Use {@link MgCoordinateSystemGeodeticTransformDef} and
 * {@link MgCoordinateSystemGeodeticTransformDefParams} (plus derived classes) instead.
 *
 */
 public boolean isLegalBwScale(double dBwScale) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemGeodeticTransformation_IsLegalBwScale(swigCPtr, dBwScale);
  }

}
