/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Provides operations for measuring the distance between 2
 * coordinates and the azimuth of 2 coordinates as well as
 * calculating a coordinate position given an initial
 * coordinate, an azimuth, and a distance.
 *
 */
 public class MgCoordinateSystemMeasure extends MgMeasure {
  private long swigCPtr;

  public MgCoordinateSystemMeasure(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCoordinateSystemMeasureToMgMeasure(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgCoordinateSystemMeasure() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCoordinateSystemMeasure(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCoordinateSystemMeasure obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Computes the distance between two coordinates.
 *
 * @param  coord1 ({@link MgCoordinate})  An {@link MgCoordinate} object that specifies the  first coordinate.
 * @param  coord2 ({@link MgCoordinate})  An {@link MgCoordinate} object that specifies the  second coordinate.
 * @return  Returns the distance between coord1 and coord2 as a double
 *  in meters.
 * @exception  MgCoordinateSystemMeasureFailedException
 */
 public double getDistance(MgCoordinate coord1, MgCoordinate coord2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemMeasure_GetDistance__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Computes the distance between two coordinates.
 *
 * @param  x1 (double)  The x value in coordinate system units of the  first coordinate.
 * @param  y1 (double)  The y value in coordinate system units of the  first coordinate.
 * @param  x2 (double)  The x value in coordinate system units of the  second coordinate.
 * @param  y2 (double)  The y value in coordinate system units of the  second coordinate.
 * @return  Returns the distance between (x1, y1) and (x2, y2) as a
 *  double in meters.
 * @exception  MgCoordinateSystemMeasureFailedException
 */
 public double getDistance(double x1, double y1, double x2, double y2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemMeasure_GetDistance__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Computes the angle with respect to north of a vector formed
 * by two coordinates.
 *
 * @param  coord1 ({@link MgCoordinate})  An {@link MgCoordinate} in coordinate system units  that specifies the first coordinate.
 * @param  coord2 ({@link MgCoordinate})  An {@link MgCoordinate} in coordinate system units  that specifies the second coordinate.
 * @return  Returns the azimuth (Angle with respect to
 *  North) of the vector formed by coord1 and coord2.
 * @exception  MgCoordinateSystemMeasureFailedException
 */
 public double getAzimuth(MgCoordinate coord1, MgCoordinate coord2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemMeasure_GetAzimuth__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord1), MgCoordinate.getCPtr(coord2));
  }

  
/**
 * Computes the angle with respect to the north of a vector
 * formed by two coordinates.
 *
 * @param  x1 (double)  The x value in coordinate system units of the  first coordinate.
 * @param  y1 (double)  The y value in coordinate system units of the  first coordinate.
 * @param  x2 (double)  The x value in coordinate system units of the  second coordinate.
 * @param  y2 (double)  The y value in coordinate system units of the  second coordinate.
 * @return  Returns the azimuth (Angle with respect to the
 *  North) of the vector formed by (lon1, lat1) and (lon2, lat2).
 * @exception  MgCoordinateSystemMeasureFailedException
 */
 public double getAzimuth(double x1, double y1, double x2, double y2) {
    return MapGuideJavaApiExJNI.MgCoordinateSystemMeasure_GetAzimuth__SWIG_1(swigCPtr, x1, y1, x2, y2);
  }

  
/**
 * Computes a coordinate given a distance along a vector that is
 * defined by a starting coordinate and an azimuth
 * (Angle with respect to the North).
 *
 * @param  coord ({@link MgCoordinate})  An {@link MgCoordinate} object in coordinate system  units that represents the start of the  vector.
 * @param  azimuth (double)  An azimuth (Angle with respect to the North)  that defines the direction of the vector.
 * @param  distance (double)  The distance along the vector to the desired  coordinate in meters.
 * @return  Returns an {@link MgCoordinate} object containing the x and y values
 *  in coordinate system units of a coordinate that lies the
 *  given distance along the vector.
 * @exception  MgCoordinateSystemMeasureFailedException
 */
 public MgCoordinate getCoordinate(MgCoordinate coord, double azimuth, double distance) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemMeasure_GetCoordinate__SWIG_0(swigCPtr, MgCoordinate.getCPtr(coord), azimuth, distance);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Computes a coordinate a given distance along a vector that is
 * defined by a starting coordinate and an azimuth
 * (Angle with respect to the North).
 *
 * @param  xStart (double)  The x value in coordinate system units of the  starting coordinate.
 * @param  yStart (double)  The y value in coordinate system units of the  starting coordinate.
 * @param  azimuth (double)  An azimuth (Angle with respect to the North)  that defines the direction of the vector.
 * @param  distance (double)  The distance along the vector to the desired  coordinate in meters.
 * @return  Returns an {@link MgCoordinate} object containing the x and y value
 *  in ecoordinate system units of a coordinate that lies the
 *  given distance along the vector.
 * @exception  MgCoordinateSystemMeasureFailedException
 */
 public MgCoordinate getCoordinate(double xStart, double yStart, double azimuth, double distance) {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemMeasure_GetCoordinate__SWIG_1(swigCPtr, xStart, yStart, azimuth, distance);
    return (cPtr == 0) ? null : (MgCoordinate)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Computes the envelope of the {@link MgCoordinateSystemMeasure}
 * object.
 *
 * @exception  MgCoordinateSystemMeasureFailedException
 */
 public MgEnvelope getEnvelope() {
    long cPtr = MapGuideJavaApiExJNI.MgCoordinateSystemMeasure_GetEnvelope(swigCPtr);
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
