package org.osgeo.mapguide;


/**
 * {@link MgCoordinateSystemMgrsGridSquarePosition} defines enumerated values used to
 * specify the the location desired relative to the subject MGRS grid sqaure
 * when evaluating an MGRS string.
 * Note that the values used in this enumeration match those used by the
 * CS-MAP interface.
 *
 */
public class MgCoordinateSystemMgrsGridSquarePosition
{
   
/**
 * Specifies the grid square position is not set as yet.
 *
 */

   public static final int None = 0 ; 
   
/**
 * Specifies the center of the grid square; the default previous to this
 * revision (Dec 2009).
 *
 */

   public static final int Center = 1 ; 
   
/**
 * Specifies the southwest corner of the MGRS grid square.
 *
 */

   public static final int SouthWest = 2 ; 
   
/**
 * Specifies the midpoint of the western edge of the MGRS grid square.
 *
 */

   public static final int West = 3 ; 
   
/**
 * Specifies the northwest corner of the MGRS grid square.
 *
 */

   public static final int NorthWest = 4 ; 
   
/**
 * Specifies the midpoint of the northern edge of the MGRS grid square.
 *
 */

   public static final int North = 5 ; 
   
/**
 * Specifies the southwest corner of the MGRS grid square.
 *
 */

   public static final int NorthEast = 6 ; 
   
/**
 * Specifies the midpoint of the eastern edge of the MGRS grid square.
 *
 */

   public static final int East = 7 ; 
   
/**
 * Specifies the southeast corner of the MGRS grid square.
 *
 */

   public static final int SouthEast = 8 ; 
   
/**
 * Specifies the midpoint of the southern edge of the MGRS grid square.
 *
 */

   public static final int South = 9 ; 
   
/**
 * Specifies an error return value, end of table, or other abnormal situation.
 *
 */

   public static final int Unknown = 10 ; 
   
}

