/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgCurveRingCollection} provides support for defining an ordered set of
 * curve rings.
 *
 */
 public class MgCurveRingCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgCurveRingCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgCurveRingCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgCurveRingCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgCurveRingCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of curve rings in the collection.
 *
 * @return  Returns number of curve rings in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgCurveRingCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the curve ring in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the curve ring to retrieve.
 * @return  Returns the curve ring in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgCurveRing getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgCurveRingCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgCurveRing)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the curve ring in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgCurveRing})  curve ring to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void setItem(int index, MgCurveRing value) {
    MapGuideJavaApiExJNI.MgCurveRingCollection_SetItem(swigCPtr, index, MgCurveRing.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgCurveRing})  curve ring to add to the collection.
 * @return  Returns nothing
 */
 public void add(MgCurveRing value) {
    MapGuideJavaApiExJNI.MgCurveRingCollection_Add(swigCPtr, MgCurveRing.getCPtr(value));
  }

  
/**
 * Inserts the specified curve ring at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgCurveRing})  curve ring to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void insert(int index, MgCurveRing value) {
    MapGuideJavaApiExJNI.MgCurveRingCollection_Insert(swigCPtr, index, MgCurveRing.getCPtr(value));
  }

  
/**
 * Removes all curve rings from the collection.
 *
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgCurveRingCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified curve ring from the collection.  Returns true if
 * the curve ring was successfully removed.
 *
 * @param  value ({@link MgCurveRing})  curve ring reference to remove.
 * @return  Returns true if curve ring was removed.
 */
 public boolean remove(MgCurveRing value) {
    return MapGuideJavaApiExJNI.MgCurveRingCollection_Remove(swigCPtr, MgCurveRing.getCPtr(value));
  }

  
/**
 * Removes the curve ring at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the curve ring to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgCurveRingCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified curve ring, false
 * otherwise.
 *
 * @param  value ({@link MgCurveRing})  curve ring reference to check containment of.
 * @return  True if the collection contains the specified curve ring, false
 *  otherwise.
 */
 public boolean contains(MgCurveRing value) {
    return MapGuideJavaApiExJNI.MgCurveRingCollection_Contains(swigCPtr, MgCurveRing.getCPtr(value));
  }

  
/**
 * Returns the index of the specified curve ring in the collection or -1
 * if the curve ring does not exist.
 *
 * @param  value ({@link MgCurveRing})  curve ring reference to find the index of.
 * @return  The index of the specified curve ring in the collection or -1 if the
 *  curve ring does not exist.
 */
 public int indexOf(MgCurveRing value) {
    return MapGuideJavaApiExJNI.MgCurveRingCollection_IndexOf(swigCPtr, MgCurveRing.getCPtr(value));
  }

  
/**
 * Construct a {@link MgCurveRingCollection} object
 *
 */
 public MgCurveRingCollection() {
    this(MapGuideJavaApiExJNI.new_MgCurveRingCollection(), true);
  }

}
