/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Contains the parameters used to create a file-based
 * feature source.
 *
 */
 public class MgFileFeatureSourceParams extends MgFeatureSourceParams {
  private long swigCPtr;

  public MgFileFeatureSourceParams(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgFileFeatureSourceParamsToMgFeatureSourceParams(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgFileFeatureSourceParams(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgFileFeatureSourceParams obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an empty {@link MgFileFeatureSourceParams} object.
 *
 */
 public MgFileFeatureSourceParams() {
    this(MapGuideJavaApiExJNI.new_MgFileFeatureSourceParams__SWIG_0(), true);
  }

  
/**
 * Constructs an {@link MgFileFeatureSourceParams} object
 * with the specified FDO provider name.
 *
 * @param  providerName (String/string)  The FDO provider name of the feature source  without version number. For example, OSGeo.SDF.
 */
 public MgFileFeatureSourceParams(String providerName) {
    this(MapGuideJavaApiExJNI.new_MgFileFeatureSourceParams__SWIG_1(providerName), true);
  }

  
/**
 * Constructs an {@link MgFileFeatureSourceParams} object
 * with the supplied parameters.
 *
 * @param  providerName (String/string)  The FDO provider name of the feature source  without version number. For example, OSGeo.SDF.
 * @param  spatialContextName (String/string)  The name of the spatial context. This is  a user defined spatial context for the  feature source. Only one spatial context is  supported.
 * @param  srsWkt (String/string)  An OGC WKT string representing the  coordinate system for the feature source.
 * @param  featureSchema ({@link MgFeatureSchema})  The schema definition for the feature source.
 * @return  Returns nothing.
 */
 public MgFileFeatureSourceParams(String providerName, String spatialContextName, String srsWkt, MgFeatureSchema featureSchema) {
    this(MapGuideJavaApiExJNI.new_MgFileFeatureSourceParams__SWIG_2(providerName, spatialContextName, srsWkt, MgFeatureSchema.getCPtr(featureSchema)), true);
  }

  
/**
 * Gets the FDO provider name of the feature source.
 *
 * @return  Returns the FDO provider name of the feature source.
 */
 public String getProviderName() {
  { return MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetProviderName(swigCPtr); }
}

  
/**
 * Sets the FDO provider name of the feature source.
 *
 * @param  name (String/string)  The FDO provider name of the feature source  without version number. For example, OSGeo.SDF.
 * @return  Returns nothing.
 */
 public void setProviderName(String name) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetProviderName(swigCPtr, name);
  }

  
/**
 * Gets the file name to be created. For SHP FDO provider,
 * it is used to get path name because multiple files will
 * be created if there are multiple feature classes in
 * the specified featue schame.
 *
 * @return  Returns the file name to be created.
 */
 public String getFileName() {
  { return MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetFileName(swigCPtr); }
}

  
/**
 * Sets the file name to be created. For SHP FDO provider,
 * it is used to set path name because multiple files will
 * be created if there are multiple feature classes in
 * the specified featue schame.
 *
 * @param  name (String/string)  The file name to be created.
 * @return  Returns nothing.
 */
 public void setFileName(String name) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetFileName(swigCPtr, name);
  }

  
/**
 * Gets the user-defined spatial context name.
 *
 * @return  Returns the name of the spatial context.
 */
 public String getSpatialContextName() {
  { return MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetSpatialContextName(swigCPtr); }
}

  
/**
 * Sets the user-defined spatial context name.
 *
 * @param  name (String/string)  The name of the spatial context
 * @return  Returns nothing.
 */
 public void setSpatialContextName(String name) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetSpatialContextName(swigCPtr, name);
  }

  
/**
 * Gets the spatial context description.
 *
 * @return  Returns the spatial context description.
 */
 public String getSpatialContextDescription() {
  { return MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetSpatialContextDescription(swigCPtr); }
}

  
/**
 * Sets the spatial context description.
 *
 * @param  description (String/string)  The description of the spatial  context.
 * @return  Returns nothing.
 */
 public void setSpatialContextDescription(String description) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetSpatialContextDescription(swigCPtr, description);
  }

  
/**
 * Gets the well-known text description of the coordinate system.
 *
 * @return  Returns the OGC WKT description of the coordinate system.
 */
 public String getCoordinateSystemWkt() {
  { return MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetCoordinateSystemWkt(swigCPtr); }
}

  
/**
 * Sets the well-know text string representing the coordinate system.
 *
 * @param  srsWkt (String/string)  The OGC WKT string representing the coordinate system.
 * @return  Returns nothing.
 */
 public void setCoordinateSystemWkt(String srsWkt) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetCoordinateSystemWkt(swigCPtr, srsWkt);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @return  Returns the tolerance used for the X and Y ordinates.
 */
 public double getXYTolerance() {
    return MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetXYTolerance(swigCPtr);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @param  tolerance (double)  The tolerance for the X and Y  ordinates.
 * @return  Returns nothing.
 */
 public void setXYTolerance(double tolerance) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetXYTolerance(swigCPtr, tolerance);
  }

  
/**
 * TODO: API Documentation is missing or failed to translate doxygen brief directive (message inserted by IMake.exe)
 * @return  Returns the tolerance for the Z ordinate.
 */
 public double getZTolerance() {
    return MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetZTolerance(swigCPtr);
  }

  
/**
 * Sets the tolerance for the Z ordinate.
 *
 * @param  tolerance (double)  The tolerance for the Z ordinate.
 * @return  Returns nothing.
 */
 public void setZTolerance(double tolerance) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetZTolerance(swigCPtr, tolerance);
  }

  
/**
 * Gets the feature schema definition.
 *
 * @return  Returns a feature schema definition object.
 */
 public MgFeatureSchema getFeatureSchema() {
    long cPtr = MapGuideJavaApiExJNI.MgFileFeatureSourceParams_GetFeatureSchema(swigCPtr);
    return (cPtr == 0) ? null : (MgFeatureSchema)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the feature schema definition.
 *
 * @param  featureSchema ({@link MgFeatureSchema})  The feature schema  definition.
 * @return  Returns nothing.
 */
 public void setFeatureSchema(MgFeatureSchema featureSchema) {
    MapGuideJavaApiExJNI.MgFileFeatureSourceParams_SetFeatureSchema(swigCPtr, MgFeatureSchema.getCPtr(featureSchema));
  }

}
