/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgGeometricEntity} is an abstract base class that is the root
 * of all geometry and geometry component classes.
 *
 */
 public class MgGeometricEntity extends MgSerializable {
  private long swigCPtr;

  public MgGeometricEntity(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgGeometricEntityToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgGeometricEntity() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgGeometricEntity(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgGeometricEntity obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the geometric dimension of this entity, indicating
 * whether the entity is defined by points, curves, or regions,
 * that is, is zero, one, or two dimensional.
 *
 * @return  Returns one of the values defined in {@link MgGeometricDimension}.
 */
 public int getDimension() {
    return MapGuideJavaApiExJNI.MgGeometricEntity_GetDimension(swigCPtr);
  }

  
/**
 * Tests whether this entity is empty or not.
 *
 * @return  True if the geometry is empty, false otherwise.
 */
 public boolean isEmpty() {
    return MapGuideJavaApiExJNI.MgGeometricEntity_IsEmpty(swigCPtr);
  }

  
/**
 * Tests whether this entity is simple or not. Simple entities
 * do not contain any points of self-tangency or self
 * intersection.
 *
 * @return  True if the geometry is simple, false otherwise.
 */
 public boolean isSimple() {
    return MapGuideJavaApiExJNI.MgGeometricEntity_IsSimple(swigCPtr);
  }

  
/**
 * Tests whether the entity's boundary encloses an area.
 *
 * @return  True if the geometry is closed, false otherwise.
 */
 public boolean isClosed() {
    return MapGuideJavaApiExJNI.MgGeometricEntity_IsClosed(swigCPtr);
  }

  
/**
 * Tests whether the coordinates given to construct the entity represent
 * a valid Geometry or GeometryComponent.
 * Note: Optional for MapGuide.
 *
 * @return  True if the geometry is valid, false otherwise.
 */
 public boolean isValid() {
    return MapGuideJavaApiExJNI.MgGeometricEntity_IsValid(swigCPtr);
  }

  
/**
 * Gets this geometric entity's bounding box.
 *
 * @return  Returns an {@link MgEnvelope} object representing the bounding box.
 */
 public MgEnvelope envelope() {
    long cPtr = MapGuideJavaApiExJNI.MgGeometricEntity_Envelope(swigCPtr);
    return (cPtr == 0) ? null : (MgEnvelope)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a copy of this geometric entity.
 *
 * @return  An {@link MgGeometricEntity} that is a copy of this one.
 */
 public MgGeometricEntity copy() {
    long cPtr = MapGuideJavaApiExJNI.MgGeometricEntity_Copy(swigCPtr);
    return (cPtr == 0) ? null : (MgGeometricEntity)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a transformed copy of this geometric entity.
 *
 * @param  transform ({@link MgTransform})  The {@link MgTransform} to use in constructing a copy  of this geometric entity.
 * @return  An {@link MgGeometricEntity} that is a copy of this one with each
 *  coordinate transformed.
 */
 public MgGeometricEntity transform(MgTransform transform) {
    long cPtr = MapGuideJavaApiExJNI.MgGeometricEntity_Transform(swigCPtr, MgTransform.getCPtr(transform));
    return (cPtr == 0) ? null : (MgGeometricEntity)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the area for this geometric entity or zero for
 * {@link MgLineString} and {@link MgPoint} objects. Calculates the area for
 * each {@link MgPolygon} in an {@link MgMultiPolygon} or for each
 * {@link MgCurvePolygon} in an {@link MgMultiCurvePolygon} and returns the sum
 * of areas.
 *
 * @return  The area of this geometric entity.
 */
 public double getArea() {
    return MapGuideJavaApiExJNI.MgGeometricEntity_GetArea(swigCPtr);
  }

  
/**
 * Calculates and returns the length for this geometric entity.
 * Defaults to zero for {@link MgPoint} objects.
 *
 * @return  Length of this geometric entity
 */
 public double getLength() {
    return MapGuideJavaApiExJNI.MgGeometricEntity_GetLength(swigCPtr);
  }

  
/**
 * Calculates and returns the centroid of this geometric entity.
 *
 * @return  A centroid point
 */
 public MgPoint getCentroid() {
    long cPtr = MapGuideJavaApiExJNI.MgGeometricEntity_GetCentroid(swigCPtr);
    return (cPtr == 0) ? null : (MgPoint)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
