package org.osgeo.mapguide;


/**
 * {@link MgGeometryComponentType} defines a set of integer constants
 * used to signify the type of a geometry component instance.
 *
 */
public class MgGeometryComponentType
{
   
/**
 * Specifies the geometry component is a {@link MgLinearRing}.
 *
 */

   public static final int LinearRing = 129 ; 
   
/**
 * Specifies the geometry component is an {@link MgArcSegment}.
 *
 */

   public static final int ArcSegment = 130 ; 
   
/**
 * Specifies the geometry component is an {@link MgLinearSegment}.
 *
 */

   public static final int LinearSegment = 131 ; 
   
/**
 * Specifies the geometry component is an {@link MgCurveRing}.
 *
 */

   public static final int CurveRing = 132 ; 
   
}

