/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * This class provides services to retrieve KML documents
 *
 */
 public class MgKmlService extends MgService {
  private long swigCPtr;

  public MgKmlService(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgKmlServiceToMgService(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgKmlService() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgKmlService(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgKmlService obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Returns a map definition in KML format
 *
 * @param  map  Input  map object for which to generate KML.
 * @param  dpi  Input  resolution in dots per inch
 * @param  agentUri  Input  URI of map agent that issued request
 * @param  format  Input  requested response format
 * @return  A byte reader containing the generated KML.
 */
 public MgByteReader getMapKml(MgMap map, double dpi, String agentUri, String format) {
    long cPtr = MapGuideJavaApiExJNI.MgKmlService_GetMapKml(swigCPtr, MgMap.getCPtr(map), dpi, agentUri, format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a layer definition in KML format
 *
 * @param  layer  Input  layer object for which to generate KML.
 * @param  extents  Input  required spatial data extents. The extents must be in LL84 coordinates
 * @param  width  Input  map width in pixels
 * @param  height  Input  map height in pixels
 * @param  dpi  Input  resolution in dots per inch
 * @param  drawOrder  Input  the draw order for this layer
 * @param  agentUri  Input  URI of map agent that issued request
 * @param  format  Input  requested response format
 * @return  A byte reader containing the generated KML.
 */
 public MgByteReader getLayerKml(MgLayer layer, MgEnvelope extents, int width, int height, double dpi, int drawOrder, String agentUri, String format) {
    long cPtr = MapGuideJavaApiExJNI.MgKmlService_GetLayerKml(swigCPtr, MgLayer.getCPtr(layer), MgEnvelope.getCPtr(extents), width, height, dpi, drawOrder, agentUri, format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a layer definition in KML format
 *
 * @param  layer  Input  layer object for which to generate KML.
 * @param  extents  Input  required spatial data extents. The extents must be in LL84 coordinates
 * @param  width  Input  map width in pixels
 * @param  height  Input  map height in pixels
 * @param  dpi  Input  resolution in dots per inch
 * @param  drawOrder  Input  the draw order for the layer containing these features
 * @param  format  Input  requested response format
 * @return  A byte reader containing the generated KML.
 */
 public MgByteReader getFeaturesKml(MgLayer layer, MgEnvelope extents, int width, int height, double dpi, int drawOrder, String format) {
    long cPtr = MapGuideJavaApiExJNI.MgKmlService_GetFeaturesKml__SWIG_0(swigCPtr, MgLayer.getCPtr(layer), MgEnvelope.getCPtr(extents), width, height, dpi, drawOrder, format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns a layer definition in KML format
 *
 * @param  layer  Input  layer object for which to generate KML.
 * @param  extents  Input  required spatial data extents. The extents must be in LL84 coordinates
 * @param  width  Input  map width in pixels
 * @param  height  Input  map height in pixels
 * @param  dpi  Input  resolution in dots per inch
 * @param  drawOrder  Input  the draw order for the layer containing these features
 * @param  agentUri  Input  URI of map agent that issued request
 * @param  format  Input  requested response format
 * @return  A byte reader containing the generated KML.
 */
 public MgByteReader getFeaturesKml(MgLayer layer, MgEnvelope extents, int width, int height, double dpi, int drawOrder, String agentUri, String format) {
    long cPtr = MapGuideJavaApiExJNI.MgKmlService_GetFeaturesKml__SWIG_1(swigCPtr, MgLayer.getCPtr(layer), MgEnvelope.getCPtr(extents), width, height, dpi, drawOrder, agentUri, format);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
