/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Gets and sets properties of a layer.
 *
 */
 public class MgLayer extends MgLayerBase {
  private long swigCPtr;

  public MgLayer(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgLayerToMgLayerBase(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayer() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgLayer(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayer obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Creates a {@link MgLayer} object from a layer definition.
 *
 * @param  layerDefinition ({@link MgResourceIdentifier})  Identifier of the layer definition in a  repository.
 * @param  resourceService ({@link MgResourceService})  An {@link MgResourceService} that can be used to  retrieve the layer definition.
 */
 public MgLayer(MgResourceIdentifier layerDefinition, MgResourceService resourceService) {
    this(MapGuideJavaApiExJNI.new_MgLayer(MgResourceIdentifier.getCPtr(layerDefinition), MgResourceService.getCPtr(resourceService)), true);
  }

  
/**
 * Gets the class definition for the feature class of the layer.  If the
 * feature class of the layer is extended with properties from other feature
 * classes, then all those properties are also contained in the returned
 *
 * @return  Returns an {@link MgClassDefinition} instance for the feature class of the layer.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgClassDefinition getClassDefinition() {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_GetClassDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgClassDefinition)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects features from a feature source according to the
 * criteria set in the {@link MgFeatureQueryOptions} argument The
 * criteria are applied to all of the features in the feature
 * source. If you want to apply the criteria to a subset of the
 *
 * @param  options ({@link MgFeatureQueryOptions})  {@link MgFeatureQueryOptions} instance  containing all required filters for this  select operation.
 * @return  Returns an {@link MgFeatureReader} containing the set of selected
 *  features.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgFeatureReader selectFeatures(MgFeatureQueryOptions options) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_SelectFeatures__SWIG_0(swigCPtr, MgFeatureQueryOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects features from a feature source according to the
 * criteria set in the {@link MgFeatureQueryOptions} argument The
 * criteria are applied to all of the features in the feature
 * source. If you want to apply the criteria to a subset of the
 *
 * @param  options ({@link MgFeatureQueryOptions})  {@link MgFeatureQueryOptions} instance  containing all required filters for this  select operation.
 * @param  coordinateSystem (String/string)  The WKT string of the coordinate system to transform features to
 * @return  Returns an {@link MgFeatureReader} containing the set of selected
 *  features.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader selectFeatures(MgFeatureQueryOptions options, String coordinateSystem) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_SelectFeatures__SWIG_1(swigCPtr, MgFeatureQueryOptions.getCPtr(options), coordinateSystem);
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects groups of features from a feature source and applies
 * filters to each of the groups according to the criteria set
 * in the {@link MgFeatureAggregateOptions} argument. If you want to
 * apply the criteria to all features without grouping them, use
 *
 * @param  options ({@link MgFeatureAggregateOptions})  An {@link MgFeatureAggregateOptions} instance  containing all the criteria and filters  required for this select operation.
 * @return  Returns an {@link MgDataReader} containing the group values.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 */
 public MgDataReader selectAggregate(MgFeatureAggregateOptions options) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_SelectAggregate(swigCPtr, MgFeatureAggregateOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgDataReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the {@link MgDeleteFeatures}, {@link MgInsertFeatures},
 * {@link MgUpdateFeatures}, {@link MgLockFeatures} or {@link MgUnlockFeatures} commands
 * contained in the given {@link MgFeatureCommandCollection} object.
 *
 * @param  commands ({@link MgFeatureCommandCollection})  A collection of feature commands to be  executed.
 * @return  Returns an {@link MgPropertyCollection} object. Each property in the
 *  collection corresponds to a command in the
 *  {@link MgFeatureCommandCollection} argument. The property name is the
 *  index of the command in the feature command collection.
 *  <ul>
 *    <li>If the command is of type {@link MgDeleteFeatures}, the property
 *      type is an {@link MgPropertyType}::Int32, and its value is the number
 *      of features deleted.</li>
 *    <li>If the command is of type {@link MgInsertFeatures}, the property
 *      type is an {@link MgPropertyType}::Feature, and its value is a
 *      {@link MgFeatureReader} object. The feature reader object contains
 *      the set of properties inserted into the datastore by the
 *      insert command.</li>
 *    <li>If the command is of type {@link MgUpdateFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features updated.</li>
 *    <li>If the command is of type {@link MgLockFeatures}, the property
 *      type is {@link MgPropertyType}::Feature, and its value is the number
 *      of features locked.</li>
 *    <li>If the command is of type {@link MgUnLockFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features unlocked.</li>
 *    <li>For any of the above commands, if the property type is
 *      {@link MgPropertyType}::String, it indicates an exception had occurred
 *      for that particular command, and its value is the exception message.
 *      This only applies when the operation is not using a transaction</li>
 *  </ul>
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 */
 public MgPropertyCollection updateFeatures(MgFeatureCommandCollection commands) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_UpdateFeatures__SWIG_0(swigCPtr, MgFeatureCommandCollection.getCPtr(commands));
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Starts a transaction on the this layer. The FDO provider indicated by the layer's
 * Feature Source must support transactions.
 *
 * @return  Returns an {@link MgTransaction} instance (or NULL).
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgTransaction beginTransaction() {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_BeginTransaction(swigCPtr);
    return (cPtr == 0) ? null : (MgTransaction)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the {@link MgDeleteFeatures}, {@link MgInsertFeatures},
 * {@link MgUpdateFeatures}, {@link MgLockFeatures} or {@link MgUnlockFeatures} commands
 * contained in the given {@link MgFeatureCommandCollection} object.
 *
 * @param  commands ({@link MgFeatureCommandCollection})  A collection of feature commands to be  executed.
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns an {@link MgPropertyCollection} object. Each property in the
 *  collection corresponds to a command in the
 *  {@link MgFeatureCommandCollection} argument. The property name is the
 *  index of the command in the feature command collection.
 *  <ul>
 *    <li>If the command is of type {@link MgDeleteFeatures}, the property
 *      type is an {@link MgPropertyType}::Int32, and its value is the number
 *      of features deleted.</li>
 *    <li>If the command is of type {@link MgInsertFeatures}, the property
 *      type is an {@link MgPropertyType}::Feature, and its value is a
 *      {@link MgFeatureReader} object. The feature reader object contains
 *      the set of properties inserted into the datastore by the
 *      insert command.</li>
 *    <li>If the command is of type {@link MgUpdateFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features updated.</li>
 *    <li>If the command is of type {@link MgLockFeatures}, the property
 *      type is {@link MgPropertyType}::Feature, and its value is the number
 *      of features locked.</li>
 *    <li>If the command is of type {@link MgUnLockFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features unlocked.</li>
 *  </ul>
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgPropertyCollection updateFeatures(MgFeatureCommandCollection commands, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_UpdateFeatures__SWIG_1(swigCPtr, MgFeatureCommandCollection.getCPtr(commands), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a new feature into the specified feature class of the specified Feature Source
 *
 * @param  properties ({@link MgPropertyCollection})  The collection of property values to insert
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgPropertyCollection properties, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_InsertFeatures__SWIG_0(swigCPtr, MgPropertyCollection.getCPtr(properties), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a set of new features into the specified feature class of the specified Feature Source
 *
 * @param  properties ({@link MgBatchPropertyCollection})  The collection of property values to insert. Each {@link MgPropertyCollection} within  this collection represents property values for a single feature to insert
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgBatchPropertyCollection properties, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_InsertFeatures__SWIG_1(swigCPtr, MgBatchPropertyCollection.getCPtr(properties), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Updates all features that match the given filter with the specified property values
 *
 * @param  properties ({@link MgBatchPropertyCollection})  The property values to update matching features with
 * @param  filter (String/string)  The FDO filter string that detemines what features will be updated
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns the number of features updated by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int updateMatchingFeatures(MgPropertyCollection properties, String filter, MgTransaction transaction) {
    return MapGuideJavaApiExJNI.MgLayer_UpdateMatchingFeatures(swigCPtr, MgPropertyCollection.getCPtr(properties), filter, MgTransaction.getCPtr(transaction));
  }

  
/**
 * Deletes all features that match the given filter
 *
 * @param  filter (String/string)  The FDO filter string that detemines what features will be deleted
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns the number of features deleted by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int deleteFeatures(String filter, MgTransaction transaction) {
    return MapGuideJavaApiExJNI.MgLayer_DeleteFeatures(swigCPtr, filter, MgTransaction.getCPtr(transaction));
  }

  
/**
 * Gets the list of geometry type styles for this layer at the map's current scale. Returns NULL if there are no applicable geometry types
 *
 * @return  The list of geometry type styles for this layer at the map's current scale. Returns NULL if there are no applicable geometry types
 * @since  3.0 */
 public MgIntCollection getGeometryTypeStyles() {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_GetGeometryTypeStyles__SWIG_0(swigCPtr);
    return (cPtr == 0) ? null : (MgIntCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the number of theme categories for this layer at the map's current scale for the given geometry type style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 *
 * @param  geomType (int)  The geometry type
 * @return  The number of theme categories for this layer at the map's current scale for the given geometry type style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 * @since  3.0 */
 public int getThemeCategoryCount(int geomType) {
    return MapGuideJavaApiExJNI.MgLayer_GetThemeCategoryCount__SWIG_0(swigCPtr, geomType);
  }

  
/**
 * Gets the number of composite theme categories for this layer at the map's current scale for the given composite style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 *
 * @param  compositeOffset (int)  The zero-based index denoting the particular composite style to count from. 0 = 1st composite style, 1 = 2nd composite style
 * @return  The number of theme categories for this layer at the map's current scale for the given composite style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 * @since  3.0 */
 public int getCompositeThemeCategoryCount(int compositeOffset) {
    return MapGuideJavaApiExJNI.MgLayer_GetCompositeThemeCategoryCount__SWIG_0(swigCPtr, compositeOffset);
  }

  
/**
 * Returns the legend image for the specified geometry type and theme category
 *
 * @param  resource ({@link MgResourceIdentifier})  Input  {@link MgResourceIdentifier} object identifying the layer definition resource.
 * @param  scale (double)  Input  The scale at which the symbolization is requested.
 * @param  width (int)  Input  The requested image width in pixels.
 * @param  height (int)  Input  The requested image height in pixels.
 * @param  format (String/string)  Input  Image format, from {@link MgImageFormats}. Example: PNG, JPG, PNG8, etc
 * @param  geomType (int)  Input  The type of symbolization required: 1=Point, 2=Line, 3=Area, 4=Composite
 * @param  themeCategory (int)  Input  The value indicating which theme category swatch to return.  Used when there is a theme defined at this scale. An exception will be  thrown if a requested them category doesn't exist.
 * @return  Returns a stream representing the legend image.
 *  The default returned image format will be PNG8 unless a different supported
 *  format is requested. An exception will be thrown if an unsupported image
 *  format is requested.
 * @exception  MgArgumentOutOfRangeException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgNullArgumentException
 * @exception  MgInvalidImageFormatException
 * @since  3.0 */
 public MgByteReader generateLegendImage(int width, int height, String format, int geomType, int themeCategory) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_GenerateLegendImage__SWIG_0(swigCPtr, width, height, format, geomType, themeCategory);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the list of geometry type styles for this layer at the map's current scale. Returns NULL if there are no applicable geometry types
 *
 * @param  scale (double)  The scale at which to retrive the list of applicable geometry types
 * @return  The list of geometry type styles for this layer at the map's current scale. Returns NULL if there are no applicable geometry types
 * @since  3.0 */
 public MgIntCollection getGeometryTypeStyles(double scale) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_GetGeometryTypeStyles__SWIG_1(swigCPtr, scale);
    return (cPtr == 0) ? null : (MgIntCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the number of theme categories for this layer at the map's current scale for the given geometry type style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 *
 * @param  scale (double)  The scale at which to count the number of applicable theme categories
 * @param  geomType (int)  The geometry type
 * @return  The number of theme categories for this layer at the map's current scale for the given geometry type style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 * @since  3.0 */
 public int getThemeCategoryCount(double scale, int geomType) {
    return MapGuideJavaApiExJNI.MgLayer_GetThemeCategoryCount__SWIG_1(swigCPtr, scale, geomType);
  }

  
/**
 * Gets the number of composite theme categories for this layer at the map's current scale for the given composite style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 *
 * @param  scale (double)  The scale at which to count the number of applicable theme categories
 * @param  compositeOffset (int)  The zero-based index denoting the particular composite style to count from. 0 = 1st composite style, 1 = 2nd composite style
 * @return  The number of theme categories for this layer at the map's current scale for the given composite style. A count greater than 1 indicates a themed layer. Returns -1 if there are no applicable styles at the current scale
 * @since  3.0 */
 public int getCompositeThemeCategoryCount(double scale, int compositeOffset) {
    return MapGuideJavaApiExJNI.MgLayer_GetCompositeThemeCategoryCount__SWIG_1(swigCPtr, scale, compositeOffset);
  }

  
/**
 * Returns the legend image for the specified geometry type and theme category
 *
 * @param  resource ({@link MgResourceIdentifier})  Input  {@link MgResourceIdentifier} object identifying the layer definition resource.
 * @param  scale (double)  Input  The scale at which the symbolization is requested.
 * @param  width (int)  Input  The requested image width in pixels.
 * @param  height (int)  Input  The requested image height in pixels.
 * @param  format (String/string)  Input  Image format, from {@link MgImageFormats}. Example: PNG, JPG, PNG8, etc
 * @param  geomType (int)  Input  The type of symbolization required: 1=Point, 2=Line, 3=Area, 4=Composite
 * @param  themeCategory (int)  Input  The value indicating which theme category swatch to return.  Used when there is a theme defined at this scale. An exception will be  thrown if a requested them category doesn't exist.
 * @return  Returns a stream representing the legend image.
 *  The default returned image format will be PNG8 unless a different supported
 *  format is requested. An exception will be thrown if an unsupported image
 *  format is requested.
 * @exception  MgArgumentOutOfRangeException
 * @exception  MgInvalidResourceTypeException
 * @exception  MgNullArgumentException
 * @exception  MgInvalidImageFormatException
 * @since  3.0 */
 public MgByteReader generateLegendImage(double scale, int width, int height, String format, int geomType, int themeCategory) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_GenerateLegendImage__SWIG_1(swigCPtr, scale, width, height, format, geomType, themeCategory);
    return (cPtr == 0) ? null : (MgByteReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets all of the spatial contexts available in the layer or just the active one
 *
 * @param  bActiveOnly (boolean/bool)  This flag is obsolete and no longer used.
 * @return  Returns an {@link MgSpatialContextReader} object.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgSpatialContextReader getSpatialContexts(boolean bActiveOnly) {
    long cPtr = MapGuideJavaApiExJNI.MgLayer_GetSpatialContexts(swigCPtr, bActiveOnly);
    return (cPtr == 0) ? null : (MgSpatialContextReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
