/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Gets and sets properties of a layer.
 *
 */
 public class MgLayerBase extends MgNamedSerializable {
  private long swigCPtr;

  public MgLayerBase(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgLayerBaseToMgNamedSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayerBase() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgLayerBase(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayerBase obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

    public boolean equals(Object obj) {
        boolean equal=false;
        if(obj instanceof MgLayerBase)
            equal=(((MgLayerBase)obj).swigCPtr==this.swigCPtr);
        return equal;
    }
    
    public int hashCode() {
        return (int)swigCPtr;
    }

  
/**
 * Creates an {@link MgLayerBase} object from a layer definition.
 *
 * @param  layerDefinition ({@link MgResourceIdentifier})  Identifier of the layer definition in a  repository.
 * @param  resourceService ({@link MgResourceService})  An {@link MgResourceService} that can be used to  retrieve the layer definition.
 */
 public MgLayerBase(MgResourceIdentifier layerDefinition, MgResourceService resourceService) {
    this(MapGuideJavaApiExJNI.new_MgLayerBase(MgResourceIdentifier.getCPtr(layerDefinition), MgResourceService.getCPtr(resourceService)), true);
  }

  
/**
 * Gets the name of the layer.
 *
 * @return  Returns the name of the layer as a string.
 */
 public String getName() {
  { return MapGuideJavaApiExJNI.MgLayerBase_GetName(swigCPtr); }
}

  
/**
 * Sets the name of the layer.
 *
 * @param  name (String/string)  Layer name.
 */
 public void setName(String name) {
    MapGuideJavaApiExJNI.MgLayerBase_SetName(swigCPtr, name);
  }

  
/**
 * Gets a unique identifier for this layer.
 *
 * @return  Returns the unique identifier of this map as a string.
 */
 public String getObjectId() {
  { return MapGuideJavaApiExJNI.MgLayerBase_GetObjectId(swigCPtr); }
}

  
/**
 * Gets the type of the layer.
 *
 * @return  Returns the type of the layer.
 */
 public int getLayerType() {
    return MapGuideJavaApiExJNI.MgLayerBase_GetLayerType(swigCPtr);
  }

  
/**
 * Gets the group this layer is organized within.
 *
 * @return  Returns an {@link MgLayerGroup} representing the parent group, or
 *  NULL if the layer does not belong to a group.
 */
 public MgLayerGroup getGroup() {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_GetGroup(swigCPtr);
    return (cPtr == 0) ? null : (MgLayerGroup)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Specifies which group this layer is organized within.
 *
 * @param  group ({@link MgLayerGroup})  Group this layer is organized within, or NULL to  have the layer not belong to any group.
 * @return  Returns nothing.
 */
 public void setGroup(MgLayerGroup group) {
    MapGuideJavaApiExJNI.MgLayerBase_SetGroup(swigCPtr, MgLayerGroup.getCPtr(group));
  }

  
/**
 * Determines whether the data for this layer will be refreshed
 * during the next map update.
 *
 * @return  Returns true if the layer will be refreshed, or false
 *  otherwise.
 */
 public boolean needsRefresh() {
    return MapGuideJavaApiExJNI.MgLayerBase_NeedsRefresh(swigCPtr);
  }

  
/**
 * Forces the data for this layer to be refreshed during the
 * next map update.
 *
 * @return  Returns nothing.
 */
 public void forceRefresh() {
    MapGuideJavaApiExJNI.MgLayerBase_ForceRefresh(swigCPtr);
  }

  
/**
 * Determines whether the layer is potentially visible.
 *
 * @return  Returns true if the layer is potentially visible, or false
 *  otherwise.
 */
 public boolean getVisible() {
    return MapGuideJavaApiExJNI.MgLayerBase_GetVisible(swigCPtr);
  }

  
/**
 * Sets the layer's potential visibility.
 *
 * @param  visible (boolean/bool)  True if the layer should be visible, false  otherwise.
 * @return  Returns nothing.
 */
 public void setVisible(boolean visible) {
    MapGuideJavaApiExJNI.MgLayerBase_SetVisible(swigCPtr, visible);
  }

  
/**
 * Returns the actual visibility of the layer.
 *
 * @return  Returns true if the layer is actually visible, or false
 *  otherwise.
 */
 public boolean isVisible() {
    return MapGuideJavaApiExJNI.MgLayerBase_IsVisible(swigCPtr);
  }

  
/**
 * Determines whether features on the layer are selectable.
 *
 * @return  Returns true if features are selectable on this layer, or
 *  false otherwise.
 */
 public boolean getSelectable() {
    return MapGuideJavaApiExJNI.MgLayerBase_GetSelectable(swigCPtr);
  }

  
/**
 * Specifies whether features on the layer are selectable.
 *
 * @param  selectable (boolean/bool)  True if features should be selectable on this  layer, false otherwise.
 * @return  Returns nothing.
 */
 public void setSelectable(boolean selectable) {
    MapGuideJavaApiExJNI.MgLayerBase_SetSelectable(swigCPtr, selectable);
  }

  
/**
 * Gets the layer's definition.
 *
 * @return  Returns the resource identifier of the layer's definition.
 */
 public MgResourceIdentifier getLayerDefinition() {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_GetLayerDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgResourceIdentifier)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the the layer definition for this layer.
 *
 * @param  layerDefinition ({@link MgResourceIdentifier})  Identifier of the layer definition in a  resource repository
 * @param  resourceService ({@link MgResourceService})  An {@link MgResourceService} that can be used to  retrieve the layer definition.
 * @return  Returns nothing.
 */
 public void setLayerDefinition(MgResourceIdentifier layerDefinition, MgResourceService resourceService) {
    MapGuideJavaApiExJNI.MgLayerBase_SetLayerDefinition(swigCPtr, MgResourceIdentifier.getCPtr(layerDefinition), MgResourceService.getCPtr(resourceService));
  }

  
/**
 * Determines whether an entry for the layer should appear in
 * the legend.
 *
 * @return  Returns true if the layer should appear in the legend, or
 *  false otherwise.
 */
 public boolean getDisplayInLegend() {
    return MapGuideJavaApiExJNI.MgLayerBase_GetDisplayInLegend(swigCPtr);
  }

  
/**
 * Specifies whether an entry for the layer should appear in the
 * legend.
 *
 * @param  displayInLegend (boolean/bool)  True if the layer should appear in the  legend, false otherwise.
 * @return  Returns nothing.
 */
 public void setDisplayInLegend(boolean displayInLegend) {
    MapGuideJavaApiExJNI.MgLayerBase_SetDisplayInLegend(swigCPtr, displayInLegend);
  }

  
/**
 * Determines whether the entry for the layer should initially
 * be expanded in the legend, if possible.
 *
 * @return  Returns true if the layer should initially be expanded in the legend, or
 *  false otherwise.
 */
 public boolean getExpandInLegend() {
    return MapGuideJavaApiExJNI.MgLayerBase_GetExpandInLegend(swigCPtr);
  }

  
/**
 * Gets the label to be displayed for the layer in the legend.
 *
 * @return  Returns the legend label as a string.
 */
 public String getLegendLabel() {
  { return MapGuideJavaApiExJNI.MgLayerBase_GetLegendLabel(swigCPtr); }
}

  
/**
 * Sets the label to be displayed for the layer in the legend.
 *
 * @param  legendLabel (String/string)  Legend label string.
 * @return  Returns nothing.
 */
 public void setLegendLabel(String legendLabel) {
    MapGuideJavaApiExJNI.MgLayerBase_SetLegendLabel(swigCPtr, legendLabel);
  }

  
/**
 * Gets the feature source associated with this layer
 *
 * @return  Returns the feature source or an empty string if this layer is not a feature layer
 *  false otherwise.
 */
 public String getFeatureSourceId() {
  { return MapGuideJavaApiExJNI.MgLayerBase_GetFeatureSourceId(swigCPtr); }
}

  
/**
 * Gets the feature class name associated with this layer
 *
 * @return  Returns the feature class name or an empty string if this layer is not a feature layer
 *  false otherwise.
 */
 public String getFeatureClassName() {
  { return MapGuideJavaApiExJNI.MgLayerBase_GetFeatureClassName(swigCPtr); }
}

  
/**
 * Gets the filter associated with this layer
 *
 * @return  Returns the filter or an empty string if this layer is not a feature layer or doesn't have filter.
 */
 public String getFilter() {
  { return MapGuideJavaApiExJNI.MgLayerBase_GetFilter(swigCPtr); }
}

  
/**
 * Gets the geometry name associated with this layer which is part of
 * class definition
 *
 * @return  Returns the feature geometry name or an empty string if this layer is not a feature layer
 */
 public String getFeatureGeometryName() {
  { return MapGuideJavaApiExJNI.MgLayerBase_GetFeatureGeometryName(swigCPtr); }
}

  
/**
 * Gets the class definition for the feature class of the layer.  If the
 * feature class of the layer is extended with properties from other feature
 * classes, then all those properties are also contained in the returned
 *
 * @return  Returns an {@link MgClassDefinition} instance for the feature class of the layer.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  1.2 */
 public MgClassDefinition getClassDefinition() {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_GetClassDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgClassDefinition)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects features from a feature source according to the
 * criteria set in the {@link MgFeatureQueryOptions} argument The
 * criteria are applied to all of the features in the feature
 * source. If you want to apply the criteria to a subset of the
 *
 * @param  options ({@link MgFeatureQueryOptions})  {@link MgFeatureQueryOptions} instance  containing all required filters for this  select operation.
 * @return  Returns an {@link MgFeatureReader} containing the set of selected
 *  features.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  1.2 */
 public MgFeatureReader selectFeatures(MgFeatureQueryOptions options) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_SelectFeatures__SWIG_0(swigCPtr, MgFeatureQueryOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects features from a feature source according to the
 * criteria set in the {@link MgFeatureQueryOptions} argument The
 * criteria are applied to all of the features in the feature
 * source. If you want to apply the criteria to a subset of the
 *
 * @param  options ({@link MgFeatureQueryOptions})  {@link MgFeatureQueryOptions} instance  containing all required filters for this  select operation.
 * @param  coordinateSystem (String/string)  The WKT string of the coordinate system to transform features to
 * @return  Returns an {@link MgFeatureReader} containing the set of selected
 *  features.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader selectFeatures(MgFeatureQueryOptions options, String coordinateSystem) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_SelectFeatures__SWIG_1(swigCPtr, MgFeatureQueryOptions.getCPtr(options), coordinateSystem);
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Selects groups of features from a feature source and applies
 * filters to each of the groups according to the criteria set
 * in the {@link MgFeatureAggregateOptions} argument. If you want to
 * apply the criteria to all features without grouping them, use
 *
 * @param  options ({@link MgFeatureAggregateOptions})  An {@link MgFeatureAggregateOptions} instance  containing all the criteria and filters  required for this select operation.
 * @return  Returns an {@link MgDataReader} containing the group values.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgFdoException
 * @since  1.2 */
 public MgDataReader selectAggregate(MgFeatureAggregateOptions options) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_SelectAggregate(swigCPtr, MgFeatureAggregateOptions.getCPtr(options));
    return (cPtr == 0) ? null : (MgDataReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the {@link MgDeleteFeatures}, {@link MgInsertFeatures},
 * {@link MgUpdateFeatures}, {@link MgLockFeatures} or {@link MgUnlockFeatures} commands
 * contained in the given {@link MgFeatureCommandCollection} object.
 *
 * @param  commands ({@link MgFeatureCommandCollection})  A collection of feature commands to be  executed.
 * @return  Returns an {@link MgPropertyCollection} object. Each property in the
 *  collection corresponds to a command in the
 *  {@link MgFeatureCommandCollection} argument. The property name is the
 *  index of the command in the feature command collection.
 *  <ul>
 *    <li>If the command is of type {@link MgDeleteFeatures}, the property
 *      type is an {@link MgPropertyType}::Int32, and its value is the number
 *      of features deleted.</li>
 *    <li>If the command is of type {@link MgInsertFeatures}, the property
 *      type is an {@link MgPropertyType}::Feature, and its value is a
 *      {@link MgFeatureReader} object. The feature reader object contains
 *      the set of properties inserted into the datastore by the
 *      insert command.</li>
 *    <li>If the command is of type {@link MgUpdateFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features updated.</li>
 *    <li>If the command is of type {@link MgLockFeatures}, the property
 *      type is {@link MgPropertyType}::Feature, and its value is the number
 *      of features locked.</li>
 *    <li>If the command is of type {@link MgUnLockFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features unlocked.</li>
 *  </ul>
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  1.2 */
 public MgPropertyCollection updateFeatures(MgFeatureCommandCollection commands) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_UpdateFeatures__SWIG_0(swigCPtr, MgFeatureCommandCollection.getCPtr(commands));
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Starts a transaction on the this layer. The FDO provider indicated by the layer's
 * Feature Source must support transactions.
 *
 * @return  Returns an {@link MgTransaction} instance (or NULL).
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgTransaction beginTransaction() {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_BeginTransaction(swigCPtr);
    return (cPtr == 0) ? null : (MgTransaction)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Executes the {@link MgDeleteFeatures}, {@link MgInsertFeatures},
 * {@link MgUpdateFeatures}, {@link MgLockFeatures} or {@link MgUnlockFeatures} commands
 * contained in the given {@link MgFeatureCommandCollection} object.
 *
 * @param  commands ({@link MgFeatureCommandCollection})  A collection of feature commands to be  executed.
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns an {@link MgPropertyCollection} object. Each property in the
 *  collection corresponds to a command in the
 *  {@link MgFeatureCommandCollection} argument. The property name is the
 *  index of the command in the feature command collection.
 *  <ul>
 *    <li>If the command is of type {@link MgDeleteFeatures}, the property
 *      type is an {@link MgPropertyType}::Int32, and its value is the number
 *      of features deleted.</li>
 *    <li>If the command is of type {@link MgInsertFeatures}, the property
 *      type is an {@link MgPropertyType}::Feature, and its value is a
 *      {@link MgFeatureReader} object. The feature reader object contains
 *      the set of properties inserted into the datastore by the
 *      insert command.</li>
 *    <li>If the command is of type {@link MgUpdateFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features updated.</li>
 *    <li>If the command is of type {@link MgLockFeatures}, the property
 *      type is {@link MgPropertyType}::Feature, and its value is the number
 *      of features locked.</li>
 *    <li>If the command is of type {@link MgUnLockFeatures}, the property
 *      type is {@link MgPropertyType}::Int32, and its value is the number of
 *      features unlocked.</li>
 *  </ul>
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgPropertyCollection updateFeatures(MgFeatureCommandCollection commands, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_UpdateFeatures__SWIG_1(swigCPtr, MgFeatureCommandCollection.getCPtr(commands), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgPropertyCollection)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a new feature into the specified feature class of the specified Feature Source
 *
 * @param  properties ({@link MgPropertyCollection})  The collection of property values to insert
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgPropertyCollection properties, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_InsertFeatures__SWIG_0(swigCPtr, MgPropertyCollection.getCPtr(properties), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Inserts a set of new features into the specified feature class of the specified Feature Source
 *
 * @param  properties ({@link MgBatchPropertyCollection})  The collection of property values to insert. Each {@link MgPropertyCollection} within  this collection represents property values for a single feature to insert
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns a feature reader object that contains the set of properties
 *  inserted into the datastore by the insert command.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgFeatureReader insertFeatures(MgBatchPropertyCollection properties, MgTransaction transaction) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_InsertFeatures__SWIG_1(swigCPtr, MgBatchPropertyCollection.getCPtr(properties), MgTransaction.getCPtr(transaction));
    return (cPtr == 0) ? null : (MgFeatureReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Updates all features that match the given filter with the specified property values
 *
 * @param  properties ({@link MgBatchPropertyCollection})  The property values to update matching features with
 * @param  filter (String/string)  The FDO filter string that detemines what features will be updated
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns the number of features updated by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int updateMatchingFeatures(MgPropertyCollection properties, String filter, MgTransaction transaction) {
    return MapGuideJavaApiExJNI.MgLayerBase_UpdateMatchingFeatures(swigCPtr, MgPropertyCollection.getCPtr(properties), filter, MgTransaction.getCPtr(transaction));
  }

  
/**
 * Deletes all features that match the given filter
 *
 * @param  filter (String/string)  The FDO filter string that detemines what features will be deleted
 * @param  transaction ({@link MgTransaction})  An optional transaction to execute this operation under
 * @return  Returns the number of features deleted by this operation
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public int deleteFeatures(String filter, MgTransaction transaction) {
    return MapGuideJavaApiExJNI.MgLayerBase_DeleteFeatures(swigCPtr, filter, MgTransaction.getCPtr(transaction));
  }

  
/**
 * Gets all of the spatial contexts available in the layer or just the active one
 *
 * @param  bActiveOnly (boolean/bool)  This flag is obsolete and no longer used.
 * @return  Returns an {@link MgSpatialContextReader} object.
 * @exception  MgFeatureServiceException
 * @exception  MgInvalidArgumentException
 * @exception  MgInvalidOperationException
 * @exception  MgFdoException
 * @since  3.0 */
 public MgSpatialContextReader getSpatialContexts(boolean bActiveOnly) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerBase_GetSpatialContexts(swigCPtr, bActiveOnly);
    return (cPtr == 0) ? null : (MgSpatialContextReader)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
