/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;


import java.util.Collection;
import java.util.Iterator;
import java.util.ArrayList;
import java.util.NoSuchElementException;


/**
 * Manipulates collections of {@link MgLayerGroup} objects.
 *
 */
 public class MgLayerGroupCollection extends MgGuardDisposable implements Collection<MgLayerGroup> {
  private long swigCPtr;

  public MgLayerGroupCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgLayerGroupCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayerGroupCollection() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgLayerGroupCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayerGroupCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

    /**
     * An iterator to iterate over this collection
     */
    class ItemIterator implements Iterator<MgLayerGroup> {
        private MgLayerGroupCollection _collection;
        private int _pos;
        private int _count;
        
        public ItemIterator(MgLayerGroupCollection c) { 
            _collection = c; 
            _count = _collection.getCount();
            _pos = -1;
        }
        
        /**
         * Returns true if the iteration has more elements
         */
        public boolean hasNext() {
            return _pos + 1 < _count;
        }
        
        /**
         * Returns the next MgLayerGroup in the collection
         */
        public MgLayerGroup next() {
            _pos++;
            if (_pos >= _count)
                throw new NoSuchElementException();
            return _collection.getItem(_pos);
        }
        
        /**
         * Removes from the underlying collection the last element returned by the iterator (not supported).
         */
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
    
    /**
     * Returns an iterator over the elements in this collection.
     */
    public Iterator<MgLayerGroup> iterator() { return new ItemIterator(this); }

    /**
     * Ensures that this collection contains the specified element (optional operation).
     */
    public boolean add(MgLayerGroup item) {
        this.addItem(item);
        return true;
    }

    /**
     * Adds all of the elements in the specified collection to this collection (optional operation).
     */
    public boolean addAll(Collection<? extends MgLayerGroup> c) {
        int added = 0;
        for (MgLayerGroup item : c) {
            this.addItem(item);
            added++;
        }
        return added > 0;
    }

    /**
     *  Returns true if this collection contains the specified element.
     */
    public boolean contains(Object o) {
        if (o instanceof MgLayerGroup) {
            return this.contains((MgLayerGroup)o);
        }
        return false;
    }

    /**
     * Returns true if this collection contains all of the elements in the specified collection.
     */
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!this.contains(o))
                return false;
        }
        return true;
    }

    /**
     * Returns true if this collection contains no elements.
     */
    public boolean isEmpty() { return this.getCount() == 0; }

    /**
     * Removes a single instance of the specified element from this collection, if it is present (optional operation).
     */
    public boolean remove(Object o) {
        if (o instanceof MgLayerGroup) {
            return this.remove((MgLayerGroup)o);
        }
        return false;
    }

    /**
     * Removes all of this collection's elements that are also contained in the specified collection (optional operation).
     */
    public boolean removeAll(Collection<?> c) {
        int removed = 0;
        for (Object o : c) {
            if (this.remove(o))
                removed++;
        }
        return removed > 0;
    }

    /**
     * Retains only the elements in this collection that are contained in the specified collection (optional operation).
     */
    public boolean retainAll(Collection<?> c) {
        int removed = 0;
        ArrayList<MgLayerGroup> remove = new ArrayList<MgLayerGroup>();
        for (int i = 0; i < this.getCount(); i++) {
            MgLayerGroup item = this.getItem(i);
            if (!c.contains(item))
                remove.add(item);
        }
        if (remove.size() > 0) {
            return this.removeAll(remove);
        } else {
            return false;
        }
    }

    /**
     * Returns the number of elements in this collection.
     */
    public int size() { return this.getCount(); }

    /**
     * Returns an array containing all of the elements in this collection.
     */
    public Object[] toArray() {
        int count = this.getCount();
        Object[] items = new Object[count];
        for (int i = 0; i < count; i++) {
            items[i] = this.getItem(i);
        }
        return items;
    }

    /**
     * Returns an array containing all of the elements in this collection; the runtime type of the returned array is that of the specified array.
     */
    public <MgLayerGroup> MgLayerGroup[] toArray(MgLayerGroup[] a) {
        Object[] items = this.toArray();
        if (a.length >= items.length) {
            for (int i = 0; i < items.length; i++) {
                a[i] = (MgLayerGroup)items[i];
            }
            for (int i = items.length; i < a.length; i++) {
                a[i] = null;
            }
            return a;
        } else {
            MgLayerGroup[] retVal = (MgLayerGroup[])java.lang.reflect.Array.newInstance(a.getClass().getComponentType(), items.length);
            for (int i = 0; i < retVal.length; i++) {
                retVal[i] = (MgLayerGroup)items[i];
            }
            return retVal;
        }
    }


  
/**
 * Gets the number of layer groups in the collection.
 *
 * @return  Returns the number of layer groups.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgLayerGroupCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the layer group at the specified index.
 *
 * @param  index (int)  Index of the layer group to get.
 * @return  Returns the layer group.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public MgLayerGroup getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerGroupCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLayerGroup)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Returns the layer group with the specified name.
 *
 * @param  name (String/string)  Name of the layer group to get.
 * @return  Returns the layer group.
 * @exception  MgObjectNotFoundException if the name does not exist.
 */
 public MgLayerGroup getItem(String name) {
    long cPtr = MapGuideJavaApiExJNI.MgLayerGroupCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgLayerGroup)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the layer group in the collection at the specified index to
 * the specified value.
 *
 * @param  index (int)  Position in the collection to set the layer group.
 * @param  value ({@link MgLayerGroup})  {@link MgLayerGroup} to be set in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void setItem(int index, MgLayerGroup value) {
    MapGuideJavaApiExJNI.MgLayerGroupCollection_SetItem(swigCPtr, index, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Adds a layer group to the end of the collection.
 *
 * @param  value ({@link MgLayerGroup})  Layer group to be added.
 * @return  Returns nothing.
 */
 public void addItem(MgLayerGroup value) {
    MapGuideJavaApiExJNI.MgLayerGroupCollection_addItem(swigCPtr, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Inserts a layer group at a specified location in the collection.
 *
 * @param  index (int)  Position in the collection to insert the layer group.
 * @param  value ({@link MgLayerGroup})  Layer group to be inserted in the collection.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void insert(int index, MgLayerGroup value) {
    MapGuideJavaApiExJNI.MgLayerGroupCollection_Insert(swigCPtr, index, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Removes all layer groups from the collection.
 *
 * @return  Returns nothing.
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgLayerGroupCollection_Clear(swigCPtr);
  }

  
/**
 * Removes a layer group from the collection.
 *
 * @param  value ({@link MgLayerGroup})  Layer group to be removed.
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgLayerGroup value) {
    return MapGuideJavaApiExJNI.MgLayerGroupCollection_Remove(swigCPtr, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Removes a layer group from the collection at the specified index.
 *
 * @param  index (int)  Index of the layer group to be removed.
 * @return  Returns nothing.
 * @exception  MgIndexOutOfRangeException if the specified index is out of range.
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgLayerGroupCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Determines if the collection contains the specified layer group.
 *
 * @param  name (String/string)  Name of the layer group to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean contains(String name) {
    return MapGuideJavaApiExJNI.MgLayerGroupCollection_Contains__SWIG_0(swigCPtr, name);
  }

  
/**
 * Determines if the collection contains the specified layer group.
 *
 * @param  value ({@link MgLayerGroup})  {@link MgLayerGroup} to search for.
 * @return  Returns true if the collection contains the specified item,
 *  or false otherwise.
 */
 public boolean contains(MgLayerGroup value) {
    return MapGuideJavaApiExJNI.MgLayerGroupCollection_Contains__SWIG_1(swigCPtr, MgLayerGroup.getCPtr(value));
  }

  
/**
 * Gets the index of the specified layer group in the collection.
 *
 * @param  name (String/string)  Name of the layer group to search for.
 * @return  Returns the layer group's index if the collection contains the
 *  specified layer group, or false (-1) otherwise.
 */
 public int indexOf(String name) {
    return MapGuideJavaApiExJNI.MgLayerGroupCollection_IndexOf__SWIG_0(swigCPtr, name);
  }

  
/**
 * Gets the index of the specified layer group in the collection.
 *
 * @param  value ({@link MgLayerBase})  {@link MgLayerGroup} to search for.
 * @return  Returns the layer group's index if the collection contains the
 *  specified layer group, or false (-1) otherwise.
 */
 public int indexOf(MgLayerGroup value) {
    return MapGuideJavaApiExJNI.MgLayerGroupCollection_IndexOf__SWIG_1(swigCPtr, MgLayerGroup.getCPtr(value));
  }

}
