package org.osgeo.mapguide;


/**
 * {@link MgLayerGroupType} defines integer constants used to identify
 * the type of a layer group.
 *
 */
public class MgLayerGroupType
{
   
/**
 * Specifies that the layer group is a normal layer group.
 *
 */

   public static final int Normal = 1 ; 
   
/**
 * Specifies that the layer is a base map layer group (i.e.
 * it contains base map layers).
 *
 */

   public static final int BaseMap = 2 ; 
   
/**
 * Specifies that the layer is a base map layer from a TileSetDefinition resource.
 *
 * @since  3.0 */

   public static final int BaseMapFromTileSet = 3 ; 
   
}

