/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Specifies the ResourceId of the PrintLayout to use for a particular
 * map, the title and the type of units to use in the layout.
 *
 */
 public class MgLayout extends MgSerializable {
  private long swigCPtr;

  public MgLayout(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgLayoutToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgLayout() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgLayout(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLayout obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Initializes a new {@link MgLayout} object given a layout definition, title and unit type.
 *
 * @param  layoutDefinition ({@link MgResourceIdentifier})  An {@link MgResourceIdentifier} that specifies the  location of the print layout definition in a resource  repository.
 * @param  title (String/string)  The title to use in the print layout
 * @param  unitType (String/string)  The type of units to use in the print layout
 * @return  Nothing
 */
 public MgLayout(MgResourceIdentifier layoutDefinition, String title, String unitType) {
    this(MapGuideJavaApiExJNI.new_MgLayout(MgResourceIdentifier.getCPtr(layoutDefinition), title, unitType), true);
  }

  
/**
 * Get the Layout to use when generating the EPlot DWF.  If not
 * specified, then the plotted map will fill the space within the page
 * margins.
 *
 * @return  The resource identifier for the layout definition.
 */
 public MgResourceIdentifier getLayout() {
    long cPtr = MapGuideJavaApiExJNI.MgLayout_GetLayout(swigCPtr);
    return (cPtr == 0) ? null : (MgResourceIdentifier)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Set the Layout to use when generating the EPlot DWF.  If not
 * specified, then the plotted map will fill the space within the page
 * margins.
 *
 * @param  plotLayout ({@link MgResourceIdentifier})  An {@link MgResourceIdentifier} that specifies the  location of the print layout definition in a resource  repository.
 * @return  Nothing
 */
 public void setLayout(MgResourceIdentifier plotLayout) {
    MapGuideJavaApiExJNI.MgLayout_SetLayout(swigCPtr, MgResourceIdentifier.getCPtr(plotLayout));
  }

  
/**
 * Gets the layout title.
 *
 * @return  Returns the title for the plot.
 */
 public String getTitle() {
  { return MapGuideJavaApiExJNI.MgLayout_GetTitle(swigCPtr); }
}

  
/**
 * Sets the layout title.
 *
 * @param  title (String/string)  The title for the layout.
 * @return  Returns nothing.
 */
 public void setTitle(String title) {
    MapGuideJavaApiExJNI.MgLayout_SetTitle(swigCPtr, title);
  }

  
/**
 * Gets the layout scale units (US/English or metric units).
 * This value determines the units used in the scale bar definition.
 * This value is ignored if a layout is not specified.
 *
 * @return  The layout scale units.
 */
 public String getUnitType() {
  { return MapGuideJavaApiExJNI.MgLayout_GetUnitType(swigCPtr); }
}

  
/**
 * Gets the layout scale units (US/English or metric units).
 * This value determines the units used in the scale bar definition.
 * This value is ignored if a layout is not specified.
 *
 * @param  unitType (String/string)  The layout scale units
 * @return  Returns nothing.
 */
 public void setUnitType(String unitType) {
    MapGuideJavaApiExJNI.MgLayout_SetUnitType(swigCPtr, unitType);
  }

}
