/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgLineStringCollection} provides support for defining an ordered set of
 * line strings.
 *
 */
 public class MgLineStringCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgLineStringCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgLineStringCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgLineStringCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgLineStringCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of line strings in the collection.
 *
 * @return  Returns number of line strings in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgLineStringCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the line string in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the line string to retrieve.
 * @return  Returns the line string in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgLineString getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgLineStringCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgLineString)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the line string in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgLineString})  line string to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void setItem(int index, MgLineString value) {
    MapGuideJavaApiExJNI.MgLineStringCollection_SetItem(swigCPtr, index, MgLineString.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgLineString})  line string to add to the collection.
 * @return  Returns nothing.
 */
 public void add(MgLineString value) {
    MapGuideJavaApiExJNI.MgLineStringCollection_Add(swigCPtr, MgLineString.getCPtr(value));
  }

  
/**
 * Inserts the specified line string at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgLineString})  line string to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void insert(int index, MgLineString value) {
    MapGuideJavaApiExJNI.MgLineStringCollection_Insert(swigCPtr, index, MgLineString.getCPtr(value));
  }

  
/**
 * Removes all line strings from the collection.
 *
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgLineStringCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified line string from the collection.
 *
 * @param  value ({@link MgLineString})  line string reference to remove.
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgLineString value) {
    return MapGuideJavaApiExJNI.MgLineStringCollection_Remove(swigCPtr, MgLineString.getCPtr(value));
  }

  
/**
 * Removes the line string at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the line string to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgLineStringCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified line string, false
 * otherwise.
 *
 * @param  value ({@link MgLineString})  line string reference to check containment of.
 * @return  True if the collection contains the specified line string, false
 *  otherwise.
 */
 public boolean contains(MgLineString value) {
    return MapGuideJavaApiExJNI.MgLineStringCollection_Contains(swigCPtr, MgLineString.getCPtr(value));
  }

  
/**
 * Returns the index of the specified line string in the collection or -1
 * if the line string does not exist.
 *
 * @param  value ({@link MgLineString})  line string reference to find the index of.
 * @return  The index of the specified line string in the collection or -1 if the
 *  line string does not exist.
 */
 public int indexOf(MgLineString value) {
    return MapGuideJavaApiExJNI.MgLineStringCollection_IndexOf(swigCPtr, MgLineString.getCPtr(value));
  }

  
/**
 * Construct a {@link MgLineStringCollection} object
 *
 */
 public MgLineStringCollection() {
    this(MapGuideJavaApiExJNI.new_MgLineStringCollection(), true);
  }

}
