/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Defines the runtime state of a map.
 *
 */
 public class MgMap extends MgMapBase {
  private long swigCPtr;

  public MgMap(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgMapToMgMapBase(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgMap() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgMap(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgMap obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an {@link MgMap} object that takes an {@link MgSiteConnection} instance.
 *
 * @param  siteConnection  An {@link MgSiteConnection} instance the {@link MgMap} object can use to  allocate service instances.  <!-- Example (PHP) -->
 */
 public MgMap(MgSiteConnection siteConnection) {
    this(MapGuideJavaApiExJNI.new_MgMap(MgSiteConnection.getCPtr(siteConnection)), true);
  }

  
/**
 * Initializes a new {@link MgMap} object given a map definition or tile set
 * definition and a name for the map. This method is used for
 * MapGuide Viewers or for offline map production.
 *
 * @param  resource  An {@link MgResourceIdentifier} that specifies the  location of the map definition in a resource  repository.
 * @param  mapName  A string that specifies the name of the map.
 * @return  Returns nothing.
 */
 public void create(MgResourceIdentifier resource, String mapName) {
    MapGuideJavaApiExJNI.MgMap_Create__SWIG_0(swigCPtr, MgResourceIdentifier.getCPtr(resource), mapName);
  }

  
/**
 * Initializes a new Map object given a spatial reference system,
 * spatial extent of the map, and a name for the map. This method
 * is used for the WMS service implementation and creates a map
 * without any layers.
 *
 * @param  mapSRS  A string specifying the spatial reference system in OpenGIS WKT  format.
 * @param  mapExtent  An {@link MgEnvelope} defining the overall extent of the map.
 * @param  mapName  A string that specifies the name of the map.
 */
 public void create(String mapSRS, MgEnvelope mapExtent, String mapName) {
    MapGuideJavaApiExJNI.MgMap_Create__SWIG_1(swigCPtr, mapSRS, MgEnvelope.getCPtr(mapExtent), mapName);
  }

  
/**
 * Loads the map object from a session repository.
 *
 * @param  mapName  A string that specifies the name of the map. This
 * @return  Returns nothing.
 */
 public void open(String mapName) {
    MapGuideJavaApiExJNI.MgMap_Open(swigCPtr, mapName);
  }

  
/**
 * Saves the Map using the specified resource service and
 * resource identifier.
 *
 * @param  resourceService  Resource service to use to save the Map.
 * @param  resourceId  Resource identifier.
 */
 public void save(MgResourceService resourceService, MgResourceIdentifier resourceId) {
    MapGuideJavaApiExJNI.MgMap_Save__SWIG_0(swigCPtr, MgResourceService.getCPtr(resourceService), MgResourceIdentifier.getCPtr(resourceId));
  }

  
/**
 * Saves the Map.
 *
 * @return  Returns nothing.
 */
 public void save() {
    MapGuideJavaApiExJNI.MgMap_Save__SWIG_1(swigCPtr);
  }

  
/**
 * Get the watermark usage
 *
 * @return  The integer value
 */
 public int getWatermarkUsage() {
    return MapGuideJavaApiExJNI.MgMap_GetWatermarkUsage(swigCPtr);
  }

  
/**
 * Returns the resource id of the Tile Set Definition that created
 * this map, or the Tile Set Definition linked from the Map Definition
 * used to created this map. If it was created from a Map Definition and
 * that does not link to a Tile Set Definition, then NULL is returned.
 *
 * @return  Returns the resource id of the Tile Set Definition. NULL if created from a Map Definition that does not link
 *  to a Tile Set
 * @since  3.0 */
 public MgResourceIdentifier getTileSetDefinition() {
    long cPtr = MapGuideJavaApiExJNI.MgMap_GetTileSetDefinition(swigCPtr);
    return (cPtr == 0) ? null : (MgResourceIdentifier)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

}
