/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * Manipulates collections of {@link MgMapPlot} objects.
 *
 */
 public class MgMapPlotCollection extends MgSerializable {
  private long swigCPtr;

  public MgMapPlotCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgMapPlotCollectionToMgSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgMapPlotCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgMapPlotCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of MapPlots in the collection.
 *
 * @return  Returns the number of MapPlots.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgMapPlotCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the MapPlot at the specified index.
 *
 * @param  index (int)  Index of the map to get.
 * @return  Returns the specified {@link MgMapPlot} object.
 * @exception  MgOutOfRangeException if the index is invalid.
 */
 public MgMapPlot getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgMapPlotCollection_GetItem__SWIG_0(swigCPtr, index);
    return (cPtr == 0) ? null : (MgMapPlot)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Gets the MapPlot with the specified name.
 *
 * @param  name (String/string)  Name of the MapPlot to get.
 * @return  Returns the specified {@link MgMapPlot} object.
 * @exception  MgInvalidArgumentException if the name does not exist in
 */
 public MgMapPlot getItem(String name) {
    long cPtr = MapGuideJavaApiExJNI.MgMapPlotCollection_GetItem__SWIG_1(swigCPtr, name);
    return (cPtr == 0) ? null : (MgMapPlot)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the MapPlot in the collection at the specified index to a
 * specified value.
 *
 * @param  index (int)  Position in the collection to set the  {@link MgMapPot}.
 * @param  value ({@link MgMapPlot})  {@link MgMapPlot} to be set in the collection.
 * @return  Returns nothing.
 * @exception  MgOutOfRangeException if the index is out of range.
 */
 public void setItem(int index, MgMapPlot value) {
    MapGuideJavaApiExJNI.MgMapPlotCollection_SetItem(swigCPtr, index, MgMapPlot.getCPtr(value));
  }

  
/**
 * Adds the specified MapPlot to the end of the collection.
 *
 * @param  value ({@link MgMapPlot})  {@link MgMapPlot} to be added to the collection.
 * @return  Returns nothing.
 */
 public void add(MgMapPlot value) {
    MapGuideJavaApiExJNI.MgMapPlotCollection_Add(swigCPtr, MgMapPlot.getCPtr(value));
  }

  
/**
 * Inserts a MapPlot at a specified index within the collection.
 *
 * @param  index (int)  Position in the collection to insert the  {@link MgMapPlot}.
 * @param  value ({@link MgMapPlot})  {@link MgMapPlot} to be inserted in the collection.
 * @return  Returns nothing.
 * @exception  MgOutOfRangeException if the specified index is out of
 */
 public void insert(int index, MgMapPlot value) {
    MapGuideJavaApiExJNI.MgMapPlotCollection_Insert(swigCPtr, index, MgMapPlot.getCPtr(value));
  }

  
/**
 * Removes all MapPlots from the collection.
 *
 * @return  Returns nothing.
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgMapPlotCollection_Clear(swigCPtr);
  }

  
/**
 * Removes a MapPlot from the collection.
 *
 * @param  value ({@link MgMapPlot})  {@link MgMapPlot} to be removed
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgMapPlot value) {
    return MapGuideJavaApiExJNI.MgMapPlotCollection_Remove(swigCPtr, MgMapPlot.getCPtr(value));
  }

  
/**
 * Removes a MapPlot from the collection at the specified index.
 *
 * @param  index (int)  Index of the map to be removed.
 * @return  Returns nothing.
 * @exception  MgOutOfRangeException if the MapPlot does not exist in the
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgMapPlotCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Determines if the collection contains the specified MapPlot.
 *
 * @param  name (String/string)  Name of the MapPlot.
 * @return  Returns true if the collection contains the specified map,
 *  or false otherwise.
 */
 public boolean contains(String name) {
    return MapGuideJavaApiExJNI.MgMapPlotCollection_Contains__SWIG_0(swigCPtr, name);
  }

  
/**
 * Determines if the collection contains the specified MapPlot.
 *
 * @param  value ({@link MgMapPlot})  The {@link MgMapPlot} to look for.
 * @return  Returns true if the collection contains the specified MapPlot,
 *  or false otherwise.
 */
 public boolean contains(MgMapPlot value) {
    return MapGuideJavaApiExJNI.MgMapPlotCollection_Contains__SWIG_1(swigCPtr, MgMapPlot.getCPtr(value));
  }

  
/**
 * Gets the index of the specified MapPlot in the collection.
 *
 * @param  name (String/string)  Name of the MapPlot to get the index of.
 * @return  Returns the MapPlot's index if the collection contains the
 *  specified MapPlot, or false (-1) otherwise.
 */
 public int indexOf(String name) {
    return MapGuideJavaApiExJNI.MgMapPlotCollection_IndexOf__SWIG_0(swigCPtr, name);
  }

  
/**
 * Gets the index of the specified MapPlot in the collection.
 *
 * @param  value ({@link MgMapPlot})  Value of the item to get the index of.
 * @return  Returns the MapPlot's index if the collection contains the
 *  specified MapPlot, or false (-1) otherwise.
 */
 public int indexOf(MgMapPlot value) {
    return MapGuideJavaApiExJNI.MgMapPlotCollection_IndexOf__SWIG_1(swigCPtr, MgMapPlot.getCPtr(value));
  }

  
/**
 * Constructs an empty {@link MgMapPlotCollection} object.
 *
 */
 public MgMapPlotCollection() {
    this(MapGuideJavaApiExJNI.new_MgMapPlotCollection(), true);
  }

}
