/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * The {@link MgParameter} class specifies a value for a particular parameter.
 * Instances of this class are used to specify a value to bind to a
 * parameter when a command is executed. Typically, it is used to bind
 * parameters to the SQL command.
 *
 * @since  2.2 */
 public class MgParameter extends MgNamedSerializable {
  private long swigCPtr;

  public MgParameter(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgParameterToMgNamedSerializable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected MgParameter() {
    this(0, false);
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgParameter(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgParameter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Constructs an {@link MgParameter} object. The default parameter direction
 * is input.
 *
 * @param  prop ({@link MgNullableProperty})  An {@link MgNullableProperty} instance which contains  the name and value of the parameter.
 */
 public MgParameter(MgNullableProperty prop) {
    this(MapGuideJavaApiExJNI.new_MgParameter__SWIG_0(MgNullableProperty.getCPtr(prop)), true);
  }

  
/**
 * Constructs an {@link MgParameter} object with the specified parameter
 * name, value, and direction.
 *
 * @param  prop ({@link MgNullableProperty})  An {@link MgNullableProperty} instance which contains  the name and value of the parameter.
 * @param  direction (int)  The function direction of the parameter value.
 */
 public MgParameter(MgNullableProperty prop, int direction) {
    this(MapGuideJavaApiExJNI.new_MgParameter__SWIG_1(MgNullableProperty.getCPtr(prop), direction), true);
  }

  
/**
 * Sets the name and value of the parameter.
 *
 * @param  prop ({@link MgNullableProperty})  Input an {@link MgNullableProperty} instance which contains  the name and value of the parameter.
 * @return  Returns nothing
 */
 public void setProperty(MgNullableProperty prop) {
    MapGuideJavaApiExJNI.MgParameter_SetProperty(swigCPtr, MgNullableProperty.getCPtr(prop));
  }

  
/**
 * Gets the name and value of the parameter.
 *
 * @return  Returns an {@link MgNullableProperty} instance which contains
 *  the name and value of the parameter.
 */
 public MgNullableProperty getProperty() {
    long cPtr = MapGuideJavaApiExJNI.MgParameter_GetProperty(swigCPtr);
    return (cPtr == 0) ? null : (MgNullableProperty)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the function direction of the parameter value, which
 * is defined in {@link MgParameterDirection}.
 *
 * @param  value  Input the direction value.
 * @return  Returns nothing.
 */
 public void setDirection(int value) {
    MapGuideJavaApiExJNI.MgParameter_SetDirection(swigCPtr, value);
  }

  
/**
 * Gets the function direction value of the the command parameter, which
 * is defined in {@link MgParameterDirection}.
 *
 * @return  Returns the direction value defined in {@link MgParameterDirection}.
 */
 public int getDirection() {
    return MapGuideJavaApiExJNI.MgParameter_GetDirection(swigCPtr);
  }

  
/**
 * Gets the parameter name.
 *
 * @return  Returns the parameter name.
 */
 public String getName() {
  { return MapGuideJavaApiExJNI.MgParameter_GetName(swigCPtr); }
}

  
/**
 * Sets the parameter name.
 *
 * @param  name (String/string)  The name of parameter.
 */
 public void setName(String name) {
    MapGuideJavaApiExJNI.MgParameter_SetName(swigCPtr, name);
  }

}
