/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version: 1.3.21
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.osgeo.mapguide;



/**
 * {@link MgPolygonCollection} provides support for defining an ordered set of
 * polygons.
 *
 */
 public class MgPolygonCollection extends MgGuardDisposable {
  private long swigCPtr;

  public MgPolygonCollection(long cPtr, boolean cMemoryOwn) {
    super(MapGuideJavaApiExJNI.SWIGMgPolygonCollectionToMgGuardDisposable(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected void finalize() {
    delete();
  }

  public void delete() {
    if(swigCPtr != 0 && swigCMemOwn) {
      swigCMemOwn = false;
      MapGuideJavaApiExJNI.delete_MgPolygonCollection(swigCPtr);
    }
    swigCPtr = 0;
    super.delete();
  }

  protected static long getCPtr(MgPolygonCollection obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  
/**
 * Gets the number of polygons in the collection.
 *
 * @return  Returns number of polygons in the collection.
 */
 public int getCount() {
    return MapGuideJavaApiExJNI.MgPolygonCollection_GetCount(swigCPtr);
  }

  
/**
 * Gets the polygon in the collection at the specified index. Throws
 * an invalid argument exception if the index is out of range.
 *
 * @param  index (int)  Index of the polygon to retrieve.
 * @return  Returns the polygon in the collection at the specified index.
 * @exception  MgIndexOutOfRangeException
 */
 public MgPolygon getItem(int index) {
    long cPtr = MapGuideJavaApiExJNI.MgPolygonCollection_GetItem(swigCPtr, index);
    return (cPtr == 0) ? null : (MgPolygon)ObjectFactory.createObject(MapGuideJavaApiExJNI.getClassId(cPtr), cPtr, true);
  }

  
/**
 * Sets the polygon in the collection at the specified index to the
 * specified value. Throws an invalid argument exception if the index is
 * out of range.
 *
 * @param  index (int)  Index of the coordinate to set.
 * @param  value ({@link MgPolygon})  polygon to place into the collection.
 * @exception  MgIndexOutOfRangeException
 */
 public void setItem(int index, MgPolygon value) {
    MapGuideJavaApiExJNI.MgPolygonCollection_SetItem(swigCPtr, index, MgPolygon.getCPtr(value));
  }

  
/**
 * Adds the specified coordinate to the end of the collection.
 *
 * @param  value ({@link MgPolygon})  polygon to add to the collection.
 * @return  Returns nothing
 */
 public void add(MgPolygon value) {
    MapGuideJavaApiExJNI.MgPolygonCollection_Add(swigCPtr, MgPolygon.getCPtr(value));
  }

  
/**
 * Inserts the specified polygon at the specified index within the
 * collection. Items following the insertion point are moved down to
 * accommodate the new item. Throws an invalid argument exception if the
 * specified index is out of range.
 *
 * @param  index (int)  Index at which to insert the coordinate.
 * @param  value ({@link MgPolygon})  polygon to insert.
 * @exception  MgIndexOutOfRangeException
 */
 public void insert(int index, MgPolygon value) {
    MapGuideJavaApiExJNI.MgPolygonCollection_Insert(swigCPtr, index, MgPolygon.getCPtr(value));
  }

  
/**
 * Removes all polygons from the collection.
 *
 */
 public void clear() {
    MapGuideJavaApiExJNI.MgPolygonCollection_Clear(swigCPtr);
  }

  
/**
 * Removes the specified polygon from the collection.
 *
 * @param  value ({@link MgPolygon})  polygon reference to remove.
 * @return  Returns true if removal was successful.
 */
 public boolean remove(MgPolygon value) {
    return MapGuideJavaApiExJNI.MgPolygonCollection_Remove(swigCPtr, MgPolygon.getCPtr(value));
  }

  
/**
 * Removes the polygon at the specified index from the collection.
 * Throws an invalid argument exception if the index does not exist within
 * the collection.
 *
 * @param  index (int)  Index of the polygon to remove.
 * @exception  MgIndexOutOfRangeException
 */
 public void removeAt(int index) {
    MapGuideJavaApiExJNI.MgPolygonCollection_RemoveAt(swigCPtr, index);
  }

  
/**
 * Returns true if the collection contains the specified polygon, false
 * otherwise.
 *
 * @param  value ({@link MgPolygon})  polygon reference to check containment of.
 * @return  True if the collection contains the specified polygon, false
 *  otherwise.
 */
 public boolean contains(MgPolygon value) {
    return MapGuideJavaApiExJNI.MgPolygonCollection_Contains(swigCPtr, MgPolygon.getCPtr(value));
  }

  
/**
 * Returns the index of the specified polygon in the collection or -1
 * if the polygon does not exist.
 *
 * @param  value ({@link MgPolygon})  polygon reference to find the index of.
 * @return  The index of the specified polygon in the collection or -1 if the
 *  polygon does not exist.
 */
 public int indexOf(MgPolygon value) {
    return MapGuideJavaApiExJNI.MgPolygonCollection_IndexOf(swigCPtr, MgPolygon.getCPtr(value));
  }

  
/**
 * Construct a {@link MgPolygonCollection} object
 *
 */
 public MgPolygonCollection() {
    this(MapGuideJavaApiExJNI.new_MgPolygonCollection(), true);
  }

}
